/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.TreeSet;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedContextConfiguration
implements Serializable {
    private static final long serialVersionUID = -3290560718464957422L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private final Class<?> testClass;
    private final String[] locations;
    private final Class<?>[] classes;
    private final String[] activeProfiles;
    private final ContextLoader contextLoader;

    private static String[] processLocations(String[] locations) {
        return locations == null ? EMPTY_STRING_ARRAY : locations;
    }

    private static Class<?>[] processClasses(Class<?>[] classes) {
        return classes == null ? EMPTY_CLASS_ARRAY : classes;
    }

    private static String[] processActiveProfiles(String[] activeProfiles) {
        if (activeProfiles == null) {
            return EMPTY_STRING_ARRAY;
        }
        TreeSet<String> sortedProfilesSet = new TreeSet<String>((Collection)Arrays.asList(activeProfiles));
        return StringUtils.toStringArray(sortedProfilesSet);
    }

    private static String nullSafeToString(ContextLoader contextLoader) {
        return contextLoader == null ? "null" : contextLoader.getClass().getName();
    }

    public MergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, String[] activeProfiles, ContextLoader contextLoader) {
        this.testClass = testClass;
        this.locations = MergedContextConfiguration.processLocations(locations);
        this.classes = MergedContextConfiguration.processClasses(classes);
        this.activeProfiles = MergedContextConfiguration.processActiveProfiles(activeProfiles);
        this.contextLoader = contextLoader;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + Arrays.hashCode(this.activeProfiles);
        result = 31 * result + MergedContextConfiguration.nullSafeToString(this.contextLoader).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MergedContextConfiguration)) {
            return false;
        }
        MergedContextConfiguration that = (MergedContextConfiguration)obj;
        if (!Arrays.equals(this.locations, that.locations)) {
            return false;
        }
        if (!Arrays.equals(this.classes, that.classes)) {
            return false;
        }
        if (!Arrays.equals(this.activeProfiles, that.activeProfiles)) {
            return false;
        }
        return MergedContextConfiguration.nullSafeToString(this.contextLoader).equals(MergedContextConfiguration.nullSafeToString(that.contextLoader));
    }

    public String toString() {
        return new ToStringCreator(this).append("testClass", this.testClass).append("locations", ObjectUtils.nullSafeToString(this.locations)).append("classes", ObjectUtils.nullSafeToString(this.classes)).append("activeProfiles", ObjectUtils.nullSafeToString(this.activeProfiles)).append("contextLoader", MergedContextConfiguration.nullSafeToString(this.contextLoader)).toString();
    }
}

