/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.dom;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.cfg.ErrorConsts;
import com.ctc.wstx.exc.WstxParsingException;
import com.ctc.wstx.io.WstxInputLocation;
import com.ctc.wstx.util.EmptyIterator;
import com.ctc.wstx.util.EmptyNamespaceContext;
import com.ctc.wstx.util.SingletonIterator;
import com.ctc.wstx.util.TextAccumulator;
import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.AttributeInfo;
import org.codehaus.stax2.DTDInfo;
import org.codehaus.stax2.LocationInfo;
import org.codehaus.stax2.XMLStreamLocation2;
import org.codehaus.stax2.XMLStreamReader2;
import org.codehaus.stax2.validation.DTDValidationSchema;
import org.codehaus.stax2.validation.ValidationProblemHandler;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.codehaus.stax2.validation.XMLValidator;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMWrappingReader
implements XMLStreamReader2,
DTDInfo,
LocationInfo,
NamespaceContext,
XMLStreamConstants {
    private static final int MASK_GET_TEXT = 6768;
    private static final int MASK_GET_ELEMENT_TEXT = 4688;
    protected final ReaderConfig mConfig;
    protected final String mSystemId;
    protected final Node mRootNode;
    protected final boolean mNsAware;
    protected int mCurrEvent = 7;
    protected Node mCurrNode;
    protected int mDepth = 0;
    protected List mAttrList = null;
    protected List mNsDeclList = null;

    private DOMWrappingReader(ReaderConfig cfg, Node treeRoot, String sysId) throws XMLStreamException {
        if (treeRoot == null) {
            throw new IllegalArgumentException("Can not pass null Node for constructing a DOM-based XMLStreamReader");
        }
        this.mConfig = cfg;
        this.mNsAware = cfg.willSupportNamespaces();
        this.mSystemId = sysId;
        switch (treeRoot.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                break;
            }
            default: {
                throw new XMLStreamException("Can not create an XMLStreamReader for a DOM node of type " + treeRoot.getClass());
            }
        }
        this.mRootNode = this.mCurrNode = treeRoot;
    }

    public static DOMWrappingReader createFrom(ReaderConfig cfg, DOMSource src) throws XMLStreamException {
        Node rootNode = src.getNode();
        String systemId = src.getSystemId();
        return new DOMWrappingReader(cfg, rootNode, systemId);
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getEncoding() {
        return this.getCharacterEncodingScheme();
    }

    public String getVersion() {
        return null;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean standaloneSet() {
        return false;
    }

    public Object getProperty(String name) {
        return this.mConfig.getProperty(name);
    }

    public int getAttributeCount() {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        return this.mAttrList.size();
    }

    public String getAttributeLocalName(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return attr.getLocalName();
    }

    public QName getAttributeName(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return this.constructQName(attr.getNamespaceURI(), attr.getLocalName(), attr.getPrefix());
    }

    public String getAttributeNamespace(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return attr.getNamespaceURI();
    }

    public String getAttributePrefix(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return attr.getPrefix();
    }

    public String getAttributeType(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return "CDATA";
    }

    public String getAttributeValue(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        if (this.mAttrList == null) {
            this.calcNsAndAttrLists(true);
        }
        if (index >= this.mAttrList.size() || index < 0) {
            this.handleIllegalAttrIndex(index);
            return null;
        }
        Attr attr = (Attr)this.mAttrList.get(index);
        return attr.getValue();
    }

    public String getAttributeValue(String nsURI, String localName) {
        Attr attr;
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        Element elem = (Element)this.mCurrNode;
        NamedNodeMap attrs = elem.getAttributes();
        if (nsURI != null && nsURI.length() == 0) {
            nsURI = null;
        }
        return (attr = (Attr)attrs.getNamedItemNS(nsURI, localName)) == null ? null : attr.getValue();
    }

    public String getElementText() throws XMLStreamException {
        int type;
        if (this.mCurrEvent != 1) {
            this.throwParseError(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        TextAccumulator acc = new TextAccumulator();
        while ((type = this.next()) != 2) {
            if (type == 5 || type == 3) continue;
            if ((1 << type & 0x1250) == 0) {
                this.throwParseError("Expected a text token, got " + ErrorConsts.tokenTypeDesc(type) + ".");
            }
            acc.addText(this.getText());
        }
        return acc.getAndClear();
    }

    public int getEventType() {
        return this.mCurrEvent;
    }

    public String getLocalName() {
        if (this.mCurrEvent == 1 || this.mCurrEvent == 2) {
            return this.mCurrNode.getLocalName();
        }
        if (this.mCurrEvent == 9) {
            return this.mCurrNode.getNodeName();
        }
        throw new IllegalStateException("Current state (" + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ") not START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE");
    }

    public QName getName() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this.constructQName(this.mCurrNode.getNamespaceURI(), this.mCurrNode.getLocalName(), this.mCurrNode.getPrefix());
    }

    public NamespaceContext getNamespaceContext() {
        return this;
    }

    public int getNamespaceCount() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        if (this.mNsDeclList == null) {
            if (!this.mNsAware) {
                return 0;
            }
            this.calcNsAndAttrLists(this.mCurrEvent == 1);
        }
        return this.mNsDeclList.size() / 2;
    }

    public String getNamespacePrefix(int index) {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        if (this.mNsDeclList == null) {
            if (!this.mNsAware) {
                this.handleIllegalNsIndex(index);
            }
            this.calcNsAndAttrLists(this.mCurrEvent == 1);
        }
        if (index < 0 || index + index >= this.mNsDeclList.size()) {
            this.handleIllegalNsIndex(index);
        }
        return (String)this.mNsDeclList.get(index + index);
    }

    public String getNamespaceURI() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this.mCurrNode.getNamespaceURI();
    }

    public String getNamespaceURI(int index) {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        if (this.mNsDeclList == null) {
            if (!this.mNsAware) {
                this.handleIllegalNsIndex(index);
            }
            this.calcNsAndAttrLists(this.mCurrEvent == 1);
        }
        if (index < 0 || index + index >= this.mNsDeclList.size()) {
            this.handleIllegalNsIndex(index);
        }
        return (String)this.mNsDeclList.get(index + index + 1);
    }

    public String getPIData() {
        if (this.mCurrEvent != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this.mCurrNode.getNodeValue();
    }

    public String getPITarget() {
        if (this.mCurrEvent != 3) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_PI);
        }
        return this.mCurrNode.getNodeName();
    }

    public String getPrefix() {
        if (this.mCurrEvent != 1 && this.mCurrEvent != 2) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_ELEM);
        }
        return this.mCurrNode.getPrefix();
    }

    public String getText() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return this.mCurrNode.getNodeValue();
    }

    public char[] getTextCharacters() {
        String text = this.getText();
        return text.toCharArray();
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int len) {
        String text;
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        if (len > (text = this.getText()).length()) {
            len = text.length();
        }
        text.getChars(sourceStart, sourceStart + len, target, targetStart);
        return len;
    }

    public int getTextLength() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return this.getText().length();
    }

    public int getTextStart() {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        return 0;
    }

    public boolean hasName() {
        return this.mCurrEvent == 1 || this.mCurrEvent == 2;
    }

    public boolean hasNext() {
        return this.mCurrEvent != 8;
    }

    public boolean hasText() {
        return (1 << this.mCurrEvent & 0x1A70) != 0;
    }

    public boolean isAttributeSpecified(int index) {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        Element elem = (Element)this.mCurrNode;
        Attr attr = (Attr)elem.getAttributes().item(index);
        if (attr == null) {
            this.handleIllegalAttrIndex(index);
            return false;
        }
        return attr.getSpecified();
    }

    public boolean isCharacters() {
        return this.mCurrEvent == 4;
    }

    public boolean isEndElement() {
        return this.mCurrEvent == 2;
    }

    public boolean isStartElement() {
        return this.mCurrEvent == 1;
    }

    public boolean isWhiteSpace() {
        if (this.mCurrEvent == 4 || this.mCurrEvent == 12) {
            String text = this.getText();
            int len = text.length();
            for (int i = 0; i < len; ++i) {
                if (text.charAt(i) > ' ') continue;
                return false;
            }
            return true;
        }
        return this.mCurrEvent == 6;
    }

    public void require(int type, String nsUri, String localName) throws XMLStreamException {
        int curr = this.mCurrEvent;
        if (curr != type) {
            if (curr == 12) {
                curr = 4;
            } else if (curr == 6) {
                curr = 4;
            }
        }
        if (type != curr) {
            this.throwParseError("Expected type " + ErrorConsts.tokenTypeDesc(type) + ", current type " + ErrorConsts.tokenTypeDesc(curr));
        }
        if (localName != null) {
            String n;
            if (curr != 1 && curr != 2 && curr != 9) {
                this.throwParseError("Expected non-null local name, but current token not a START_ELEMENT, END_ELEMENT or ENTITY_REFERENCE (was " + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ")");
            }
            if ((n = this.getLocalName()) != localName && !n.equals(localName)) {
                this.throwParseError("Expected local name '" + localName + "'; current local name '" + n + "'.");
            }
        }
        if (nsUri != null) {
            if (curr != 1 && curr != 2) {
                this.throwParseError("Expected non-null NS URI, but current token not a START_ELEMENT or END_ELEMENT (was " + ErrorConsts.tokenTypeDesc(curr) + ")");
            }
            String uri = this.getNamespaceURI();
            if (nsUri.length() == 0) {
                if (uri != null && uri.length() > 0) {
                    this.throwParseError("Expected empty namespace, instead have '" + uri + "'.");
                }
            } else if (nsUri != uri && !nsUri.equals(uri)) {
                this.throwParseError("Expected namespace '" + nsUri + "'; have '" + uri + "'.");
            }
        }
    }

    public int next() throws XMLStreamException {
        block0 : switch (this.mCurrEvent) {
            case 7: {
                switch (this.mCurrNode.getNodeType()) {
                    case 9: 
                    case 11: {
                        this.mCurrNode = this.mCurrNode.getFirstChild();
                        break block0;
                    }
                    case 1: {
                        this.mCurrEvent = 1;
                        return 1;
                    }
                }
                throw new XMLStreamException("Internal error: unexpected DOM root node type " + this.mCurrNode.getNodeType() + " for node '" + this.mCurrNode + "'");
            }
            case 8: {
                throw new NoSuchElementException("Can not call next() after receiving END_DOCUMENT");
            }
            case 1: {
                ++this.mDepth;
                this.mAttrList = null;
                Node firstChild = this.mCurrNode.getFirstChild();
                if (firstChild == null) {
                    this.mCurrEvent = 2;
                    return 2;
                }
                this.mNsDeclList = null;
                this.mCurrNode = firstChild;
                break;
            }
            case 2: {
                --this.mDepth;
                this.mAttrList = null;
                this.mNsDeclList = null;
                if (this.mCurrNode == this.mRootNode) {
                    this.mCurrEvent = 8;
                    return 8;
                }
            }
            default: {
                Node next = this.mCurrNode.getNextSibling();
                if (next != null) {
                    this.mCurrNode = next;
                    break;
                }
                this.mCurrNode = this.mCurrNode.getParentNode();
                short type = this.mCurrNode.getNodeType();
                if (type == 1) {
                    this.mCurrEvent = 2;
                    return 2;
                }
                if (this.mCurrNode != this.mRootNode || type != 9 && type != 11) {
                    throw new XMLStreamException("Internal error: non-element parent node (" + type + ") that is not the initial root node");
                }
                this.mCurrEvent = 8;
                return 8;
            }
        }
        switch (this.mCurrNode.getNodeType()) {
            case 4: {
                this.mCurrEvent = 12;
                break;
            }
            case 8: {
                this.mCurrEvent = 5;
                break;
            }
            case 10: {
                this.mCurrEvent = 11;
                break;
            }
            case 1: {
                this.mCurrEvent = 1;
                break;
            }
            case 5: {
                this.mCurrEvent = 9;
                break;
            }
            case 7: {
                this.mCurrEvent = 3;
                break;
            }
            case 3: {
                this.mCurrEvent = 4;
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                throw new XMLStreamException("Internal error: unexpected DOM node type " + this.mCurrNode.getNodeType() + " (attr/entity/notation?), for node '" + this.mCurrNode + "'");
            }
            default: {
                throw new XMLStreamException("Internal error: unrecognized DOM node type " + this.mCurrNode.getNodeType() + ", for node '" + this.mCurrNode + "'");
            }
        }
        return this.mCurrEvent;
    }

    public int nextTag() throws XMLStreamException {
        block5: while (true) {
            int next = this.next();
            switch (next) {
                case 3: 
                case 5: 
                case 6: {
                    continue block5;
                }
                case 4: 
                case 12: {
                    if (this.isWhiteSpace()) continue block5;
                    this.throwParseError("Received non-all-whitespace CHARACTERS or CDATA event in nextTag().");
                    break;
                }
                case 1: 
                case 2: {
                    return next;
                }
            }
            this.throwParseError("Received event " + ErrorConsts.tokenTypeDesc(next) + ", instead of START_ELEMENT or END_ELEMENT.");
        }
    }

    public void close() throws XMLStreamException {
    }

    public String getNamespaceURI(String prefix) {
        return null;
    }

    public String getPrefix(String namespaceURI) {
        return null;
    }

    public Iterator getPrefixes(String namespaceURI) {
        String prefix = this.getPrefix(namespaceURI);
        if (prefix == null) {
            return EmptyIterator.getInstance();
        }
        return new SingletonIterator(prefix);
    }

    public Object getFeature(String name) {
        throw new IllegalArgumentException(MessageFormat.format(ErrorConsts.ERR_UNKNOWN_FEATURE, name));
    }

    public void setFeature(String name, Object value) {
        throw new IllegalArgumentException(MessageFormat.format(ErrorConsts.ERR_UNKNOWN_FEATURE, name));
    }

    public boolean isPropertySupported(String name) {
        return this.mConfig.isPropertySupported(name);
    }

    public boolean setProperty(String name, Object value) {
        return this.mConfig.setProperty(name, value);
    }

    public void skipElement() throws XMLStreamException {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        int nesting = 1;
        while (true) {
            int type;
            if ((type = this.next()) == 1) {
                ++nesting;
                continue;
            }
            if (type == 2 && --nesting == 0) break;
        }
    }

    public AttributeInfo getAttributeInfo() throws XMLStreamException {
        if (this.mCurrEvent != 1) {
            throw new IllegalStateException(ErrorConsts.ERR_STATE_NOT_STELEM);
        }
        return null;
    }

    public DTDInfo getDTDInfo() throws XMLStreamException {
        if (this.mCurrEvent != 11) {
            return null;
        }
        return this;
    }

    public final LocationInfo getLocationInfo() {
        return this;
    }

    public int getText(Writer w, boolean preserveContents) throws IOException, XMLStreamException {
        if ((1 << this.mCurrEvent & 0x1A70) == 0) {
            this.throwNotTextual(this.mCurrEvent);
        }
        String text = this.getText();
        w.write(text);
        return text.length();
    }

    public int getDepth() {
        return this.mDepth;
    }

    public boolean isEmptyElement() throws XMLStreamException {
        return false;
    }

    public NamespaceContext getNonTransientNamespaceContext() {
        return EmptyNamespaceContext.getInstance();
    }

    public String getPrefixedName() {
        switch (this.mCurrEvent) {
            case 1: 
            case 2: {
                String prefix = this.getPrefix();
                String ln2 = this.getLocalName();
                if (prefix == null) {
                    return ln2;
                }
                StringBuffer sb = new StringBuffer(ln2.length() + 1 + prefix.length());
                sb.append(prefix);
                sb.append(':');
                sb.append(ln2);
                return sb.toString();
            }
            case 9: {
                return this.getLocalName();
            }
            case 3: {
                return this.getPITarget();
            }
            case 11: {
                return this.getDTDRootName();
            }
        }
        throw new IllegalStateException("Current state (" + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ") not START_ELEMENT, END_ELEMENT, ENTITY_REFERENCE, PROCESSING_INSTRUCTION or DTD");
    }

    public void closeCompletely() throws XMLStreamException {
    }

    public Object getProcessedDTD() {
        return null;
    }

    public String getDTDRootName() {
        if (this.mCurrEvent == 11) {
            return ((DocumentType)this.mCurrNode).getName();
        }
        return null;
    }

    public String getDTDPublicId() {
        if (this.mCurrEvent == 11) {
            return ((DocumentType)this.mCurrNode).getPublicId();
        }
        return null;
    }

    public String getDTDSystemId() {
        if (this.mCurrEvent == 11) {
            return ((DocumentType)this.mCurrNode).getSystemId();
        }
        return null;
    }

    public String getDTDInternalSubset() {
        return null;
    }

    public DTDValidationSchema getProcessedDTDSchema() {
        return null;
    }

    public long getStartingByteOffset() {
        return -1L;
    }

    public long getStartingCharOffset() {
        return 0L;
    }

    public long getEndingByteOffset() throws XMLStreamException {
        return -1L;
    }

    public long getEndingCharOffset() throws XMLStreamException {
        return -1L;
    }

    public final Location getLocation() {
        return this.getStartLocation();
    }

    public XMLStreamLocation2 getStartLocation() {
        return null;
    }

    public XMLStreamLocation2 getCurrentLocation() {
        return null;
    }

    public final XMLStreamLocation2 getEndLocation() throws XMLStreamException {
        return null;
    }

    public XMLValidator validateAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidationSchema schema) throws XMLStreamException {
        return null;
    }

    public XMLValidator stopValidatingAgainst(XMLValidator validator) throws XMLStreamException {
        return null;
    }

    public ValidationProblemHandler setValidationProblemHandler(ValidationProblemHandler h) {
        return null;
    }

    private QName constructQName(String uri, String ln2, String prefix) {
        return new QName(uri == null ? "" : uri, ln2, prefix == null ? "" : prefix);
    }

    private void calcNsAndAttrLists(boolean attrsToo) {
        NamedNodeMap attrsIn = this.mCurrNode.getAttributes();
        int len = attrsIn.getLength();
        if (len == 0) {
            this.mAttrList = this.mNsDeclList = Collections.EMPTY_LIST;
            return;
        }
        if (!this.mNsAware) {
            this.mAttrList = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                this.mAttrList.add(attrsIn.item(i));
            }
            this.mNsDeclList = Collections.EMPTY_LIST;
            return;
        }
        ArrayList<Node> attrsOut = null;
        ArrayList<String> nsOut = null;
        for (int i = 0; i < len; ++i) {
            Node attr = attrsIn.item(i);
            String prefix = attr.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                if (!"xmlns".equals(attr.getLocalName())) {
                    if (!attrsToo) continue;
                    if (attrsOut == null) {
                        attrsOut = new ArrayList<Node>(len - i);
                    }
                    attrsOut.add(attr);
                    continue;
                }
                prefix = "";
            } else {
                if (!"xmlns".equals(prefix)) {
                    if (!attrsToo) continue;
                    if (attrsOut == null) {
                        attrsOut = new ArrayList(len - i);
                    }
                    attrsOut.add(attr);
                    continue;
                }
                prefix = attr.getLocalName();
            }
            if (nsOut == null) {
                nsOut = new ArrayList<String>((len - i) * 2);
            }
            nsOut.add(prefix);
            nsOut.add(attr.getNodeValue());
        }
        this.mAttrList = attrsOut == null ? Collections.EMPTY_LIST : attrsOut;
        this.mNsDeclList = nsOut == null ? Collections.EMPTY_LIST : nsOut;
    }

    protected WstxInputLocation getLastCharLocation() {
        return null;
    }

    private void throwNotTextual(int type) {
        throw new IllegalStateException("Not a textual event (" + ErrorConsts.tokenTypeDesc(this.mCurrEvent) + ")");
    }

    public void throwParseError(String msg) throws WstxParsingException {
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    public void throwParseError(String format, Object arg) throws WstxParsingException {
        String msg = MessageFormat.format(format, arg);
        throw new WstxParsingException(msg, this.getLastCharLocation());
    }

    public void handleIllegalAttrIndex(int index) {
        Element elem = (Element)this.mCurrNode;
        NamedNodeMap attrs = elem.getAttributes();
        int len = attrs.getLength();
        String msg = "Illegal attribute index " + index + "; element <" + elem.getNodeName() + "> has " + (len == 0 ? "no" : String.valueOf(len)) + " attributes";
        throw new IllegalArgumentException(msg);
    }

    public void handleIllegalNsIndex(int index) {
        Element elem = (Element)this.mCurrNode;
        String msg = "Illegal namespace declaration index " + index + " (has " + this.getNamespaceCount() + " ns declarations)";
        throw new IllegalArgumentException(msg);
    }
}

