/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.is;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import com.gc.iotools.stream.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputStreamFromOutputStream<T>
extends InputStream {
    private static final List<String> ACTIVE_THREAD_NAMES = Collections.synchronizedList(new ArrayList());
    private static int defaultPipeSize = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(DataProducer.class);
    private boolean closeCalled = false;
    private final Future<T> futureResult;
    private final boolean joinOnClose;
    private final PipedInputStream pipedIS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String[] getActiveThreadNames() {
        String[] result;
        List<String> list = ACTIVE_THREAD_NAMES;
        synchronized (list) {
            result = ACTIVE_THREAD_NAMES.toArray(new String[0]);
        }
        return result;
    }

    @Deprecated
    public static void setDefaultBufferSize(int defaultPipeSize) {
        InputStreamFromOutputStream.defaultPipeSize = defaultPipeSize;
    }

    public static void setDefaultPipeSize(int defaultPipeSize) {
        InputStreamFromOutputStream.defaultPipeSize = defaultPipeSize;
    }

    public InputStreamFromOutputStream() {
        this(ExecutionModel.THREAD_PER_INSTANCE);
    }

    public InputStreamFromOutputStream(boolean joinOnClose, ExecutionModel executionModel) {
        this(joinOnClose, ExecutorServiceFactory.getExecutor(executionModel));
    }

    public InputStreamFromOutputStream(boolean joinOnClose, ExecutorService executor) {
        this(joinOnClose, executor, defaultPipeSize);
    }

    public InputStreamFromOutputStream(boolean joinOnClose, ExecutorService executor, int pipeBufferSize) {
        String callerId = LogUtils.getCaller(this.getClass());
        this.joinOnClose = joinOnClose;
        PipedOutputStream pipedOS = null;
        try {
            this.pipedIS = new MyPipedInputStream(pipeBufferSize);
            pipedOS = new PipedOutputStream(this.pipedIS);
        }
        catch (IOException e2) {
            throw new RuntimeException("Error during pipe creaton", e2);
        }
        DataProducer executingCallable = new DataProducer(callerId, pipedOS);
        this.futureResult = executor.submit(executingCallable);
        LOG.debug("thread invoked by[{}] queued for start.", (Object)callerId);
    }

    public InputStreamFromOutputStream(ExecutionModel executionModel) {
        this(false, executionModel);
    }

    public InputStreamFromOutputStream(ExecutorService executor) {
        this(false, executor);
    }

    protected void afterClose() {
    }

    private void checkException() throws IOException {
        try {
            this.futureResult.get();
        }
        catch (ExecutionException e2) {
            Throwable t = e2.getCause();
            IOException e1 = new IOException("Exception producing data");
            e1.initCause(t);
            throw e1;
        }
        catch (InterruptedException e3) {
            IOException e1 = new IOException("Thread interrupted");
            e1.initCause(e3);
            throw e1;
        }
    }

    @Override
    public final void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.pipedIS.close();
            if (this.joinOnClose) {
                try {
                    this.getResult();
                }
                catch (Exception e2) {
                    IOException e1 = new IOException("The internal stream threw exception");
                    e1.initCause(e2);
                    throw e1;
                }
            }
            this.afterClose();
        }
    }

    public T getResult() throws Exception {
        T result;
        if (!this.closeCalled) {
            throw new IllegalStateException("getResult() called before close().This method can be called only after the stream has been closed.");
        }
        try {
            result = this.futureResult.get();
        }
        catch (ExecutionException e2) {
            Throwable cause = e2.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e2;
        }
        return result;
    }

    protected abstract T produce(OutputStream var1) throws Exception;

    @Override
    public final int read() throws IOException {
        int result = this.pipedIS.read();
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    @Override
    public final int read(byte[] b, int off, int len) throws IOException {
        int result = this.pipedIS.read(b, off, len);
        if (result < 0) {
            this.checkException();
        }
        return result;
    }

    private final class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataProducer
    implements Callable<T> {
        private final String name;
        private final OutputStream outputStream;

        DataProducer(String threadName, OutputStream ostream) {
            this.outputStream = ostream;
            this.name = threadName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object result;
            String threadName = this.getName();
            ACTIVE_THREAD_NAMES.add(threadName);
            LOG.debug("thread [" + threadName + "] started.");
            try {
                result = InputStreamFromOutputStream.this.produce(this.outputStream);
            }
            finally {
                this.closeStream();
                ACTIVE_THREAD_NAMES.remove(threadName);
                LOG.debug("thread [" + threadName + "] closed.");
            }
            return result;
        }

        private void closeStream() {
            try {
                this.outputStream.close();
            }
            catch (IOException e2) {
                if (e2.getMessage() != null && e2.getMessage().indexOf("closed") > 0) {
                    LOG.debug("Stream already closed");
                } else {
                    LOG.error("IOException closing OutputStream Thread might be locked", e2);
                }
            }
            catch (Throwable t) {
                LOG.error("Error closing InputStream Thread might be locked", t);
            }
        }

        String getName() {
            return this.name;
        }
    }
}

