/*
 * Decompiled with CFR 0.152.
 */
package com.github.jsonldjava.core;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RemoteDocument;
import com.github.jsonldjava.utils.JsonUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;

public class DocumentLoader {
    private Map<String, Object> m_injectedDocs = new HashMap<String, Object>();
    public static final String DISALLOW_REMOTE_CONTEXT_LOADING = "com.github.jsonldjava.disallowRemoteContextLoading";
    @Deprecated
    public static final String ACCEPT_HEADER = "application/ld+json, application/json;q=0.9, application/javascript;q=0.5, text/javascript;q=0.5, text/plain;q=0.2, */*;q=0.1";
    private volatile CloseableHttpClient httpClient;

    public DocumentLoader addInjectedDoc(String url, String doc) throws JsonLdError {
        try {
            this.m_injectedDocs.put(url, JsonUtils.fromString(doc));
            return this;
        }
        catch (Exception e2) {
            throw new JsonLdError(JsonLdError.Error.LOADING_INJECTED_CONTEXT_FAILED, url, e2);
        }
    }

    public RemoteDocument loadDocument(String url) throws JsonLdError {
        RemoteDocument doc = new RemoteDocument(url, null);
        if (this.m_injectedDocs.containsKey(url)) {
            try {
                doc.setDocument(this.m_injectedDocs.get(url));
            }
            catch (Exception e2) {
                throw new JsonLdError(JsonLdError.Error.LOADING_INJECTED_CONTEXT_FAILED, url, e2);
            }
            return doc;
        }
        String disallowRemote = System.getProperty(DISALLOW_REMOTE_CONTEXT_LOADING);
        if ("true".equalsIgnoreCase(disallowRemote)) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, "Remote context loading has been disallowed (url was " + url + ")");
        }
        try {
            doc.setDocument(JsonUtils.fromURL(new URL(url), this.getHttpClient()));
        }
        catch (Exception e3) {
            throw new JsonLdError(JsonLdError.Error.LOADING_REMOTE_CONTEXT_FAILED, url, e3);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CloseableHttpClient getHttpClient() {
        CloseableHttpClient result = this.httpClient;
        if (result != null) return result;
        Class<DocumentLoader> clazz = DocumentLoader.class;
        synchronized (DocumentLoader.class) {
            result = this.httpClient;
            if (result != null) return result;
            this.httpClient = JsonUtils.getDefaultHttpClient();
            return this.httpClient;
        }
    }

    public void setHttpClient(CloseableHttpClient nextHttpClient) {
        this.httpClient = nextHttpClient;
    }
}

