/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.management;

import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.management.ConsoleRequest;
import com.hazelcast.impl.management.ManagementCenterService;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DetectDeadlockRequest
implements ConsoleRequest {
    public int getType() {
        return 7;
    }

    public Object readResponse(DataInput in) throws IOException {
        int size = in.readInt();
        ArrayList<Edge> list = new ArrayList<Edge>(size);
        for (int i = 0; i < size; ++i) {
            Data d = new Data();
            d.readData(in);
            Edge e2 = (Edge)IOUtil.toObject(d);
            list.add(e2);
        }
        return list;
    }

    public void writeResponse(ManagementCenterService mcs, DataOutput dos) throws Exception {
        List<Edge> list = mcs.detectDeadlock();
        dos.writeInt(list == null ? 0 : list.size());
        for (Edge edge : list) {
            Data data = IOUtil.toData(edge);
            data.writeData(dos);
        }
    }

    public void writeData(DataOutput out) throws IOException {
    }

    public void readData(DataInput in) throws IOException {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Vertex
    implements Serializable {
        int NOT_VISITED = 0;
        int BEING_VISITED = 1;
        int DONE_VISITED = 2;
        int visited = this.NOT_VISITED;
        DistributedLock owner;
        List<Edge> incomings = new ArrayList<Edge>();
        List<Edge> outgoings = new ArrayList<Edge>();

        Vertex(DistributedLock owner) {
            this.owner = owner;
        }

        public void addIncoming(Edge edge) {
            this.incomings.add(edge);
        }

        public void addOutgoing(Edge edge) {
            this.outgoings.add(edge);
        }

        public Vertex visit(List<Edge> list) {
            if (this.visited == this.BEING_VISITED) {
                return this;
            }
            if (this.visited == this.DONE_VISITED) {
                return null;
            }
            this.visited = this.BEING_VISITED;
            for (Edge edge : this.outgoings) {
                Vertex v2 = edge.to.visit(list);
                if (v2 == null) continue;
                list.add(edge);
                if (v2 == this) {
                    throw new RuntimeException("Cycle is detected!");
                }
                return v2;
            }
            this.visited = this.DONE_VISITED;
            return null;
        }

        public int getVisited() {
            return this.visited;
        }

        public DistributedLock getOwner() {
            return this.owner;
        }

        public List<Edge> getIncomings() {
            return this.incomings;
        }

        public List<Edge> getOutgoings() {
            return this.outgoings;
        }

        public String name() {
            return this.owner.getLockAddress() + ":" + this.owner.getLockThreadId();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Vertex vertex = (Vertex)o;
            return !(this.owner != null ? !this.owner.getLockAddress().equals(vertex.owner.getLockAddress()) || this.owner.getLockThreadId() != vertex.owner.getLockThreadId() : vertex.owner != null);
        }

        public int hashCode() {
            return this.owner != null ? this.owner.hashCode() : 0;
        }

        public String toString() {
            return "Vertex{outgoings=" + this.outgoings + "," + this.owner + ", visited=" + this.visited + '}';
        }
    }

    public static class Edge
    implements Serializable {
        Vertex from;
        Vertex to;
        Object key;
        String mapName;
        boolean globalLock;

        public String toString() {
            return "Edge{to=" + this.to.owner.getLockAddress() + this.to.owner.getLockThreadId() + ", key=" + this.key + '}';
        }

        public boolean isGlobalLock() {
            return this.globalLock;
        }

        public void setGlobalLock(boolean globalLock) {
            this.globalLock = globalLock;
        }

        public String getMapName() {
            return this.mapName;
        }

        public void setMapName(String mapName) {
            this.mapName = mapName;
        }

        public Vertex getFrom() {
            return this.from;
        }

        public Vertex getTo() {
            return this.to;
        }

        public Object getKey() {
            return this.key;
        }

        public void setFrom(Vertex from) {
            this.from = from;
        }

        public void setTo(Vertex to) {
            this.to = to;
        }

        public void setKey(Object key) {
            this.key = key;
        }
    }
}

