/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.assemblers;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.Content;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.ContentAssembler;
import com.hp.hpl.jena.assembler.assemblers.PrefixMappingAssembler;
import com.hp.hpl.jena.assembler.exceptions.TransactionAbortedException;
import com.hp.hpl.jena.assembler.exceptions.UnknownStyleException;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.iterator.Map1;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Iterator;
import java.util.List;

public abstract class ModelAssembler
extends AssemblerBase
implements Assembler {
    protected abstract Model openEmptyModel(Assembler var1, Resource var2, Mode var3);

    protected Model openModel(Assembler a, Resource root2, Content initial, Mode mode) {
        Model m = this.openEmptyModel(a, root2, mode);
        if (!initial.isEmpty()) {
            this.addContent(root2, m, initial);
        }
        return m;
    }

    public Object open(Assembler a, Resource root2, Mode mode) {
        Model m = this.openModel(a, root2, this.getInitialContent(a, root2), mode);
        this.addContent(root2, m, this.getContent(a, root2));
        m.setNsPrefixes(this.getPrefixMapping(a, root2));
        return m;
    }

    protected void addContent(Resource root2, Model m, Content c) {
        if (m.supportsTransactions()) {
            m.begin();
            try {
                c.fill(m);
                m.commit();
            }
            catch (Throwable t) {
                m.abort();
                throw new TransactionAbortedException(root2, t);
            }
        } else {
            c.fill(m);
        }
    }

    public static ReificationStyle getReificationStyle(Resource root2) {
        Resource r = ModelAssembler.getUniqueResource(root2, JA.reificationMode);
        return r == null ? ReificationStyle.Standard : ModelAssembler.styleFor(root2, r);
    }

    public static ReificationStyle styleFor(Resource root2, Resource r) {
        if (((Object)r).equals(JA.minimal)) {
            return ReificationStyle.Minimal;
        }
        if (((Object)r).equals(JA.standard)) {
            return ReificationStyle.Standard;
        }
        if (((Object)r).equals(JA.convenient)) {
            return ReificationStyle.Convenient;
        }
        throw new UnknownStyleException(root2, r);
    }

    private PrefixMapping getPrefixMapping(Assembler a, Resource root2) {
        return PrefixMappingAssembler.getPrefixes(a, root2, PrefixMapping.Factory.create());
    }

    public Model openModel(Resource root2, Mode mode) {
        return (Model)this.open(this, root2, mode);
    }

    protected Content getInitialContent(Assembler a, Resource root2) {
        Model partial = ModelFactory.createDefaultModel();
        Resource combined = partial.createResource();
        StmtIterator it = root2.listProperties(JA.initialContent);
        while (it.hasNext()) {
            this.transferContentProperties(partial, it.nextStatement().getResource(), combined);
        }
        return this.contentFromModel(a, root2, partial, combined);
    }

    private Content contentFromModel(Assembler a, Resource root2, Model partial, Resource combined) {
        return partial.isEmpty() ? Content.empty : (Content)a.open(this.completedClone(root2, combined, partial));
    }

    protected Content getContent(Assembler a, Resource root2) {
        Resource newRoot = this.oneLevelClone(root2);
        Model fragment = newRoot.getModel();
        return fragment.isEmpty() ? Content.empty : (Content)a.open(a, this.completedClone(root2, newRoot, fragment));
    }

    private Resource completedClone(Resource root2, Resource newRoot, Model fragment) {
        Model typed = fragment.add(newRoot, RDF.type, JA.Content);
        return (Resource)newRoot.inModel(ModelFactory.createUnion(root2.getModel(), typed));
    }

    private Resource oneLevelClone(Resource root2) {
        Model partialCopy = ModelFactory.createDefaultModel();
        Resource newRoot = partialCopy.createResource();
        this.transferContentProperties(partialCopy, root2, newRoot);
        return newRoot;
    }

    private void transferContentProperties(Model partial, Resource someInitial, Resource combined) {
        Map1 replace = this.replaceSubjectMap(partial, combined);
        Iterator it = ContentAssembler.contentProperties.iterator();
        while (it.hasNext()) {
            partial.add(this.copyProperties(someInitial, replace, (Property)it.next()));
        }
    }

    private List copyProperties(Resource root2, Map1 replace, Property property) {
        return root2.listProperties(property).mapWith(replace).toList();
    }

    private Map1 replaceSubjectMap(final Model inModel, final Resource newSubject) {
        Map1 replace = new Map1(){

            public Object map1(Object o) {
                Statement s = (Statement)o;
                return inModel.createStatement(newSubject, s.getPredicate(), s.getObject());
            }
        };
        return replace;
    }
}

