/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.FileManagerAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.util.IteratorCollection;
import com.hp.hpl.jena.util.LocationMapper;
import java.util.Iterator;
import java.util.List;

public class TestFileManagerAssembler
extends AssemblerTestBase {
    public TestFileManagerAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return FileManagerAssembler.class;
    }

    public void testFileModelAssemblerType() {
        this.testDemandsMinimalType(new FileManagerAssembler(), JA.FileManager);
    }

    public void testFileManagerVocabulary() {
        this.assertSubclassOf(JA.FileManager, JA.Object);
        this.assertDomain(JA.HasFileManager, JA.fileManager);
        this.assertDomain(JA.FileManager, JA.locationMapper);
        this.assertRange(JA.LocationMapper, JA.locationMapper);
    }

    public void testCreatesFileManager() {
        Resource root2 = this.resourceInModel("r rdf:type ja:FileManager");
        FileManagerAssembler a = new FileManagerAssembler();
        Object x = a.open(root2);
        TestFileManagerAssembler.assertInstanceOf(FileManager.class, x);
    }

    public void testCreatesFileManagerWithLocationMapper() {
        Resource root2 = this.resourceInModel("f rdf:type ja:FileManager; f ja:locationMapper r");
        LocationMapper mapper = new LocationMapper();
        AssemblerTestBase.NamedObjectAssembler mock = new AssemblerTestBase.NamedObjectAssembler(TestFileManagerAssembler.resource("r"), mapper);
        FileManagerAssembler a = new FileManagerAssembler();
        Object x = a.open(mock, root2);
        TestFileManagerAssembler.assertInstanceOf(FileManager.class, x);
        TestFileManagerAssembler.assertSame((Object)mapper, (Object)((FileManager)x).getLocationMapper());
    }

    public void testCreatesFileManagerWIthHandlers() {
        Resource root2 = this.resourceInModel("f rdf:type ja:FileManager");
        FileManagerAssembler a = new FileManagerAssembler();
        FileManager f = (FileManager)a.open(null, root2);
        List wanted = IteratorCollection.iteratorToList(this.standardLocators());
        List obtained = IteratorCollection.iteratorToList(f.locators());
        TestFileManagerAssembler.assertEquals((int)wanted.size(), (int)obtained.size());
        TestFileManagerAssembler.assertEquals((Object)wanted, (Object)obtained);
    }

    private Iterator standardLocators() {
        FileManager fm = new FileManager();
        FileManager.setStdLocators(fm);
        return fm.locators();
    }
}

