/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.Assembler;
import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.Mode;
import com.hp.hpl.jena.assembler.assemblers.AssemblerBase;
import com.hp.hpl.jena.assembler.assemblers.UnionModelAssembler;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.compose.MultiUnion;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.shared.AddDeniedException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TestUnionModelAssembler
extends AssemblerTestBase {
    public TestUnionModelAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return UnionModelAssembler.class;
    }

    public void testUnionModelAssemblerType() {
        this.testDemandsMinimalType(new UnionModelAssembler(), JA.UnionModel);
    }

    public void testUnionVocabulary() {
        this.assertSubclassOf(JA.UnionModel, JA.Model);
        this.assertDomain(JA.UnionModel, JA.subModel);
        this.assertRange(JA.Model, JA.subModel);
        this.assertDomain(JA.UnionModel, JA.rootModel);
        this.assertRange(JA.Model, JA.rootModel);
    }

    public void testCreatesMultiUnion() {
        Resource root2 = this.resourceInModel("x rdf:type ja:UnionModel");
        UnionModelAssembler a = new UnionModelAssembler();
        Model m = a.openModel(root2);
        TestUnionModelAssembler.assertInstanceOf(MultiUnion.class, m.getGraph());
        this.checkImmutable(m);
    }

    private void checkImmutable(Model m) {
        try {
            m.add(TestUnionModelAssembler.statement("S P O"));
            TestUnionModelAssembler.fail((String)"should be immutable");
        }
        catch (AddDeniedException e2) {
            TestUnionModelAssembler.pass();
        }
    }

    public void testCreatesUnionWithSubModels() {
        Resource root2 = this.resourceInModel("x rdf:type ja:UnionModel; x ja:subModel A; x ja:subModel B");
        UnionModelAssembler a = new UnionModelAssembler();
        Model modelA = this.model("");
        Model modelB = this.model("");
        HashSet<Graph> expected = new HashSet<Graph>();
        expected.add(modelA.getGraph());
        expected.add(modelB.getGraph());
        SmudgeAssembler mock = new SmudgeAssembler().add("A", modelA).add("B", modelB);
        Model m = (Model)a.open(mock, root2);
        TestUnionModelAssembler.assertInstanceOf(MultiUnion.class, m.getGraph());
        MultiUnion mu = (MultiUnion)m.getGraph();
        List L = mu.getSubGraphs();
        TestUnionModelAssembler.assertEquals(expected, new HashSet(L));
        this.checkImmutable(m);
    }

    public void testSubModelsCheckObject() {
        Resource root2 = this.resourceInModel("x rdf:type ja:UnionModel; x ja:subModel 'A'");
        UnionModelAssembler a = new UnionModelAssembler();
        try {
            a.open(root2);
            TestUnionModelAssembler.fail((String)"should trap unsuitable object");
        }
        catch (BadObjectException e2) {
            TestUnionModelAssembler.assertEquals((Object)TestUnionModelAssembler.resource("x"), (Object)e2.getRoot());
            TestUnionModelAssembler.assertEquals((Object)TestUnionModelAssembler.rdfNode(empty, "'A'"), (Object)e2.getObject());
        }
    }

    public void testCreatesUnionWithBaseModel() {
        Resource root2 = this.resourceInModel("x rdf:type ja:UnionModel; x ja:subModel A; x ja:rootModel B");
        UnionModelAssembler a = new UnionModelAssembler();
        Model modelA = this.model("");
        Model modelB = this.model("");
        HashSet<Graph> expected = new HashSet<Graph>();
        expected.add(modelA.getGraph());
        SmudgeAssembler mock = new SmudgeAssembler().add("A", modelA).add("B", modelB);
        Model m = (Model)a.open(mock, root2);
        TestUnionModelAssembler.assertInstanceOf(MultiUnion.class, m.getGraph());
        MultiUnion mu = (MultiUnion)m.getGraph();
        TestUnionModelAssembler.assertSame((Object)modelB.getGraph(), (Object)mu.getBaseGraph());
        TestUnionModelAssembler.assertEquals((Object)TestUnionModelAssembler.listOfOne(modelA.getGraph()), (Object)mu.getSubGraphs());
        m.add(TestUnionModelAssembler.statement("a P b"));
        TestUnionModelAssembler.assertIsoModels(this.model("a P b"), modelB);
    }

    static class SmudgeAssembler
    extends AssemblerBase {
        Map map = new HashMap();

        SmudgeAssembler() {
        }

        public SmudgeAssembler add(String name, Model m) {
            this.map.put(ModelTestBase.resource(name), m);
            return this;
        }

        public Model openModel(Resource root2, Mode mode) {
            return (Model)this.open(this, root2, mode);
        }

        public Object open(Assembler a, Resource root2, Mode irrelevant) {
            return (Model)this.map.get(root2);
        }
    }
}

