/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.db.test;

import com.hp.hpl.jena.db.IDBConnection;
import com.hp.hpl.jena.db.ModelRDB;
import com.hp.hpl.jena.db.test.TestConnection;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestReifierCompareToMem
extends TestCase {
    protected static Log logger = LogFactory.getLog(TestReifierCompareToMem.class);
    Model modelrdb = null;
    Model modelmem = null;
    IDBConnection conn = null;

    public TestReifierCompareToMem(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReifierCompareToMem.class);
    }

    protected void setUp() throws Exception {
        this.conn = TestConnection.makeAndCleanTestConnection();
        this.modelrdb = ModelRDB.createModel(this.conn);
        this.modelmem = ModelFactory.createDefaultModel();
    }

    protected void tearDown() throws Exception {
        this.modelrdb.close();
        this.modelrdb = null;
        this.conn.cleanDB();
        this.conn.close();
        this.conn = null;
    }

    private void addRemove(Statement stmt) {
        this.modelrdb.add(stmt);
        this.modelmem.add(stmt);
        this.compareModels();
        this.modelrdb.remove(stmt);
        this.modelmem.remove(stmt);
        this.compareModels();
    }

    private void compareModels() {
        Statement s;
        StmtIterator it = this.modelmem.listStatements();
        while (it.hasNext()) {
            s = (Statement)it.next();
            if (!this.modelrdb.contains(s)) {
                logger.error("Statment:" + s + " is in mem but not rdf");
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdb, "RDF");
            }
            TestReifierCompareToMem.assertTrue((boolean)this.modelrdb.contains(s));
        }
        it = this.modelrdb.listStatements();
        while (it.hasNext()) {
            s = (Statement)it.next();
            if (!this.modelmem.contains(s)) {
                logger.error("Statment:" + s + " is in rdf but not memory");
                this.logModel(this.modelmem, "Mem");
                this.logModel(this.modelrdb, "RDF");
            }
            TestReifierCompareToMem.assertTrue((boolean)this.modelmem.contains(s));
        }
        TestReifierCompareToMem.assertTrue((this.modelmem.size() == this.modelrdb.size() ? (byte)1 : 0) != 0);
    }

    private void logModel(Model m, String name) {
        logger.debug("Model");
        StmtIterator it = m.listStatements();
        while (it.hasNext()) {
            logger.debug(name + ": " + it.next());
        }
    }

    public void testAddPredicate() {
        Resource s = this.modelrdb.createResource("SSS");
        Resource o = this.modelrdb.createResource("OOO");
        Statement stmt = this.modelrdb.createStatement(s, RDF.object, o);
        this.modelrdb.add(stmt);
        this.modelmem.add(stmt);
        this.compareModels();
        this.modelrdb.remove(stmt);
        this.modelmem.remove(stmt);
        this.compareModels();
    }

    public void testAddRemoveFullReification() {
        Resource s = this.modelrdb.createResource("SSS");
        Resource p = this.modelrdb.createResource("PPP");
        Resource o = this.modelrdb.createResource("OOO");
        Statement stmtT = this.modelrdb.createStatement(s, RDF.type, RDF.Statement);
        Statement stmtS = this.modelrdb.createStatement(s, RDF.subject, s);
        Statement stmtP = this.modelrdb.createStatement(s, RDF.predicate, p);
        Statement stmtO = this.modelrdb.createStatement(s, RDF.object, o);
        this.modelrdb.add(stmtT);
        this.modelmem.add(stmtT);
        this.compareModels();
        this.modelrdb.add(stmtS);
        this.modelmem.add(stmtS);
        this.compareModels();
        this.modelrdb.add(stmtP);
        this.modelmem.add(stmtP);
        this.compareModels();
        this.modelrdb.add(stmtO);
        this.modelmem.add(stmtO);
        this.compareModels();
        this.modelrdb.remove(stmtO);
        this.modelmem.remove(stmtO);
        this.compareModels();
        this.modelrdb.remove(stmtP);
        this.modelmem.remove(stmtP);
        this.compareModels();
        this.modelrdb.remove(stmtS);
        this.modelmem.remove(stmtS);
        this.compareModels();
        this.modelrdb.remove(stmtT);
        this.modelmem.remove(stmtT);
        this.compareModels();
    }

    public void testAddRemoveLiteralObject() {
        Resource s = this.modelrdb.createResource("test#subject");
        Literal l = this.modelrdb.createLiteral("testLiteral");
        this.addRemove(this.modelrdb.createStatement(s, RDF.object, l));
    }

    public void testAddRemoveHugeLiteralObject() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelrdb.createResource("test#subject");
        Literal l = this.modelrdb.createLiteral(buffer.toString());
        this.addRemove(this.modelrdb.createStatement(s, RDF.object, l));
    }

    public void testAddRemoveDatatypeObject() {
        Resource s = this.modelrdb.createResource("test#subject");
        Literal l = this.modelrdb.createTypedLiteral("stringType");
        this.addRemove(this.modelrdb.createStatement(s, RDF.object, l));
    }

    public void testAddRemoveHugeDatatypeObject() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelrdb.createResource("test#subject");
        Literal l2 = this.modelrdb.createTypedLiteral(buffer.toString());
        this.addRemove(this.modelrdb.createStatement(s, RDF.object, l2));
    }

    public void testAddRemoveHugeLiteral2Object() {
        String base = "This is a huge string that repeats. \u00ce\u00b1\u00ce\u00b2\u00ce\u00b3\u00ce\u00b4\u00ce\u00b5 \u00ef\u00bf\u00bd \u00d7\u2018\u00d7\u2019\u00d7\u201c\u00d7\u201d \u00d8\u00a7\u00d8\u00a8\u00d8\u00a9\u00d8\u00aa\u00d8\u00ab";
        StringBuffer buffer = new StringBuffer(4096);
        while (buffer.length() < 4000) {
            buffer.append(base);
        }
        Resource s = this.modelmem.createResource("test#subject");
        Literal l2 = this.modelmem.createLiteral(buffer.toString());
        Literal l3 = this.modelmem.createLiteral(buffer.toString() + ".");
        Statement st1 = this.modelmem.createStatement(s, RDF.object, l2);
        Statement st2 = this.modelmem.createStatement(s, RDF.object, l3);
        this.modelrdb.add(st1);
        this.modelmem.add(st1);
        this.compareModels();
        this.modelrdb.add(st2);
        this.modelmem.add(st2);
        this.compareModels();
        this.modelrdb.remove(st2);
        this.modelmem.remove(st2);
        this.compareModels();
        this.modelrdb.remove(st1);
        this.modelmem.remove(st1);
    }
}

