/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.QueryNode;
import com.hp.hpl.jena.graph.query.QueryNodeFactory;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import com.hp.hpl.jena.graph.test.NodeCreateUtils;
import java.util.HashSet;
import junit.framework.TestSuite;

public class TestQueryNode
extends QueryTestBase {
    public static final QueryNodeFactory F = QueryNode.factory;

    public TestQueryNode(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestQueryNode.class);
    }

    public void testNoIndex() {
        TestQueryNode.assertTrue((boolean)true);
    }

    public void testFixed() {
        Node fixed = NodeCreateUtils.create("fixed");
        QueryNode.Fixed n = new QueryNode.Fixed(fixed);
        TestQueryNode.assertSame((Object)fixed, (Object)n.node);
        TestQueryNode.assertEquals((int)-1, (int)n.index);
        TestQueryNode.assertEquals((boolean)false, (boolean)n.mustMatch());
        TestQueryNode.assertSame((Object)fixed, (Object)((QueryNode)n).finder(null));
    }

    public void testBind() {
        int index = 7;
        Node bind = NodeCreateUtils.create("?bind");
        QueryNode.Bind n = new QueryNode.Bind(bind, 7);
        TestQueryNode.assertSame((Object)bind, (Object)n.node);
        TestQueryNode.assertEquals((int)7, (int)n.index);
        TestQueryNode.assertEquals((boolean)true, (boolean)((QueryNode)n).mustMatch());
        TestQueryNode.assertSame((Object)Node.ANY, (Object)n.finder(null));
    }

    public void testBound() {
        this.testBoundAt(0);
        this.testBoundAt(3);
        this.testBoundAt(7);
    }

    protected void testBoundAt(int index) {
        Node bound = NodeCreateUtils.create("?bound");
        QueryNode.Bound n = new QueryNode.Bound(bound, index);
        TestQueryNode.assertSame((Object)bound, (Object)n.node);
        TestQueryNode.assertEquals((int)index, (int)n.index);
        TestQueryNode.assertEquals((boolean)false, (boolean)n.mustMatch());
        Domain d = new Domain(index + 1);
        Node item = NodeCreateUtils.create("'anItem'");
        d.setElement(index, item);
        TestQueryNode.assertSame((Object)item, (Object)((QueryNode)n).finder(d));
    }

    public void testJustBound() {
        boolean index = true;
        Node just = NodeCreateUtils.create("?jBound");
        QueryNode.JustBound n = new QueryNode.JustBound(just, 1);
        TestQueryNode.assertSame((Object)just, (Object)n.node);
        TestQueryNode.assertEquals((int)1, (int)n.index);
        TestQueryNode.assertEquals((boolean)true, (boolean)((QueryNode)n).mustMatch());
        TestQueryNode.assertEquals((Object)Node.ANY, (Object)n.finder(null));
    }

    public void testAny() {
        QueryNode.Any n = new QueryNode.Any();
        TestQueryNode.assertSame((Object)Node.ANY, (Object)n.node);
        TestQueryNode.assertEquals((int)-1, (int)n.index);
        TestQueryNode.assertEquals((boolean)false, (boolean)n.mustMatch());
        TestQueryNode.assertSame((Object)Node.ANY, (Object)n.finder(null));
    }

    public void testClassifyFixed() {
        Node fixed = NodeCreateUtils.create("someURI");
        QueryNode n = QueryNode.classify(F, null, null, fixed);
        TestQueryNode.assertInstanceOf(QueryNode.Fixed.class, n);
        TestQueryNode.assertEquals((int)-1, (int)n.index);
        TestQueryNode.assertSame((Object)fixed, (Object)n.node);
    }

    public void testClassifyAny() {
        QueryNode n = QueryNode.classify(F, null, null, Node.ANY);
        TestQueryNode.assertInstanceOf(QueryNode.Any.class, n);
        TestQueryNode.assertEquals((int)-1, (int)n.index);
        TestQueryNode.assertSame((Object)Node.ANY, (Object)n.node);
    }

    public void testClassifyFirstBind() {
        Mapping m = new Mapping(new Node[0]);
        this.testClassifyBind(NodeCreateUtils.create("?bind"), m, 0);
    }

    public void testClassifySecondBind() {
        Mapping m = new Mapping(new Node[0]);
        m.newIndex(NodeCreateUtils.create("?other"));
        this.testClassifyBind(NodeCreateUtils.create("?bind"), m, 1);
    }

    protected void testClassifyBind(Node bind, Mapping m, int index) {
        QueryNode n = QueryNode.classify(F, m, new HashSet(), bind);
        TestQueryNode.assertInstanceOf(QueryNode.Bind.class, n);
        TestQueryNode.assertSame((Object)n.node, (Object)bind);
        TestQueryNode.assertEquals((int)index, (int)n.index);
    }

    public void testClassifyBound() {
        this.testClassifyBound(0);
        this.testClassifyBound(1);
        this.testClassifyBound(4);
        this.testClassifyBound(17);
    }

    protected void testClassifyBound(int index) {
        Node bound = NodeCreateUtils.create("?bound");
        Mapping m = this.getPreloadedMapping(index);
        m.newIndex(bound);
        QueryNode n = QueryNode.classify(F, m, new HashSet(), bound);
        TestQueryNode.assertInstanceOf(QueryNode.Bound.class, n);
        TestQueryNode.assertSame((Object)n.node, (Object)bound);
        TestQueryNode.assertEquals((int)index, (int)n.index);
    }

    public void testClassifyJustBound() {
        this.testClassifyJustBound(0);
        this.testClassifyJustBound(1);
        this.testClassifyJustBound(17);
        this.testClassifyJustBound(42);
    }

    protected void testClassifyJustBound(int index) {
        Node recent = NodeCreateUtils.create("?recent");
        Mapping m = this.getPreloadedMapping(index);
        m.newIndex(recent);
        HashSet<Node> withRecent = new HashSet<Node>();
        withRecent.add(recent);
        QueryNode n = QueryNode.classify(F, m, withRecent, recent);
        TestQueryNode.assertInstanceOf(QueryNode.JustBound.class, n);
        TestQueryNode.assertSame((Object)recent, (Object)n.node);
        TestQueryNode.assertEquals((int)index, (int)n.index);
    }

    public void testBindingSetsJustBound() {
        Node X = NodeCreateUtils.create("?X");
        Mapping m = this.getPreloadedMapping(0);
        HashSet s = new HashSet();
        QueryNode n = QueryNode.classify(F, m, s, X);
        TestQueryNode.assertTrue((boolean)s.contains(X));
    }

    public void testBindingSetsJustBoundTwice() {
        Node X = NodeCreateUtils.create("?X");
        Node Y = NodeCreateUtils.create("?Y");
        Mapping m = this.getPreloadedMapping(0);
        HashSet s = new HashSet();
        QueryNode.classify(F, m, s, X);
        QueryNode.classify(F, m, s, Y);
        TestQueryNode.assertTrue((boolean)s.contains(X));
        TestQueryNode.assertTrue((boolean)s.contains(Y));
    }

    protected Mapping getPreloadedMapping(int count) {
        Mapping m = new Mapping(new Node[0]);
        for (int i = 0; i < count; ++i) {
            m.newIndex(NodeCreateUtils.create("?bound-" + i));
        }
        return m;
    }

    public void testMatchFixed() {
        Node fixed = NodeCreateUtils.create("_anon");
        QueryNode.Fixed n = new QueryNode.Fixed(fixed);
        try {
            n.match(null, NodeCreateUtils.create("named"));
            TestQueryNode.fail((String)"Fixed should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchBound() {
        Node bound = NodeCreateUtils.create("?xx");
        QueryNode.Bound n = new QueryNode.Bound(bound, 1);
        try {
            n.match(null, NodeCreateUtils.create("_anon"));
            TestQueryNode.fail((String)"Bound should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchAny() {
        QueryNode.Any n = new QueryNode.Any();
        try {
            n.match(null, NodeCreateUtils.create("17"));
            TestQueryNode.fail((String)"Any should not be matching");
        }
        catch (QueryNode.MustNotMatchException e2) {
            TestQueryNode.pass();
        }
    }

    public void testMatchBind() {
        Node v = NodeCreateUtils.create("?v");
        Node x = NodeCreateUtils.create("elephant");
        Node y = NodeCreateUtils.create("hedgehog");
        QueryNode.Bind n = new QueryNode.Bind(v, 1);
        Domain d = new Domain(3);
        TestQueryNode.assertTrue((boolean)((QueryNode)n).match(d, x));
        TestQueryNode.assertSame((Object)x, (Object)d.getElement(n.index));
        TestQueryNode.assertTrue((boolean)((QueryNode)n).match(d, y));
        TestQueryNode.assertSame((Object)y, (Object)d.getElement(n.index));
    }

    public void testMatchJustBound() {
        Node v = NodeCreateUtils.create("?who");
        Node A = NodeCreateUtils.create("A");
        Node B = NodeCreateUtils.create("B");
        QueryNode.JustBound n = new QueryNode.JustBound(v, 1);
        Domain d = new Domain(3);
        d.setElement(n.index, A);
        TestQueryNode.assertTrue((boolean)((QueryNode)n).match(d, A));
        TestQueryNode.assertFalse((boolean)((QueryNode)n).match(d, B));
        d.setElement(n.index, B);
        TestQueryNode.assertFalse((boolean)((QueryNode)n).match(d, A));
        TestQueryNode.assertTrue((boolean)((QueryNode)n).match(d, B));
    }
}

