/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import junit.framework.TestSuite;

public class TestReificationPredicates
extends GraphTestBase {
    public TestReificationPredicates(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestReificationPredicates.class);
    }

    public void testSubject() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.subject));
    }

    public void testPredicate() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.predicate));
    }

    public void testObject() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.object));
    }

    public void testRest() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.rest));
    }

    public void testFirst() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.first));
    }

    public void testType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.type));
    }

    public void testValue() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate(RDF.Nodes.value));
    }

    public void testSubjectInOtherNamespace() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationPredicate(TestReificationPredicates.node("subject")));
    }

    public void testStatementCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement(RDF.Nodes.Statement));
    }

    public void testVariableCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement(TestReificationPredicates.node("?x")));
    }

    public void testANYCouldBeStatement() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.couldBeStatement(Node.ANY));
    }

    public void testPropertyCouldNotBeStatement() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.couldBeStatement(RDF.Nodes.Property));
    }

    public void testOtherStatementCouldBeStatement() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.couldBeStatement(TestReificationPredicates.node("Statement")));
    }

    public void testAltIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Alt));
    }

    public void testBagIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Bag));
    }

    public void testOtherStatementIsntIsReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, TestReificationPredicates.node("Statement")));
    }

    public void testValueIsNtReificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType(RDF.Nodes.value, RDF.Nodes.Statement));
    }

    public void testValuePropertyIsntreificationType() {
        TestReificationPredicates.assertFalse((boolean)Reifier.Util.isReificationType(RDF.Nodes.value, RDF.Nodes.Property));
    }

    public void testStatementIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, RDF.Nodes.Statement));
    }

    public void testVariableIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, TestReificationPredicates.node("?x")));
    }

    public void testANYIsReificationType() {
        TestReificationPredicates.assertTrue((boolean)Reifier.Util.isReificationType(RDF.Nodes.type, Node.ANY));
    }
}

