/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.iri.impl;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIComponents;
import com.hp.hpl.jena.iri.Violation;
import com.hp.hpl.jena.iri.impl.AbsIRIImpl;
import com.hp.hpl.jena.iri.impl.PatternCompiler;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo;

public class ViolationImpl
extends Violation {
    static String[] componentNames;
    private final int code;
    private final int slot;
    private final AbsIRIImpl iri;

    static String componentName(int j) {
        if (componentNames == null) {
            componentNames = PatternCompiler.constantsFromClass(IRIComponents.class, 40);
        }
        return componentNames[j];
    }

    public ViolationImpl(IRI iri, int slot, int code) {
        this.iri = (AbsIRIImpl)iri;
        this.code = code;
        this.slot = slot;
    }

    public int getViolationCode() {
        return this.code;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public int getComponent() {
        return this.slot;
    }

    public String component() {
        return ViolationImpl.componentName(this.slot);
    }

    public String codeName() {
        return PatternCompiler.errorCodeName(this.code);
    }

    public boolean isError() {
        return (this.iri.getSchemeSpec().getMask(false) & 1L << this.code) != 0L;
    }

    public String getShortMessage() {
        return "<" + this.getIRI() + "> Code: " + this.code + "/" + this.codeName() + " in " + this.component() + ": " + this.description();
    }

    private String description() {
        ViolationCodeInfo info = ViolationCodeInfo.all[this.code];
        if (info == null) {
            return "internal error: description of error not found";
        }
        return info.description(this.slot, this.iri.getFactory());
    }

    public String getLongMessage() {
        return "<" + this.getIRI() + "> Code: " + this.code + "/" + this.codeName() + " in " + this.component() + ": " + this.description() + " see: " + this.specs();
    }

    private String specs() {
        ViolationCodeInfo info = ViolationCodeInfo.all[this.code];
        if (info == null) {
            return "(null)";
        }
        return info.specs(this.slot, this.iri.getFactory(), this.iri.getScheme());
    }

    public String getSpecificationURL() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

