/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem.faster.test;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.StageElement;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.HashedTripleBunch;
import com.hp.hpl.jena.mem.MatchOrBind;
import com.hp.hpl.jena.mem.SetBunch;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.ConcurrentModificationException;
import junit.framework.TestSuite;

public abstract class TestConcurrentModificationException
extends ModelTestBase {
    private static final MatchOrBind mob = new MatchOrBind(){

        public boolean matches(Triple t) {
            return true;
        }

        public MatchOrBind reset(Domain d) {
            return null;
        }
    };

    public TestConcurrentModificationException(String name) {
        super(name);
    }

    public abstract TripleBunch getBunch();

    public static TestSuite suite() {
        TestSuite result = new TestSuite();
        result.addTestSuite(TestArrayBunchCME.class);
        result.addTestSuite(TestSetBunchCME.class);
        result.addTestSuite(TestHashedBunchCME.class);
        return result;
    }

    public void testAddThenNextThrowsCME() {
        TripleBunch b = this.getBunch();
        b.add(Triple.create("a P b"));
        b.add(Triple.create("c Q d"));
        ExtendedIterator it = b.iterator();
        it.next();
        b.add(Triple.create("change its state"));
        try {
            it.next();
            TestConcurrentModificationException.fail((String)"should have thrown ConcurrentModificationException");
        }
        catch (ConcurrentModificationException e2) {
            TestConcurrentModificationException.pass();
        }
    }

    public void testDeleteThenNextThrowsCME() {
        TripleBunch b = this.getBunch();
        b.add(Triple.create("a P b"));
        b.add(Triple.create("c Q d"));
        ExtendedIterator it = b.iterator();
        it.next();
        b.remove(Triple.create("a P b"));
        try {
            it.next();
            TestConcurrentModificationException.fail((String)"should have thrown ConcurrentModificationException");
        }
        catch (ConcurrentModificationException e2) {
            TestConcurrentModificationException.pass();
        }
    }

    public void testAddDuringAppThrowsCME() {
        final TripleBunch b = this.getBunch();
        b.add(Triple.create("a P b"));
        b.add(Triple.create("c Q d"));
        StageElement se = new StageElement(){

            public void run(Domain current) {
                b.add(Triple.create("S P O"));
            }
        };
        try {
            b.app(new Domain(0), se, mob);
            TestConcurrentModificationException.fail((String)" should throw CME");
        }
        catch (ConcurrentModificationException e2) {
            TestConcurrentModificationException.pass();
        }
    }

    public static class TestHashedBunchCME
    extends TestConcurrentModificationException {
        public TestHashedBunchCME(String name) {
            super(name);
        }

        public TripleBunch getBunch() {
            return new HashedTripleBunch(new ArrayBunch());
        }
    }

    public static class TestSetBunchCME
    extends TestConcurrentModificationException {
        public TestSetBunchCME(String name) {
            super(name);
        }

        public TripleBunch getBunch() {
            return new SetBunch(new ArrayBunch());
        }
    }

    public static class TestArrayBunchCME
    extends TestConcurrentModificationException {
        public TestArrayBunchCME(String name) {
            super(name);
        }

        public TripleBunch getBunch() {
            return new ArrayBunch();
        }
    }
}

