/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.rdf.model.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import junit.framework.TestSuite;

public class TestContains
extends ModelTestBase {
    public TestContains(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestContains.class);
    }

    public void testContains(boolean yes, String facts, String resource) {
        Model m = TestContains.modelWithStatements(facts);
        RDFNode r = TestContains.rdfNode(m, resource);
        if (TestContains.modelWithStatements(facts).containsResource(r) != yes) {
            TestContains.fail((String)("[" + facts + "] should" + (yes ? "" : " not") + " contain " + resource));
        }
    }

    public void testContains() {
        this.testContains(false, "", "x");
        this.testContains(false, "a R b", "x");
        this.testContains(false, "a R b; c P d", "x");
        this.testContains(false, "a R b", "z");
        this.testContains(true, "x R y", "x");
        this.testContains(true, "a P b", "P");
        this.testContains(true, "i  Q  j", "j");
        this.testContains(true, "x R y; a P b; i Q j", "y");
        this.testContains(true, "x R y; a P b; i Q j", "y");
        this.testContains(true, "x R y; a P b; i Q j", "R");
        this.testContains(true, "x R y; a P b; i Q j", "a");
    }

    private Resource res(String uri) {
        return ResourceFactory.createResource("eh:/" + uri);
    }

    private Property prop(String uri) {
        return ResourceFactory.createProperty("eh:/" + uri);
    }

    public void testContainsWithNull() {
        this.testCWN(false, "", null, null, null);
        this.testCWN(true, "x R y", null, null, null);
        this.testCWN(false, "x R y", null, null, this.res("z"));
        this.testCWN(true, "x RR y", this.res("x"), this.prop("RR"), null);
        this.testCWN(true, "a BB c", null, this.prop("BB"), this.res("c"));
        this.testCWN(false, "a BB c", null, this.prop("ZZ"), this.res("c"));
    }

    public void testCWN(boolean yes, String facts, Resource S, Property P, RDFNode O) {
        TestContains.assertEquals((boolean)yes, (boolean)TestContains.modelWithStatements(facts).contains(S, P, O));
    }

    public void testModelComContainsSPcallsContainsSPO() {
        Graph g = Factory.createDefaultGraph();
        final boolean[] wasCalled = new boolean[]{false};
        ModelCom m = new ModelCom(g){

            public boolean contains(Resource s, Property p, RDFNode o) {
                wasCalled[0] = true;
                return super.contains(s, p, o);
            }
        };
        TestContains.assertFalse((boolean)m.contains(TestContains.resource("r"), TestContains.property("p")));
        TestContains.assertTrue((String)"contains(S,P) should call contains(S,P,O)", (boolean)wasCalled[0]);
    }
}

