/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.dig.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.dig.DIGErrorResponseException;
import com.hp.hpl.jena.reasoner.dig.DIGReasoner;
import com.hp.hpl.jena.reasoner.dig.DIGReasonerFactory;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWLResults;
import com.hp.hpl.jena.vocabulary.OWLTest;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.LogFactory;

public class WebOntTests {
    public static final String BASE_TESTDIR = "testing/wg/";
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static final String OTEST_NS = BASE_URI + "testOntology#";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/owl-results.rdf";
    public static final String[] TEST_DIRS = new String[]{"AllDifferent", "AnnotationProperty", "DatatypeProperty", "FunctionalProperty", "I3.2", "I3.4", "I4.1", "I4.5", "I4.6", "I5.1", "I5.2", "I5.21", "I5.24", "I5.26", "I5.3", "I5.5", "I5.8", "InverseFunctionalProperty", "Nothing", "Restriction", "SymmetricProperty", "Thing", "TransitiveProperty", "Class", "allValuesFrom", "amp-in-url", "cardinality", "complementOf", "datatypes", "differentFrom", "disjointWith", "distinctMembers", "equivalentClass", "equivalentProperty", "imports", "intersectionOf", "inverseOf", "localtests", "maxCardinality", "miscellaneous", "oneOf", "sameAs", "someValuesFrom", "statement-entailment", "unionOf", "xmlbase", "description-logic", "extra-credit"};
    public static final String[] BLOCKED_TESTS = new String[0];
    public static final String[] STATUS_FLAGS = new String[]{"APPROVED", "PROPOSED"};
    public static final List ACCEPTABLE_TEST_LEVELS = Arrays.asList(OWLTest.Lite, OWLTest.DL);
    protected static List UNSAFE_PREMISE_PREDICATES = new ArrayList();
    protected static boolean s_includeModified;
    protected static boolean s_approvedOnly;
    private DIGReasoner m_reasoner;
    private Model m_testDefinitions = this.loadAllTestDefinitions();
    private int m_testCount = 0;
    private long m_lastTestDuration = 0L;
    private int m_passCount = 0;
    private Model m_testResults;
    private Resource m_jena2;

    public WebOntTests() {
        DIGReasonerFactory drf = (DIGReasonerFactory)ReasonerRegistry.theRegistry().getFactory("http://jena.hpl.hp.com/2003/DIGReasoner");
        this.m_reasoner = (DIGReasoner)drf.createWithOWLAxioms(null);
        this.initResults();
    }

    public static void main(String[] args) throws IOException {
        String resultFile = "owl-results.rdf";
        String testName = null;
        if (args.length >= 1) {
            testName = args[0];
        }
        WebOntTests harness = new WebOntTests();
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/2002/03owlt/miscellaneous/consistent002", "file:testing/wg/miscellaneous/consistent002.rdf");
        OntDocumentManager.getInstance().addAltEntry("http://www.w3.org/2002/03owlt/miscellaneous/consistent001", "file:testing/wg/miscellaneous/consistent001.rdf");
        if (testName == null) {
            harness.runTests();
        } else {
            harness.runTest(testName);
        }
        RDFWriter writer = harness.m_testResults.getWriter("RDF/XML-ABBREV");
        FileOutputStream stream = new FileOutputStream(resultFile);
        writer.setProperty("showXmlDeclaration", "true");
        harness.m_testResults.setNsPrefix("", "http://www.w3.org/1999/xhtml");
        writer.write(harness.m_testResults, stream, BASE_RESULTS_URI);
    }

    public void runTests() {
        System.out.println("Testing " + (s_approvedOnly ? "only APPROVED" : "APPROVED and PROPOSED"));
        System.out.println("Positive entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.PositiveEntailmentTest));
        System.out.println("\nNegative entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.NegativeEntailmentTest));
        System.out.println("\nTrue tests: ");
        this.runTests(this.findTestsOfType(OWLTest.TrueTest));
        System.out.println("\nOWL for OWL tests: ");
        this.runTests(this.findTestsOfType(OWLTest.OWLforOWLTest));
        System.out.println("\nImport entailment tests: ");
        this.runTests(this.findTestsOfType(OWLTest.ImportEntailmentTest));
        System.out.println("\nInconsistency tests: ");
        this.runTests(this.findTestsOfType(OWLTest.InconsistencyTest));
        System.out.println("\nPassed " + this.m_passCount + " out of " + this.m_testCount);
    }

    public void runTests(List tests) {
        Iterator i = tests.iterator();
        while (i.hasNext()) {
            this.runTest((Resource)i.next());
        }
    }

    public void runTest(String test) {
        this.runTest(this.m_testDefinitions.getResource(test));
    }

    public void runTest(Resource test) {
        System.out.println("Running " + test);
        boolean success = false;
        boolean fail = false;
        try {
            success = this.doRunTest(test);
        }
        catch (Exception e2) {
            fail = true;
            System.err.print("\nException: " + e2);
            e2.printStackTrace();
        }
        ++this.m_testCount;
        if (success) {
            System.out.print(this.m_testCount % 40 == 0 ? ".\n" : ".");
            System.out.flush();
            ++this.m_passCount;
        } else {
            System.out.println("\nFAIL: " + test);
        }
        Resource resultType = null;
        resultType = fail ? OWLResults.FailingRun : (test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || test.hasProperty(RDF.type, OWLTest.ConsistencyTest) ? (success ? OWLResults.PassingRun : OWLResults.FailingRun) : (success ? OWLResults.PassingRun : OWLResults.IncompleteRun));
        this.m_testResults.createResource().addProperty(RDF.type, OWLResults.TestRun).addProperty(RDF.type, resultType).addProperty(OWLResults.test, test).addProperty(OWLResults.system, this.m_jena2);
    }

    public boolean doRunTest(Resource test) throws IOException {
        if (test.hasProperty(RDF.type, OWLTest.PositiveEntailmentTest) || test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || test.hasProperty(RDF.type, OWLTest.OWLforOWLTest) || test.hasProperty(RDF.type, OWLTest.ImportEntailmentTest) || test.hasProperty(RDF.type, OWLTest.TrueTest)) {
            System.out.println("Starting: " + test);
            boolean processImports = test.hasProperty(RDF.type, OWLTest.ImportEntailmentTest);
            Model premises = this.getDoc(test, RDFTest.premiseDocument, processImports);
            Model conclusions = this.getDoc(test, RDFTest.conclusionDocument);
            long t1 = System.currentTimeMillis();
            boolean correct = this.testEntailment(conclusions, this.m_reasoner.bind(premises.getGraph()));
            this.m_lastTestDuration = System.currentTimeMillis() - t1;
            if (test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest)) {
                correct = !correct;
            }
            return correct;
        }
        if (test.hasProperty(RDF.type, OWLTest.InconsistencyTest)) {
            System.out.println("Starting: " + test);
            Model input = this.getDoc(test, RDFTest.inputDocument);
            long t1 = System.currentTimeMillis();
            InfGraph graph = this.m_reasoner.bind(input.getGraph());
            boolean correct = !graph.validate().isValid();
            this.m_lastTestDuration = System.currentTimeMillis() - t1;
            return correct;
        }
        if (test.hasProperty(RDF.type, OWLTest.ConsistencyTest)) {
            System.out.println("Starting: " + test);
            Model input = this.getDoc(test, RDFTest.inputDocument);
            long t1 = System.currentTimeMillis();
            InfGraph graph = this.m_reasoner.bind(input.getGraph());
            boolean correct = graph.validate().isValid();
            long t2 = System.currentTimeMillis();
            this.m_lastTestDuration = t2 - t1;
            return correct;
        }
        StmtIterator i = test.listProperties(RDF.type);
        while (i.hasNext()) {
            System.out.println("Test type = " + i.nextStatement().getObject());
        }
        throw new ReasonerException("Unknown test type");
    }

    public Model getDoc(Resource test, Property docType, boolean processImports) throws IOException {
        if (processImports) {
            OntModel result = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
            StmtIterator si = test.listProperties(docType);
            while (si.hasNext()) {
                String fname = ((Object)si.nextStatement().getObject()).toString() + ".rdf";
                WebOntTests.loadFile(fname, result);
            }
            return result;
        }
        return this.getDoc(test, docType);
    }

    public Model getDoc(Resource test, Property docType) throws IOException {
        Model result = ModelFactory.createDefaultModel();
        StmtIterator si = test.listProperties(docType);
        while (si.hasNext()) {
            String fname = ((Object)si.nextStatement().getObject()).toString() + ".rdf";
            WebOntTests.loadFile(fname, result);
        }
        return result;
    }

    public static Model loadFile(String file, Model model) throws IOException {
        String langType = "RDF/XML";
        if (file.endsWith(".nt")) {
            langType = "N-TRIPLE";
        } else if (file.endsWith("n3")) {
            langType = "N3";
        }
        String fname = file;
        if (fname.startsWith(BASE_URI)) {
            fname = fname.substring(BASE_URI.length());
        }
        BufferedReader reader = new BufferedReader(new FileReader(BASE_TESTDIR + fname));
        model.read(reader, BASE_URI + fname, langType);
        return model;
    }

    public boolean testEntailment(Model conclusions, InfGraph inf) {
        List queryRoots = this.listQueryRoots(conclusions);
        Model result = ModelFactory.createDefaultModel();
        Iterator i = queryRoots.iterator();
        while (i.hasNext()) {
            Resource root2 = (Resource)i.next();
            StmtIterator j = root2.listProperties();
            while (j.hasNext()) {
                Statement rootQuery = j.nextStatement();
                Resource subject = rootQuery.getSubject();
                RDFNode object = rootQuery.getObject();
                OntModel premises = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
                premises.setStrictMode(false);
                if (subject.isAnon()) {
                    this.addSubGraph(subject, premises);
                }
                if (object instanceof Resource && ((Resource)object).isAnon()) {
                    this.addSubGraph((Resource)object, premises);
                }
                try {
                    ExtendedIterator k = inf.find(rootQuery.getSubject().asNode(), rootQuery.getPredicate().asNode(), rootQuery.getObject().asNode(), premises.getGraph());
                    while (k.hasNext()) {
                        Object x = k.next();
                        Triple t = (Triple)x;
                        LogFactory.getLog(this.getClass()).debug("testEntailment got triple " + t);
                        result.getGraph().add(t);
                    }
                    result.add(premises);
                }
                catch (DIGErrorResponseException e2) {
                    LogFactory.getLog(this.getClass()).error("DIG reasoner returned error: " + e2.getMessage());
                    return false;
                }
            }
        }
        result.write(System.out, "RDF/XML-ABBREV");
        QueryHandler qh = result.queryHandler();
        Query query2 = WGReasonerTester.graphToQuery(conclusions.getGraph());
        ExtendedIterator i2 = qh.prepareBindings(query2, new Node[0]).executeBindings();
        return i2.hasNext();
    }

    protected Model loadAllTestDefinitions() {
        System.out.print("Loading manifests ");
        System.out.flush();
        Model testDefs = ModelFactory.createDefaultModel();
        int count = 0;
        for (int idir = 0; idir < TEST_DIRS.length; ++idir) {
            File dir = new File(BASE_TESTDIR + TEST_DIRS[idir]);
            String[] manifests = dir.list(new FilenameFilter(){

                public boolean accept(File df, String name) {
                    return name.startsWith("Manifest") && name.endsWith(".rdf") && (s_includeModified || !name.endsWith("-mod.rdf"));
                }
            });
            if (manifests == null) {
                System.err.println("No manifests for testing/wg/" + TEST_DIRS[idir]);
                continue;
            }
            for (int im = 0; im < manifests.length; ++im) {
                String manifest = manifests[im];
                File mf = new File(dir, manifest);
                try {
                    testDefs.read(new FileInputStream(mf), "file:" + mf);
                    if (++count % 8 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    System.out.println("File not readable - " + e2);
                }
            }
        }
        System.out.println("loaded");
        return testDefs;
    }

    protected void initResults() {
        this.m_testResults = ModelFactory.createDefaultModel();
        this.m_jena2 = this.m_testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.m_jena2.addProperty(RDFS.comment, this.m_testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.m_jena2.addProperty(RDFS.label, "Jena2");
        this.m_testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public List findTestsOfType(Resource testType) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        StmtIterator si = this.m_testDefinitions.listStatements(null, RDF.type, testType);
        while (si.hasNext()) {
            int i;
            Resource test = si.nextStatement().getSubject();
            boolean accept = true;
            Literal status = (Literal)test.getProperty(RDFTest.status).getObject();
            if (s_approvedOnly) {
                accept = status.getString().equals(STATUS_FLAGS[0]);
            } else {
                accept = false;
                for (i = 0; i < STATUS_FLAGS.length; ++i) {
                    if (!status.getString().equals(STATUS_FLAGS[i])) continue;
                    accept = true;
                    break;
                }
            }
            for (i = 0; i < BLOCKED_TESTS.length; ++i) {
                if (!BLOCKED_TESTS[i].equals(((Object)test).toString())) continue;
                accept = false;
            }
            if (accept) {
                boolean reject = true;
                StmtIterator i2 = test.listProperties(OWLTest.level);
                while (i2.hasNext()) {
                    if (!ACCEPTABLE_TEST_LEVELS.contains(i2.nextStatement().getResource())) continue;
                    reject = false;
                }
                if (reject) {
                    LogFactory.getLog(this.getClass()).debug("Ignoring test " + test + " because it either has no test level defined, or an unacceptable test level");
                    accept = false;
                }
            }
            if (!accept) continue;
            result.add(test);
        }
        return result;
    }

    protected List listQueryRoots(Model m) {
        ArrayList<Resource> roots = new ArrayList<Resource>();
        Iterator i = m.listSubjects();
        while (i.hasNext()) {
            Resource subj = i.nextResource();
            if (subj.isAnon()) continue;
            roots.add(subj);
        }
        i = roots.iterator();
        while (i.hasNext()) {
            LogFactory.getLog(this.getClass()).debug("Found query root: " + i.next());
        }
        return roots;
    }

    protected void addSubGraph(Resource root2, Model premises) {
        ArrayList<RDFNode> q = new ArrayList<RDFNode>();
        HashSet<Resource> seen = new HashSet<Resource>();
        q.add(root2);
        while (!q.isEmpty()) {
            Resource r = (Resource)q.remove(0);
            if (seen.contains(r)) continue;
            StmtIterator i = r.listProperties();
            while (i.hasNext()) {
                Statement s = i.nextStatement();
                if (!this.safePremise(s.getPredicate())) continue;
                premises.add(s);
                if (!(s.getObject() instanceof Resource)) continue;
                q.add(s.getObject());
            }
            seen.add(r);
        }
    }

    protected boolean safePremise(Property p) {
        return !UNSAFE_PREMISE_PREDICATES.contains(p);
    }

    static {
        UNSAFE_PREMISE_PREDICATES.add(OWL.equivalentClass);
        UNSAFE_PREMISE_PREDICATES.add(OWL.equivalentProperty);
        UNSAFE_PREMISE_PREDICATES.add(OWL.sameAs);
        UNSAFE_PREMISE_PREDICATES.add(RDFS.subClassOf);
        UNSAFE_PREMISE_PREDICATES.add(RDFS.subPropertyOf);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.sameClassAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.sameIndividualAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.samePropertyAs);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.subClassOf);
        UNSAFE_PREMISE_PREDICATES.add(DAML_OIL.subPropertyOf);
        s_includeModified = false;
        s_approvedOnly = true;
    }
}

