/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Query;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerException;
import com.hp.hpl.jena.reasoner.ReasonerRegistry;
import com.hp.hpl.jena.reasoner.rulesys.FBRuleInfGraph;
import com.hp.hpl.jena.reasoner.test.WGReasonerTester;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.OWLResults;
import com.hp.hpl.jena.vocabulary.OWLTest;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RDFTest;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WebOntTestHarness {
    public static boolean includeModified = false;
    public static boolean approvedOnly = true;
    public static boolean printProfile = false;
    Reasoner reasoner;
    Model testDefinitions = WebOntTestHarness.loadAllTestDefinitions();
    int testCount = 0;
    long lastTestDuration = 0L;
    int passCount = 0;
    Model testResults;
    Resource jena2;
    public static final String BASE_TESTDIR = "testing/wg/";
    public static String BASE_URI = "http://www.w3.org/2002/03owlt/";
    public static String BASE_RESULTS_URI = "http://jena.sourceforge.net/data/owl-results.rdf";
    public static final String[] TEST_DIRS = new String[]{"AllDifferent", "AllDistinct", "AnnotationProperty", "DatatypeProperty", "FunctionalProperty", "I3.2", "I3.4", "I4.1", "I4.5", "I4.6", "I5.1", "I5.2", "I5.21", "I5.24", "I5.26", "I5.3", "I5.5", "I5.8", "InverseFunctionalProperty", "Nothing", "Restriction", "SymmetricProperty", "Thing", "TransitiveProperty", "allValuesFrom", "amp-in-url", "cardinality", "complementOf", "datatypes", "differentFrom", "disjointWith", "distinctMembers", "equivalentClass", "equivalentProperty", "imports", "intersectionOf", "inverseOf", "localtests", "maxCardinality", "miscellaneous", "oneOf", "oneOfDistinct", "sameAs", "sameClassAs", "sameIndividualAs", "samePropertyAs", "someValuesFrom", "statement-entailment", "unionOf", "xmlbase", "description-logic"};
    public static final String[] BLOCKED_TESTS = new String[]{"http://www.w3.org/2002/03owlt/complementOf/Manifest001#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest901#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest903#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest902#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest904#test", "http://www.w3.org/2002/03owlt/oneOf/Manifest004#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest001#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest002#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest003#test", "http://www.w3.org/2002/03owlt/unionOf/Manifest004#test", "http://www.w3.org/2002/03owlt/equivalentClass/Manifest006#test", "http://www.w3.org/2002/03owlt/equivalentClass/Manifest007#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest201#test", "http://www.w3.org/2002/03owlt/I5.8/Manifest004#test", "http://www.w3.org/2002/03owlt/I5.2/Manifest004#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest008#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest011#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest015#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest019#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest023#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest026#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest027#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest029#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest030#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest032#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest033#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest035#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest101#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest102#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest103#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest104#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest105#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest106#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest107#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest108#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest109#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest110#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest111#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest502#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest504#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest202#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest203#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest204#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest205#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest206#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest207#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest208#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest209#test", "http://www.w3.org/2002/03owlt/miscellaneous/Manifest010#test", "http://www.w3.org/2002/03owlt/miscellaneous/Manifest011#test", "http://www.w3.org/2002/03owlt/SymmetricProperty/Manifest002#test", "http://www.w3.org/2002/03owlt/Thing/Manifest005#test", "http://www.w3.org/2002/03owlt/TransitiveProperty/Manifest002#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest661#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest662#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest663#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest608#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest611#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest615#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest623#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest626#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest627#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest630#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest668#test", "http://www.w3.org/2002/03owlt/description-logic/Manifest668#test"};
    public static final String[] STATUS_FLAGS = new String[]{"APPROVED", "PROPOSED"};

    public WebOntTestHarness() {
        this.reasoner = ReasonerRegistry.getOWLReasoner();
        this.initResults();
    }

    public static Model loadAllTestDefinitions() {
        System.out.print("Loading manifests ");
        System.out.flush();
        Model testDefs = ModelFactory.createDefaultModel();
        int count = 0;
        for (int idir = 0; idir < TEST_DIRS.length; ++idir) {
            File dir = new File(BASE_TESTDIR + TEST_DIRS[idir]);
            String[] manifests = dir.list(new FilenameFilter(){

                public boolean accept(File df, String name) {
                    if (name.startsWith("Manifest") && name.endsWith(".rdf")) {
                        return includeModified || !name.endsWith("-mod.rdf");
                    }
                    return false;
                }
            });
            for (int im = 0; im < manifests.length; ++im) {
                String manifest = manifests[im];
                File mf = new File(dir, manifest);
                try {
                    testDefs.read(new FileInputStream(mf), "file:" + mf);
                    if (++count % 8 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                    continue;
                }
                catch (FileNotFoundException e2) {
                    System.out.println("File not readable - " + e2);
                }
            }
        }
        System.out.println("loaded");
        return testDefs;
    }

    public void initResults() {
        this.testResults = ModelFactory.createDefaultModel();
        this.jena2 = this.testResults.createResource(BASE_RESULTS_URI + "#jena2");
        this.jena2.addProperty(RDFS.comment, this.testResults.createLiteral("<a xmlns=\"http://www.w3.org/1999/xhtml\" href=\"http://jena.sourceforce.net/\">Jena2</a> includes a rule-based inference engine for RDF processing, supporting both forward and backward chaining rules. Its OWL rule set is designed to provide sound but not complete instance resasoning for that fragment of OWL/Full limited to the OWL/lite vocabulary. Inparticular it does not support unionOf/complementOf.", true));
        this.jena2.addProperty(RDFS.label, "Jena2");
        this.testResults.setNsPrefix("results", "http://www.w3.org/2002/03owlt/resultsOntology#");
    }

    public static void main(String[] args) throws IOException {
        String resultFile = "owl-results.rdf";
        if (args.length >= 1) {
            resultFile = args[0];
        }
        WebOntTestHarness harness = new WebOntTestHarness();
        harness.runTests();
        RDFWriter writer = harness.testResults.getWriter("RDF/XML-ABBREV");
        FileOutputStream stream = new FileOutputStream(resultFile);
        writer.setProperty("showXmlDeclaration", "true");
        harness.testResults.setNsPrefix("", "http://www.w3.org/1999/xhtml");
        writer.write(harness.testResults, stream, BASE_RESULTS_URI);
    }

    public void runTests() {
        System.out.println("Testing " + (approvedOnly ? "only APPROVED" : "APPROVED and PROPOSED"));
        System.out.println("Positive entailment: ");
        this.runTests(this.findTestsOfType(OWLTest.PositiveEntailmentTest));
        System.out.println("\nTrue tests: ");
        this.runTests(this.findTestsOfType(OWLTest.TrueTest));
        System.out.println("\nOWL for OWL tests: ");
        this.runTests(this.findTestsOfType(OWLTest.OWLforOWLTest));
        System.out.println("\nImport entailment tests: ");
        this.runTests(this.findTestsOfType(OWLTest.ImportEntailmentTest));
        System.out.println("\nInconsistency tests: ");
        this.runTests(this.findTestsOfType(OWLTest.InconsistencyTest));
        System.out.println("\nPassed " + this.passCount + " out of " + this.testCount);
    }

    public void runTests(List tests) {
        Iterator i = tests.iterator();
        while (i.hasNext()) {
            this.runTest((Resource)i.next());
        }
    }

    public void runTest(String test) {
        this.runTest(this.testDefinitions.getResource(test));
    }

    public void runTest(Resource test) {
        System.out.println("Running " + test);
        boolean success = false;
        boolean fail = false;
        try {
            success = this.doRunTest(test);
        }
        catch (Exception e2) {
            fail = true;
            System.out.print("\nException: " + e2);
            e2.printStackTrace();
        }
        ++this.testCount;
        if (success) {
            System.out.print(this.testCount % 40 == 0 ? ".\n" : ".");
            System.out.flush();
            ++this.passCount;
        } else {
            System.out.println("\nFAIL: " + test);
        }
        Resource resultType = null;
        resultType = fail ? OWLResults.FailingRun : (test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || test.hasProperty(RDF.type, OWLTest.ConsistencyTest) ? (success ? OWLResults.PassingRun : OWLResults.FailingRun) : (success ? OWLResults.PassingRun : OWLResults.IncompleteRun));
        Resource result = this.testResults.createResource().addProperty(RDF.type, OWLResults.TestRun).addProperty(RDF.type, resultType).addProperty(OWLResults.test, test).addProperty(OWLResults.system, this.jena2);
    }

    public boolean doRunTest(Resource test) throws IOException {
        if (test.hasProperty(RDF.type, OWLTest.PositiveEntailmentTest) || test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest) || test.hasProperty(RDF.type, OWLTest.OWLforOWLTest) || test.hasProperty(RDF.type, OWLTest.ImportEntailmentTest) || test.hasProperty(RDF.type, OWLTest.TrueTest)) {
            boolean processImports = test.hasProperty(RDF.type, OWLTest.ImportEntailmentTest);
            Model premises = this.getDoc(test, RDFTest.premiseDocument, processImports);
            Model conclusions = this.getDoc(test, RDFTest.conclusionDocument);
            this.comprehensionAxioms(premises, conclusions);
            long t1 = System.currentTimeMillis();
            InfGraph graph = this.reasoner.bind(premises.getGraph());
            if (printProfile) {
                ((FBRuleInfGraph)graph).resetLPProfile(true);
            }
            Model result = ModelFactory.createModelForGraph(graph);
            boolean correct = this.testEntailment(conclusions.getGraph(), result.getGraph());
            long t2 = System.currentTimeMillis();
            this.lastTestDuration = t2 - t1;
            if (printProfile) {
                ((FBRuleInfGraph)graph).printLPProfile();
            }
            if (test.hasProperty(RDF.type, OWLTest.NegativeEntailmentTest)) {
                correct = !correct;
            }
            return correct;
        }
        if (test.hasProperty(RDF.type, OWLTest.InconsistencyTest)) {
            Model input = this.getDoc(test, RDFTest.inputDocument);
            long t1 = System.currentTimeMillis();
            InfGraph graph = this.reasoner.bind(input.getGraph());
            boolean correct = !graph.validate().isValid();
            long t2 = System.currentTimeMillis();
            this.lastTestDuration = t2 - t1;
            return correct;
        }
        if (test.hasProperty(RDF.type, OWLTest.ConsistencyTest)) {
            Model input = this.getDoc(test, RDFTest.inputDocument);
            long t1 = System.currentTimeMillis();
            InfGraph graph = this.reasoner.bind(input.getGraph());
            boolean correct = graph.validate().isValid();
            long t2 = System.currentTimeMillis();
            this.lastTestDuration = t2 - t1;
            return correct;
        }
        StmtIterator i = test.listProperties(RDF.type);
        while (i.hasNext()) {
            System.out.println("Test type = " + i.nextStatement().getObject());
        }
        throw new ReasonerException("Unknown test type");
    }

    public Model getDoc(Resource test, Property docType, boolean processImports) throws IOException {
        if (processImports) {
            OntModel result = ModelFactory.createOntologyModel(OntModelSpec.OWL_MEM, null);
            StmtIterator si = test.listProperties(docType);
            while (si.hasNext()) {
                String fname = ((Object)si.nextStatement().getObject()).toString() + ".rdf";
                WebOntTestHarness.loadFile(fname, result);
            }
            return result;
        }
        return this.getDoc(test, docType);
    }

    public Model getDoc(Resource test, Property docType) throws IOException {
        Model result = ModelFactory.createDefaultModel();
        StmtIterator si = test.listProperties(docType);
        while (si.hasNext()) {
            String fname = ((Object)si.nextStatement().getObject()).toString() + ".rdf";
            WebOntTestHarness.loadFile(fname, result);
        }
        return result;
    }

    public static Model loadFile(String file, Model model) throws IOException {
        String langType = "RDF/XML";
        if (file.endsWith(".nt")) {
            langType = "N-TRIPLE";
        } else if (file.endsWith("n3")) {
            langType = "N3";
        }
        String fname = file;
        if (fname.startsWith(BASE_URI)) {
            fname = fname.substring(BASE_URI.length());
        }
        BufferedReader reader = new BufferedReader(new FileReader(BASE_TESTDIR + fname));
        model.read(reader, BASE_URI + fname, langType);
        return model;
    }

    public boolean testEntailment(Graph conclusions, Graph result) {
        QueryHandler qh = result.queryHandler();
        Query query2 = WGReasonerTester.graphToQuery(conclusions);
        ExtendedIterator i = qh.prepareBindings(query2, new Node[0]).executeBindings();
        return i.hasNext();
    }

    public void comprehensionAxioms(Model premises, Model conclusions) {
        Resource comp;
        HashMap<Resource, Resource> comprehension = new HashMap<Resource, Resource>();
        StmtIterator ri = conclusions.listStatements(null, RDF.type, OWL.Restriction);
        while (ri.hasNext()) {
            Resource restriction = ri.nextStatement().getSubject();
            StmtIterator pi2 = restriction.listProperties(OWL.onProperty);
            while (pi2.hasNext()) {
                Resource prop = (Resource)pi2.nextStatement().getObject();
                StmtIterator vi = restriction.listProperties();
                while (vi.hasNext()) {
                    Statement rs = vi.nextStatement();
                    if (rs.getPredicate().equals(OWL.onProperty)) continue;
                    Resource comp2 = premises.createResource().addProperty(RDF.type, OWL.Restriction).addProperty(OWL.onProperty, prop).addProperty(rs.getPredicate(), rs.getObject());
                    comprehension.put(restriction, comp2);
                }
            }
        }
        StmtIterator ii = conclusions.listStatements(null, OWL.intersectionOf, (RDFNode)null);
        ArrayList intersections = new ArrayList();
        while (ii.hasNext()) {
            intersections.add(ii.next());
        }
        Iterator i = intersections.iterator();
        while (i.hasNext()) {
            Statement is = (Statement)i.next();
            comp = premises.createResource().addProperty(RDF.type, OWL.Class).addProperty(OWL.intersectionOf, this.mapList(premises, (Resource)is.getObject(), comprehension));
            conclusions.remove(is);
            conclusions.add(is.getSubject(), OWL.equivalentClass, comp);
        }
        StmtIterator io = conclusions.listStatements(null, OWL.oneOf, (RDFNode)null);
        while (io.hasNext()) {
            Statement s = io.nextStatement();
            comp = premises.createResource().addProperty(OWL.oneOf, s.getObject());
        }
    }

    private Resource mapList(Model target, Resource list, Map map) {
        if (((Object)list).equals(RDF.nil)) {
            return RDF.nil;
        }
        Resource head = (Resource)list.getRequiredProperty(RDF.first).getObject();
        Resource rest = (Resource)list.getRequiredProperty(RDF.rest).getObject();
        Resource mapElt = target.createResource();
        Resource mapHead = (Resource)map.get(head);
        if (mapHead == null) {
            mapHead = head;
        }
        mapElt.addProperty(RDF.first, mapHead);
        mapElt.addProperty(RDF.rest, this.mapList(target, rest, map));
        return mapElt;
    }

    public List findTestsOfType(Resource testType) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        StmtIterator si = this.testDefinitions.listStatements(null, RDF.type, testType);
        while (si.hasNext()) {
            int i;
            Resource test = si.nextStatement().getSubject();
            boolean accept = true;
            Literal status = (Literal)test.getProperty(RDFTest.status).getObject();
            if (approvedOnly) {
                accept = status.getString().equals(STATUS_FLAGS[0]);
            } else {
                accept = false;
                for (i = 0; i < STATUS_FLAGS.length; ++i) {
                    if (!status.getString().equals(STATUS_FLAGS[i])) continue;
                    accept = true;
                    break;
                }
            }
            for (i = 0; i < BLOCKED_TESTS.length; ++i) {
                if (!BLOCKED_TESTS[i].equals(((Object)test).toString())) continue;
                accept = false;
            }
            if (!accept) continue;
            result.add(test);
        }
        return result;
    }
}

