/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine;

import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.engine.Plan;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintSerializableBase;

public abstract class PlanBase
extends PrintSerializableBase
implements Plan {
    private Op op = null;
    private boolean iteratorProduced = false;

    protected abstract QueryIterator iteratorOnce();

    public PlanBase(Op op) {
        this.op = op;
    }

    public Op getOp() {
        return this.op;
    }

    public final QueryIterator iterator() {
        if (this.iteratorProduced) {
            throw new ARQInternalErrorException("Attempt to use the iterator twice");
        }
        this.iteratorProduced = true;
        return this.iteratorOnce();
    }

    public void output(IndentedWriter out) {
        SerializationContext sCxt = new SerializationContext(ARQConstants.getGlobalPrefixMap());
        this.output(out, sCxt);
    }

    public void output(IndentedWriter out, SerializationContext sCxt) {
        this.op.output(out, sCxt);
    }
}

