/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.serializer.FmtExpr;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.FmtTemplateARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterARQ;
import com.hp.hpl.jena.sparql.serializer.FormatterElement;
import com.hp.hpl.jena.sparql.serializer.FormatterTemplate;
import com.hp.hpl.jena.sparql.serializer.QuerySerializer;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeToLabelMap;
import com.hp.hpl.jena.sparql.util.NodeToLabelMapBNode;
import java.io.OutputStream;

public class Serializer {
    static final int BLOCK_INDENT = 2;

    public static void serialize(Query query2, OutputStream out) {
        Serializer.serialize(query2, out, null);
    }

    public static void serialize(Query query2, OutputStream out, Syntax syntax) {
        IndentedWriter writer = new IndentedWriter(out);
        Serializer.serialize(query2, writer, syntax);
        writer.flush();
        try {
            out.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static void serialize(Query query2, IndentedLineBuffer buff) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, buff, s);
    }

    public static void serialize(Query query2, IndentedLineBuffer buff, Syntax outSyntax) {
        Serializer.serialize(query2, buff.getIndentedWriter(), outSyntax);
    }

    public static void serialize(Query query2, IndentedWriter writer) {
        Syntax s = query2.getSyntax();
        if (s == null) {
            s = Syntax.syntaxSPARQL;
        }
        Serializer.serialize(query2, writer, s);
    }

    public static void serialize(Query query2, IndentedWriter writer, Syntax outSyntax) {
        if (outSyntax == null) {
            outSyntax = Syntax.syntaxSPARQL;
        }
        if (outSyntax.equals(Syntax.syntaxARQ)) {
            Serializer.serializeARQ(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, writer);
            writer.flush();
            return;
        }
        if (outSyntax.equals(Syntax.syntaxSPARQL)) {
            Serializer.serializeSPARQL(query2, writer);
            writer.flush();
            return;
        }
        ALog.warn(Serializer.class, "Unknown syntax: " + outSyntax);
    }

    public static void serializeARQ(Query query2, IndentedWriter writer) {
        SerializationContext cxt1 = new SerializationContext(query2, (NodeToLabelMap)new NodeToLabelMapBNode("b", false));
        SerializationContext cxt2 = new SerializationContext(query2, (NodeToLabelMap)new NodeToLabelMapBNode("c", false));
        Serializer.serializeARQ(query2, writer, new FormatterARQ(writer, cxt1), new FmtExprARQ(writer, cxt1), new FmtTemplateARQ(writer, cxt2));
    }

    private static void serializeARQ(Query query2, IndentedWriter writer, FormatterElement eltFmt, FmtExpr exprFmt, FormatterTemplate templateFmt) {
        QuerySerializer serilizer = new QuerySerializer(writer, eltFmt, exprFmt, templateFmt);
        query2.visit(serilizer);
    }

    public static void serializeSPARQL(Query query2, IndentedWriter writer) {
        Serializer.serializeARQ(query2, writer);
    }
}

