/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.sse.builders;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.sparql.sse.Item;
import com.hp.hpl.jena.sparql.sse.ItemList;
import com.hp.hpl.jena.sparql.sse.ItemLocation;
import com.hp.hpl.jena.sparql.sse.builders.BuilderBase;
import com.hp.hpl.jena.sparql.util.StringUtils;
import java.util.Iterator;

public class BuilderPrefixMapping {
    public static PrefixMapping build(Item elt) {
        PrefixMappingImpl pmap = new PrefixMappingImpl();
        BuilderPrefixMapping.build(pmap, elt);
        return pmap;
    }

    public static void build(PrefixMapping newMappings, Item elt) {
        if (!elt.isList()) {
            BuilderBase.broken((ItemLocation)elt, "Prefix mapping requires a list of pairs", elt);
        }
        ItemList prefixes = elt.getList();
        if (elt.isTaggedIgnoreCase("prefixmap") || elt.isTaggedIgnoreCase("prefixmapping")) {
            BuilderBase.checkLength(2, elt.getList(), "Not of length 2" + elt.shortString());
            prefixes = prefixes.cdr();
        }
        Iterator iter = prefixes.iterator();
        while (iter.hasNext()) {
            Node iriNode;
            Item pair = (Item)iter.next();
            if (!pair.isList() || pair.getList().size() != 2) {
                BuilderBase.broken(pair, "Not a prefix/IRI pair");
            }
            Item prefixItem = pair.getList().get(0);
            Item iriItem = pair.getList().get(1);
            String prefix = null;
            if (prefixItem.isSymbol()) {
                prefix = prefixItem.getSymbol();
            }
            if (prefix == null) {
                BuilderBase.broken(pair, "Prefix part nor recognized: " + prefixItem);
            }
            if (!prefix.endsWith(":")) {
                BuilderBase.broken(pair, "Prefix part does not end with a ':': " + pair);
            }
            if (StringUtils.contains(prefix = prefix.substring(0, prefix.length() - 1), ":")) {
                BuilderBase.broken(pair, "Prefix itseld contains a ':' : " + pair);
            }
            if ((iriNode = iriItem.getNode()) == null || !iriNode.isURI()) {
                BuilderBase.broken(pair, "Not an IRI: " + iriItem);
            }
            String iri = iriNode.getURI();
            newMappings.setNsPrefix(prefix, iri);
        }
    }
}

