/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.query.ResultSetFactory;
import com.hp.hpl.jena.query.ResultSetFormatter;
import com.hp.hpl.jena.query.ResultSetRewindable;
import com.hp.hpl.jena.query.larq.IndexBuilderModel;
import com.hp.hpl.jena.query.larq.IndexBuilderString;
import com.hp.hpl.jena.query.larq.IndexBuilderSubject;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.query.larq.LARQ;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.junit.QueryTest;
import com.hp.hpl.jena.util.FileManager;
import com.hp.hpl.jena.vocabulary.DC;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestLARQ2
extends TestCase {
    static final String root = "testing/LARQ/";

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestLARQ2.class);
        ts.setName("LARQ-Scripts");
        return ts;
    }

    public TestLARQ2(String name) {
        super(name);
    }

    static void runTestScript(String queryFile, String dataFile, String resultsFile, IndexBuilderModel builder) {
        Query query2 = QueryFactory.read(root + queryFile);
        IndexBuilderString larqBuilder = new IndexBuilderString();
        Model model = ModelFactory.createDefaultModel();
        model.register(builder);
        FileManager.get().readModel(model, root + dataFile);
        model.unregister(builder);
        IndexLARQ index = builder.getIndex();
        LARQ.setDefaultIndex(index);
        QueryExecution qe = QueryExecutionFactory.create(query2, model);
        ResultSetRewindable rsExpected = ResultSetFactory.makeRewindable(ResultSetFactory.load(root + resultsFile));
        ResultSetRewindable rsActual = ResultSetFactory.makeRewindable(qe.execSelect());
        boolean b = QueryTest.resultSetEquivalent(query2, (ResultSet)rsActual, rsExpected);
        if (!b) {
            rsActual.reset();
            rsExpected.reset();
            System.out.println("==== Different (LARQ)");
            System.out.println("== Actual");
            ResultSetFormatter.out(rsActual);
            System.out.println("== Expected");
            ResultSetFormatter.out(rsExpected);
        }
        TestLARQ2.assertTrue((boolean)b);
        qe.close();
        LARQ.removeDefaultIndex();
    }

    public void test_larq_1() {
        TestLARQ2.runTestScript("larq-q-1.rq", "data-1.ttl", "results-1.srj", new IndexBuilderString());
    }

    public void test_larq_2() {
        TestLARQ2.runTestScript("larq-q-2.rq", "data-1.ttl", "results-2.srj", new IndexBuilderString(DC.title));
    }

    public void test_larq_3() {
        TestLARQ2.runTestScript("larq-q-3.rq", "data-1.ttl", "results-3.srj", new IndexBuilderSubject(DC.title));
    }

    public void test_larq_4() {
        TestLARQ2.runTestScript("larq-q-4.rq", "data-1.ttl", "results-4.srj", new IndexBuilderString());
    }

    public void test_larq_5() {
        TestLARQ2.runTestScript("larq-q-5.rq", "data-1.ttl", "results-5.srj", new IndexBuilderString());
    }

    public void test_larq_6() {
        TestLARQ2.runTestScript("larq-q-6.rq", "data-1.ttl", "results-6.srj", new IndexBuilderString());
    }

    public void test_larq_7() {
        TestLARQ2.runTestScript("larq-q-7.rq", "data-1.ttl", "results-7.srj", new IndexBuilderString());
    }
}

