/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites;

import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.sparql.util.GNode;
import com.hp.hpl.jena.sparql.util.GraphList;
import com.hp.hpl.jena.sparql.util.Utils;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestList
extends TestCase {
    GNode emptyList = TestList.parse(listStr_1);
    GNode list4 = TestList.parse(listStr_2);
    GNode list22 = TestList.parse(listStr_3);
    Node NIL = RDF.nil.asNode();
    private static Node node1 = Node.createLiteral("1", "", XSDDatatype.XSDinteger);
    private static Node node2 = Node.createLiteral("2", "", XSDDatatype.XSDinteger);
    private static Node node3 = Node.createLiteral("3", "", XSDDatatype.XSDinteger);
    private static Node node4 = Node.createLiteral("4", "", XSDDatatype.XSDinteger);
    private static Node node0 = Node.createLiteral("0", "", XSDDatatype.XSDinteger);
    private static Node r = Node.createURI("http://example/r");
    private static Node p = Node.createURI("http://example/p");
    private static String preamble = "@prefix : <http://example/> . :r :p ";
    private static String listStr_1 = preamble + "() .";
    private static String listStr_2 = preamble + "(1 2 3 4) .";
    private static String listStr_3 = preamble + "(1 2 1 2) .";

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestList.class);
        ts.setName(Utils.classShortName(TestList.class));
        return ts;
    }

    public void testListLength_1() {
        TestList.assertEquals((int)0, (int)GraphList.length(this.emptyList));
    }

    public void testListLength_2() {
        TestList.assertEquals((int)4, (int)GraphList.length(this.list4));
    }

    public void testListLength_3() {
        TestList.assertEquals((int)4, (int)GraphList.length(this.list22));
    }

    public void testListIndex_1() {
        TestList.assertEquals((int)0, (int)GraphList.index(this.list4, node1));
    }

    public void testListIndex_2() {
        TestList.assertEquals((int)1, (int)GraphList.index(this.list4, node2));
    }

    public void testListIndex_3() {
        TestList.assertEquals((int)2, (int)GraphList.index(this.list4, node3));
    }

    public void testListIndex_4() {
        TestList.assertEquals((int)3, (int)GraphList.index(this.list4, node4));
    }

    public void testListIndex_5() {
        TestList.assertEquals((int)-1, (int)GraphList.index(this.list4, node0));
    }

    public void testListIndex_6() {
        TestList.assertEquals((int)-1, (int)GraphList.index(this.emptyList, node1));
    }

    public void testListIndex_7() {
        TestList.assertEquals((int)0, (int)GraphList.index(this.list22, node1));
    }

    public void testListIndex_8() {
        TestList.assertEquals((int)1, (int)GraphList.index(this.list22, node2));
    }

    public void testListIndexes_1() {
        List x = GraphList.indexes(this.emptyList, node0);
        TestList.assertEquals((int)0, (int)x.size());
    }

    public void testListIndexes_2() {
        List x = GraphList.indexes(this.list4, node0);
        TestList.assertEquals((int)0, (int)x.size());
    }

    public void testListIndexes_3() {
        List x = GraphList.indexes(this.list4, node1);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)0, (int)((Integer)x.get(0)));
    }

    public void testListIndexes_4() {
        List x = GraphList.indexes(this.list4, node2);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)1, (int)((Integer)x.get(0)));
    }

    public void testListIndexes_5() {
        List x = GraphList.indexes(this.list4, node4);
        TestList.assertEquals((int)1, (int)x.size());
        TestList.assertEquals((int)3, (int)((Integer)x.get(0)));
    }

    public void testListIndexes_6() {
        List x = GraphList.indexes(this.list22, node1);
        TestList.assertEquals((int)2, (int)x.size());
        TestList.assertEquals((int)0, (int)((Integer)x.get(0)));
        TestList.assertEquals((int)2, (int)((Integer)x.get(1)));
    }

    public void testListTriples_1() {
        TestList.assertEquals((int)0, (int)GraphList.allTriples(this.emptyList).size());
    }

    public void testListTriples_2() {
        TestList.assertEquals((int)8, (int)GraphList.allTriples(this.list4).size());
    }

    public void testListContains_1() {
        TestList.assertFalse((boolean)GraphList.contains(this.emptyList, node0));
    }

    public void testListContains_2() {
        TestList.assertFalse((boolean)GraphList.contains(this.emptyList, node1));
    }

    public void testListContains_3() {
        TestList.assertTrue((boolean)GraphList.contains(this.list4, node1));
    }

    public void testListContains_4() {
        TestList.assertTrue((boolean)GraphList.contains(this.list4, node2));
    }

    public void testListContains_5() {
        TestList.assertTrue((boolean)GraphList.contains(this.list4, node4));
    }

    public void testListOccurs_1() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.emptyList, node0));
    }

    public void testListOccurs_2() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.emptyList, node1));
    }

    public void testListOccurs_3() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.list4, node0));
    }

    public void testListOccurs_4() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.emptyList, node1));
    }

    public void testListOccurs_5() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.emptyList, this.NIL));
    }

    public void testListOccurs_6() {
        TestList.assertEquals((int)0, (int)GraphList.occurs(this.list4, this.NIL));
    }

    public void testListOccurs_7() {
        TestList.assertEquals((int)1, (int)GraphList.occurs(this.list4, node1));
    }

    public void testListOccurs_8() {
        TestList.assertEquals((int)1, (int)GraphList.occurs(this.list4, node2));
    }

    public void testListOccurs_9() {
        TestList.assertEquals((int)1, (int)GraphList.occurs(this.list4, node3));
    }

    public void testListOccurs_10() {
        TestList.assertEquals((int)1, (int)GraphList.occurs(this.list4, node4));
    }

    public void testListOccurs_11() {
        TestList.assertEquals((int)2, (int)GraphList.occurs(this.list22, node1));
    }

    public void testListOccurs_12() {
        TestList.assertEquals((int)2, (int)GraphList.occurs(this.list22, node2));
    }

    public void testListGet_1() {
        TestList.assertNull((Object)GraphList.get(this.emptyList, 0));
    }

    public void testListGet_2() {
        TestList.assertNull((Object)GraphList.get(this.emptyList, -1));
    }

    public void testListGet_3() {
        TestList.assertNull((Object)GraphList.get(this.list4, -1));
    }

    public void testListGet_4() {
        TestList.assertNull((Object)GraphList.get(this.list4, 9));
    }

    public void testListGet_5() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get(this.list4, 0));
    }

    public void testListGet_6() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get(this.list4, 0));
        TestList.assertEquals((Object)node2, (Object)GraphList.get(this.list4, 1));
        TestList.assertEquals((Object)node3, (Object)GraphList.get(this.list4, 2));
        TestList.assertEquals((Object)node4, (Object)GraphList.get(this.list4, 3));
    }

    public void testListGet_7() {
        TestList.assertEquals((Object)node1, (Object)GraphList.get(this.list22, 0));
        TestList.assertEquals((Object)node2, (Object)GraphList.get(this.list22, 1));
        TestList.assertEquals((Object)node1, (Object)GraphList.get(this.list22, 2));
        TestList.assertEquals((Object)node2, (Object)GraphList.get(this.list22, 3));
    }

    private static GNode gnode(Node n) {
        return new GNode(Factory.createDefaultGraph(), n);
    }

    private static GNode parse(String str2) {
        Model m = ModelFactory.createDefaultModel();
        m.read(new StringReader(str2), null, "TTL");
        Graph graph = m.getGraph();
        Triple t = (Triple)graph.find(r, p, Node.ANY).next();
        return new GNode(graph, t.getObject());
    }
}

