/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.suites.optimizer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Seq;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.engine.optimizer.core.BasicPatternGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.core.ConnectedGraph;
import com.hp.hpl.jena.sparql.engine.optimizer.heuristic.VariableCounting;
import com.hp.hpl.jena.sparql.suites.optimizer.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestGraphBuild
extends TestCase {
    private BasicPattern pattern;
    private List components;
    private static final String testCaseFileName = "testing/Optimizer/TestGraphBuild-manifest.n3";

    public TestGraphBuild(String title, BasicPattern pattern, List components) {
        super(title);
        this.pattern = pattern;
        this.components = components;
    }

    protected void runTest() {
        BasicPatternGraph graph = new BasicPatternGraph(this.pattern, new VariableCounting());
        TestGraphBuild.assertTrue((graph.numberOfConnectedComponents() == this.components.size() ? (byte)1 : 0) != 0);
        for (int i = 0; i < this.components.size(); ++i) {
            Integer nodes = (Integer)((Map)this.components.get(i)).get("nodes");
            Integer edges = (Integer)((Map)this.components.get(i)).get("edges");
            ConnectedGraph component = graph.getComponent(i);
            TestGraphBuild.assertTrue((component.getNodes().size() == nodes.intValue() ? (byte)1 : 0) != 0);
            TestGraphBuild.assertTrue((component.getEdges().size() == edges.intValue() ? (byte)1 : 0) != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Test suite() {
        TestSuite ts = new TestSuite("TestGraphBuild");
        Model model = Util.readModel(testCaseFileName);
        QueryExecution qe = QueryExecutionFactory.create(TestGraphBuild.queryTestCases(), model);
        try {
            ResultSet rs = qe.execSelect();
            while (rs.hasNext()) {
                QuerySolution solution = rs.nextSolution();
                String title = solution.getLiteral("title").getLexicalForm();
                Seq patternR = model.getSeq(solution.getResource("pattern"));
                Seq graphR = model.getSeq(solution.getResource("graph"));
                BasicPattern basicPattern = TestGraphBuild.getBasicPattern(patternR);
                List components = TestGraphBuild.getGraphComponents(graphR);
                ts.addTest((Test)new TestGraphBuild(title, basicPattern, components));
            }
        }
        finally {
            qe.close();
        }
        model.close();
        return ts;
    }

    private static BasicPattern getBasicPattern(Seq patternR) {
        BasicPattern pattern = new BasicPattern();
        NodeIterator iter = patternR.iterator();
        while (iter.hasNext()) {
            String[] triple = ((Literal)iter.next()).getLexicalForm().split(" ");
            pattern.add(new Triple(Util.createNode(triple[0]), Util.createNode(triple[1]), Util.createNode(triple[2])));
        }
        return pattern;
    }

    private static List getGraphComponents(Seq graphR) {
        Property nodesP = ResourceFactory.createProperty("http://www.w3.org/2006/03/test-description#nodes");
        Property edgesP = ResourceFactory.createProperty("http://www.w3.org/2006/03/test-description#edges");
        ArrayList components = new ArrayList();
        NodeIterator iter = graphR.iterator();
        while (iter.hasNext()) {
            Resource componentR = (Resource)iter.next();
            HashMap<String, Integer> component = new HashMap<String, Integer>();
            String nodes = componentR.getProperty(nodesP).getObject().asNode().getLiteralLexicalForm();
            String edges = componentR.getProperty(edgesP).getObject().asNode().getLiteralLexicalForm();
            component.put("nodes", new Integer(nodes));
            component.put("edges", new Integer(edges));
            components.add(component);
        }
        return components;
    }

    private static String queryTestCases() {
        return "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>PREFIX dc: <http://purl.org/dc/elements/1.1/>PREFIX : <http://www.w3.org/2006/03/test-description#>SELECT ?title ?pattern ?graph WHERE {?tc rdf:type :TestCase .?tc dc:title ?title .?tc :pattern ?pattern .?tc :graph ?graph .}ORDER BY ASC(?title)";
    }
}

