/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.ContentLengthCounter;
import com.sun.mail.mbox.ContentLengthUpdater;
import com.sun.mail.mbox.InboxFile;
import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.MboxMessage;
import com.sun.mail.mbox.MboxStore;
import com.sun.mail.mbox.NewlineOutputStream;
import com.sun.mail.mbox.UNIXFile;
import com.sun.mail.mbox.match;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMessage;

public class MboxFolder
extends Folder {
    private String name;
    private boolean is_inbox = false;
    private int total;
    private boolean opened = false;
    private Vector message_cache;
    private MboxStore mstore;
    private MailFile folder;
    private long file_size;
    private long saved_file_size;
    private MboxMessage special_imap_message;

    public MboxFolder(MboxStore store, String name) {
        super(store);
        this.mstore = store;
        this.name = name;
        if (name != null && name.equalsIgnoreCase("INBOX")) {
            this.is_inbox = true;
        }
        this.folder = this.mstore.getMailFile(name == null ? "~" : name);
        this.saved_file_size = this.folder.exists() ? this.folder.length() : -1L;
    }

    public char getSeparator() {
        return File.separatorChar;
    }

    public Folder[] list(String pattern) throws MessagingException {
        if (!this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        if (this.name == null) {
            return this.list(null, pattern, true);
        }
        return this.list(this.name + File.separator, pattern, false);
    }

    protected Folder[] list(String ref, String pattern, boolean fromStore) throws MessagingException {
        if (ref != null && ref.length() == 0) {
            ref = null;
        }
        String refdir = null;
        String realdir = null;
        int i = MboxFolder.indexOfAny(pattern = MboxFolder.canonicalize(ref, pattern), "%*");
        refdir = i >= 0 ? pattern.substring(0, i) : pattern;
        i = refdir.lastIndexOf(File.separatorChar);
        if (i >= 0) {
            refdir = refdir.substring(0, i + 1);
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        } else if (refdir.length() == 0 || refdir.charAt(0) != '~') {
            refdir = null;
            realdir = this.mstore.home;
        } else {
            realdir = this.mstore.mb.filename(this.mstore.user, refdir);
        }
        Vector<String> flist = new Vector<String>();
        this.listWork(realdir, refdir, pattern, fromStore ? 0 : 1, flist);
        if (match.path("INBOX", pattern, '\u0000')) {
            flist.addElement("INBOX");
        }
        Folder[] fl = new Folder[flist.size()];
        for (i = 0; i < fl.length; ++i) {
            fl[i] = this.createFolder(this.mstore, (String)flist.elementAt(i));
        }
        return fl;
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        if (this.is_inbox) {
            return "INBOX";
        }
        return this.folder.getName();
    }

    public String getFullName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public Folder getParent() {
        if (this.name == null) {
            return null;
        }
        if (this.is_inbox) {
            return this.createFolder(this.mstore, null);
        }
        return this.createFolder(this.mstore, this.folder.getParent());
    }

    public boolean exists() {
        return this.folder.exists();
    }

    public int getType() {
        if (this.folder.isDirectory()) {
            return 2;
        }
        return 1;
    }

    public Flags getPermanentFlags() {
        return MboxStore.permFlags;
    }

    public synchronized boolean hasNewMessages() {
        if (this.folder instanceof UNIXFile) {
            UNIXFile f = (UNIXFile)((Object)this.folder);
            if (f.length() > 0L) {
                long mtime;
                long atime = f.lastAccessed();
                return atime < (mtime = f.lastModified());
            }
            return false;
        }
        long current_size = this.folder.exists() ? this.folder.length() : -1L;
        if (this.saved_file_size < 0L) {
            this.saved_file_size = current_size;
        }
        return current_size > this.saved_file_size;
    }

    public synchronized Folder getFolder(String name) throws MessagingException {
        if (this.folder.exists() && !this.folder.isDirectory()) {
            throw new MessagingException("not a directory");
        }
        Folder f = this.name != null ? this.createFolder(this.mstore, this.name + File.separator + name) : this.createFolder(this.mstore, name);
        return f;
    }

    public synchronized boolean create(int type) throws MessagingException {
        switch (type) {
            case 2: {
                if (this.folder.mkdirs()) break;
                return false;
            }
            case 1: {
                if (this.folder.exists()) {
                    return false;
                }
                try {
                    new FileOutputStream((File)((Object)this.folder)).close();
                    break;
                }
                catch (FileNotFoundException fe) {
                    File parent = new File(this.folder.getParent());
                    if (!parent.mkdirs()) {
                        throw new MessagingException("can't create folder: " + this.name);
                    }
                    try {
                        new FileOutputStream((File)((Object)this.folder)).close();
                        break;
                    }
                    catch (IOException ex3) {
                        throw new MessagingException("can't create folder: " + this.name, ex3);
                    }
                }
                catch (IOException e2) {
                    throw new MessagingException("can't create folder: " + this.name, e2);
                }
            }
            default: {
                throw new MessagingException("type not supported");
            }
        }
        this.notifyFolderListeners(1);
        return true;
    }

    public synchronized boolean delete(boolean recurse) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't delete default folder");
        }
        if (this.folder.delete()) {
            this.notifyFolderListeners(2);
            return true;
        }
        return false;
    }

    public synchronized boolean renameTo(Folder f) throws MessagingException {
        this.checkClosed();
        if (this.name == null) {
            throw new MessagingException("can't rename default folder");
        }
        if (!(f instanceof MboxFolder)) {
            throw new MessagingException("can't rename to: " + f.getName());
        }
        String newname = ((MboxFolder)f).folder.getPath();
        if (this.folder.renameTo(new File(this.folder.getPath(), newname))) {
            this.notifyFolderRenamedListeners(f);
            return true;
        }
        return false;
    }

    void checkOpen() throws IllegalStateException {
        if (!this.opened) {
            throw new IllegalStateException("Folder is not Open");
        }
    }

    void checkClosed() throws IllegalStateException {
        if (this.opened) {
            throw new IllegalStateException("Folder is Open");
        }
    }

    void checkReadable() throws IllegalStateException {
        if (!this.opened || this.mode != 1 && this.mode != 2) {
            throw new IllegalStateException("Folder is not Readable");
        }
    }

    void checkWritable() throws IllegalStateException {
        if (!this.opened || this.mode != 2) {
            throw new IllegalStateException("Folder is not Writable");
        }
    }

    public boolean isOpen() {
        return this.opened;
    }

    public synchronized void open(int mode) throws MessagingException {
        InboxFile inf;
        if (this.opened) {
            throw new IllegalStateException("Folder is already Open");
        }
        this.mode = mode;
        switch (mode) {
            default: {
                if (this.folder.canWrite()) break;
                throw new MessagingException("Open Failure, can't write");
            }
            case 1: 
        }
        if (!this.folder.canRead()) {
            throw new MessagingException("Open Failure, can't read");
        }
        if (this.is_inbox && this.folder instanceof InboxFile && !(inf = (InboxFile)this.folder).openLock(mode == 2 ? "rw" : "r")) {
            throw new MessagingException("Failed to lock INBOX");
        }
        if (!this.folder.lock("r")) {
            throw new MessagingException("Failed to lock folder: " + this.name);
        }
        this.message_cache = new Vector();
        this.total = 0;
        Message[] msglist = null;
        try {
            this.saved_file_size = this.folder.length();
            msglist = this.load(0L, false);
        }
        catch (IOException e2) {
            throw new MessagingException("IOException", e2);
        }
        finally {
            this.folder.unlock();
        }
        this.notifyConnectionListeners(1);
        if (msglist != null) {
            this.notifyMessageAddedListeners(msglist);
        }
        this.opened = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean expunge) throws MessagingException {
        this.checkOpen();
        try {
            if (this.mode == 2) {
                try {
                    this.writeFolder(true, expunge);
                }
                catch (IOException e2) {
                    throw new MessagingException("I/O Exception", e2);
                }
            }
            this.message_cache = null;
        }
        finally {
            this.opened = false;
            if (this.is_inbox && this.folder instanceof InboxFile) {
                InboxFile inf = (InboxFile)this.folder;
                inf.closeLock();
            }
            this.notifyConnectionListeners(3);
        }
    }

    /*
     * Loose catch block
     */
    protected int writeFolder(boolean closing, boolean expunge) throws IOException, MessagingException {
        int wr;
        block40: {
            boolean keep;
            BufferedOutputStream os;
            Message[] msglist;
            block35: {
                String skeep;
                int modified = 0;
                int deleted = 0;
                int recent = 0;
                for (int msgno = 1; msgno <= this.total; ++msgno) {
                    MboxMessage msg = (MboxMessage)this.message_cache.elementAt(msgno - 1);
                    Flags flags = msg.getFlags();
                    if (msg.isModified() || !msg.origFlags.equals(flags)) {
                        ++modified;
                    }
                    if (flags.contains(Flags.Flag.DELETED)) {
                        ++deleted;
                    }
                    if (!flags.contains(Flags.Flag.RECENT)) continue;
                    ++recent;
                }
                if (!(closing && recent != 0 || expunge && deleted != 0 || modified != 0)) {
                    return 0;
                }
                if (!this.folder.lock("rw")) {
                    throw new MessagingException("Failed to lock folder: " + this.name);
                }
                int oldtotal = this.total;
                msglist = null;
                if (this.folder.length() != this.file_size) {
                    msglist = this.load(this.file_size, !closing);
                }
                os = new BufferedOutputStream(new FileOutputStream((File)((Object)this.folder)));
                wr = 0;
                keep = true;
                if (this.special_imap_message != null) {
                    MboxFolder.writeMboxMessage(this.special_imap_message, os);
                }
                for (int msgno = 1; msgno <= this.total; ++msgno) {
                    MboxMessage msg = (MboxMessage)this.message_cache.elementAt(msgno - 1);
                    if (expunge && msg.isSet(Flags.Flag.DELETED)) continue;
                    if (closing && msgno <= oldtotal && msg.isSet(Flags.Flag.RECENT)) {
                        msg.setFlag(Flags.Flag.RECENT, false);
                    }
                    MboxFolder.writeMboxMessage(msg, os);
                    this.folder.touchlock();
                    ++wr;
                }
                this.file_size = this.saved_file_size = this.folder.length();
                if (wr != 0 || !closing || (skeep = ((MboxStore)this.store).getSession().getProperty("mail.mbox.deleteEmpty")) == null || !skeep.equalsIgnoreCase("true")) break block35;
                keep = false;
            }
            Object var14_17 = null;
            try {
                ((OutputStream)os).close();
                if (!keep) {
                    this.folder.delete();
                    this.file_size = 0L;
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (keep) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                FileInputStream is = null;
                try {
                    is = new FileInputStream((File)((Object)this.folder));
                    ((InputStream)is).read();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                try {
                    if (is != null) {
                        ((InputStream)is).close();
                    }
                    is = null;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            this.folder.unlock();
            if (msglist != null) {
                this.notifyMessageAddedListeners(msglist);
            }
            break block40;
            {
                catch (IOException e2) {
                    throw e2;
                }
                catch (MessagingException e3) {
                    throw e3;
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                    throw new MessagingException("unexpected exception " + e4);
                }
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                try {
                    ((OutputStream)os).close();
                    if (!keep) {
                        this.folder.delete();
                        this.file_size = 0L;
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                if (keep) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    FileInputStream is = null;
                    try {
                        is = new FileInputStream((File)((Object)this.folder));
                        ((InputStream)is).read();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                        is = null;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                this.folder.unlock();
                if (msglist != null) {
                    this.notifyMessageAddedListeners(msglist);
                }
                throw throwable;
            }
        }
        return wr;
    }

    public static void writeMboxMessage(MimeMessage msg, OutputStream os) throws IOException, MessagingException {
        try {
            if (msg instanceof MboxMessage) {
                ((MboxMessage)msg).writeToFile(os);
            } else {
                ContentLengthCounter cos2 = new ContentLengthCounter();
                NewlineOutputStream nos = new NewlineOutputStream(cos2);
                msg.writeTo(nos);
                nos.flush();
                os = new NewlineOutputStream(os);
                os = new ContentLengthUpdater(os, cos2.getSize());
                PrintStream pos = new PrintStream(os);
                pos.println(MboxFolder.getUnixFrom(msg));
                msg.writeTo(pos);
                pos.println();
                pos.flush();
            }
        }
        catch (MessagingException me) {
            throw me;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static String getUnixFrom(MimeMessage msg) {
        Date ddate;
        String from;
        try {
            Address[] afrom = msg.getFrom();
            if (afrom == null || !(afrom[0] instanceof InternetAddress) || (from = ((InternetAddress)afrom[0]).getAddress()) == null) {
                from = "UNKNOWN";
            }
            if ((ddate = msg.getReceivedDate()) == null || (ddate = msg.getSentDate()) == null) {
                ddate = new Date();
            }
        }
        catch (MessagingException e2) {
            from = "UNKNOWN";
            ddate = new Date();
        }
        String date2 = ddate.toString();
        return "From " + from + " " + date2.substring(0, 20) + date2.substring(24);
    }

    public synchronized int getMessageCount() throws MessagingException {
        if (!this.opened) {
            return -1;
        }
        boolean locked = false;
        Message[] msglist = null;
        try {
            if (this.folder.length() != this.file_size) {
                if (!this.folder.lock("r")) {
                    throw new MessagingException("Failed to lock folder: " + this.name);
                }
                locked = true;
                msglist = this.load(this.file_size, true);
            }
        }
        catch (IOException e2) {
            throw new MessagingException("I/O Exception", e2);
        }
        finally {
            if (locked) {
                this.folder.unlock();
                if (msglist != null) {
                    this.notifyMessageAddedListeners(msglist);
                }
            }
        }
        return this.total;
    }

    public synchronized Message getMessage(int msgno) throws MessagingException {
        this.checkReadable();
        MboxMessage m = null;
        if (msgno <= this.total) {
            m = (MboxMessage)this.message_cache.elementAt(msgno - 1);
        }
        return m;
    }

    public synchronized void appendMessages(Message[] msgs) throws MessagingException {
        if (!this.folder.lock("rw")) {
            throw new MessagingException("Failed to lock folder: " + this.name);
        }
        OutputStream os = null;
        boolean err = false;
        try {
            os = new BufferedOutputStream(new FileOutputStream(((File)((Object)this.folder)).getPath(), true));
            for (int i = 0; i < msgs.length; ++i) {
                if (!(msgs[i] instanceof MimeMessage)) {
                    err = true;
                    continue;
                }
                MboxFolder.writeMboxMessage((MimeMessage)msgs[i], os);
                this.folder.touchlock();
            }
        }
        catch (IOException e2) {
            throw new MessagingException("I/O Exception", e2);
        }
        catch (MessagingException e3) {
            throw e3;
        }
        catch (Exception e4) {
            e4.printStackTrace();
            throw new MessagingException("unexpected exception " + e4);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e5) {}
            }
            this.folder.unlock();
        }
        if (this.opened) {
            this.getMessageCount();
        }
        if (err) {
            throw new MessagingException("Can't append non-Mime message");
        }
    }

    public synchronized Message[] expunge() throws MessagingException {
        this.checkWritable();
        int wr = this.total;
        try {
            wr = this.writeFolder(false, true);
        }
        catch (IOException e2) {
            throw new MessagingException("expunge failed", e2);
        }
        if (wr == 0) {
            return new Message[0];
        }
        int del = 0;
        Message[] msglist = new Message[this.total - wr];
        int msgno = 1;
        while (msgno <= this.total) {
            MboxMessage msg = (MboxMessage)this.message_cache.elementAt(msgno - 1);
            if (msg.isSet(Flags.Flag.DELETED)) {
                msglist[del] = msg;
                ++del;
                this.message_cache.removeElementAt(msgno - 1);
                --this.total;
                continue;
            }
            msg.setMessageNumber(msgno);
            ++msgno;
        }
        if (del != msglist.length) {
            throw new MessagingException("expunge delete count wrong");
        }
        this.notifyMessageRemovedListeners(true, msglist);
        return msglist;
    }

    private Message[] load(long offset, boolean notify) throws MessagingException, IOException {
        int oldtotal = this.total;
        try {
            boolean first = offset == 0L;
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.folder.getFD()), 8192);
            this.skipFully(in, offset);
            while (true) {
                MboxMessage msg = this.loadMessage(in, this.total, this.mode == 2);
                if (first) {
                    first = false;
                    if (msg.getHeader("X-IMAP") != null) {
                        this.special_imap_message = msg;
                        continue;
                    }
                }
                ++this.total;
                msg.setMessageNumber(this.total);
                this.message_cache.addElement(msg);
            }
        }
        catch (EOFException e2) {
            this.file_size = this.folder.length();
            if (notify) {
                Message[] msglist = new Message[this.total - oldtotal];
                int i = oldtotal;
                int j = 0;
                while (i < this.total) {
                    msglist[j] = (Message)this.message_cache.elementAt(i);
                    ++i;
                    ++j;
                }
                return msglist;
            }
            return null;
        }
    }

    private MboxMessage loadMessage(BufferedInputStream is, int msgno, boolean writable) throws MessagingException, IOException {
        String line;
        DataInputStream in = new DataInputStream(is);
        String unix_from = null;
        while ((line = in.readLine()) != null) {
            if (line.trim().length() == 0) continue;
            if (line.startsWith("From ")) {
                unix_from = line;
                int i = unix_from.indexOf(32, 5);
                if (i >= 0) break;
                continue;
            }
            throw new MessagingException("Garbage in mailbox: " + line);
        }
        if (unix_from == null) {
            throw new EOFException("end of mailbox");
        }
        InternetHeaders hdrs = new InternetHeaders(is);
        byte[] content = null;
        try {
            int len = this.contentLength(hdrs);
            if (len >= 0) {
                content = new byte[len];
                in.readFully(content);
            } else {
                int b;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                while ((b = is.read()) >= 0) {
                    if (b == 13 || b == 10) {
                        is.mark(6);
                        if (b == 13 && is.read() != 10) {
                            is.reset();
                            is.mark(5);
                        }
                        if (is.read() == 70 && is.read() == 114 && is.read() == 111 && is.read() == 109 && is.read() == 32) {
                            is.reset();
                            break;
                        }
                        is.reset();
                    }
                    buf.write(b);
                }
                content = buf.toByteArray();
            }
        }
        catch (EOFException e2) {
            // empty catch block
        }
        return new MboxMessage(this, hdrs, content, msgno, unix_from, writable);
    }

    private int contentLength(InternetHeaders hdrs) {
        int len = -1;
        String[] cl = hdrs.getHeader("Content-Length");
        try {
            if (cl != null && cl[0] != null) {
                len = Integer.parseInt(cl[0]);
            }
        }
        catch (NumberFormatException e2) {
            // empty catch block
        }
        return len;
    }

    private void skipFully(InputStream in, long offset) throws IOException {
        while (offset > 0L) {
            long cur = in.skip(offset);
            if (cur <= 0L) {
                throw new EOFException("can't skip");
            }
            offset -= cur;
        }
    }

    protected void notifyMessageChangedListeners(int type, Message m) {
        super.notifyMessageChangedListeners(type, m);
    }

    public URLName getURLName() {
        URLName storeURL = this.getStore().getURLName();
        if (this.name == null) {
            return storeURL;
        }
        char separator = this.getSeparator();
        String fullname = this.getFullName();
        StringBuffer encodedName = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(fullname, Character.toString(separator), true);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.charAt(0) == separator) {
                encodedName.append("/");
                continue;
            }
            encodedName.append(s);
        }
        return new URLName(storeURL.getProtocol(), storeURL.getHost(), storeURL.getPort(), encodedName.toString(), storeURL.getUsername(), null);
    }

    protected Folder createFolder(MboxStore store, String name) {
        return new MboxFolder(store, name);
    }

    private static String canonicalize(String ref, String pat) {
        if (ref == null) {
            return pat;
        }
        try {
            if (pat.length() == 0) {
                return ref;
            }
            if (pat.charAt(0) == File.separatorChar) {
                return ref.substring(0, ref.indexOf(File.separatorChar)) + pat;
            }
            return ref + pat;
        }
        catch (StringIndexOutOfBoundsException e2) {
            return pat;
        }
    }

    private static int indexOfAny(String s, String any) {
        try {
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                if (any.indexOf(s.charAt(i)) < 0) continue;
                return i;
            }
            return -1;
        }
        catch (StringIndexOutOfBoundsException e2) {
            return -1;
        }
    }

    private void listWork(String realdir, String dir, String pat, int level, Vector flist) {
        String[] sl;
        File fdir = new File(realdir);
        try {
            sl = fdir.list();
        }
        catch (SecurityException e2) {
            return;
        }
        if (level == 0 && dir != null && match.path(dir, pat, File.separatorChar)) {
            flist.addElement(dir);
        }
        if (sl == null) {
            return;
        }
        if (realdir.charAt(realdir.length() - 1) != File.separatorChar) {
            realdir = realdir + File.separator;
        }
        for (int i = 0; i < sl.length; ++i) {
            String md;
            File mf;
            if (sl[i].charAt(0) == '.' || !(mf = new File(md = realdir + sl[i])).exists()) continue;
            String name = dir != null ? dir + sl[i] : sl[i];
            if (mf.isDirectory()) {
                if (match.path(name, pat, File.separatorChar)) {
                    flist.addElement(name);
                    name = name + File.separator;
                } else if (match.path(name = name + File.separator, pat, File.separatorChar)) {
                    flist.addElement(name);
                }
                if (!match.dir(name, pat, File.separatorChar)) continue;
                this.listWork(md, name, pat, level + 1, flist);
                continue;
            }
            if (!match.path(name, pat, File.separatorChar)) continue;
            flist.addElement(name);
        }
    }
}

