/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Action;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;

public abstract class SequenceNormalizer
extends ProxyReceiver {
    protected int level = 0;
    protected boolean inStartTag = false;
    private List<Action> actionList;
    private boolean failed = false;

    public SequenceNormalizer(Receiver next) {
        super(next);
    }

    @Override
    public void open() throws XPathException {
        this.level = 0;
        this.previousAtomic = false;
        super.open();
        this.getNextReceiver().startDocument(0);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        ++this.level;
        this.previousAtomic = false;
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        this.previousAtomic = false;
    }

    @Override
    public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
        try {
            this.maybeStartContent();
            ++this.level;
            super.startElement(elemName, typeCode, location, properties);
            this.inStartTag = true;
            this.previousAtomic = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void attribute(NodeName name, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            this.failed = true;
            XPathException err = new XPathException("Cannot serialize a free-standing attribute node (" + name + ')', "SENR0001");
            err.setLocation(locationId);
            throw err;
        }
        try {
            super.attribute(name, typeCode, value, locationId, properties);
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.level == 0) {
            this.failed = true;
            throw new XPathException("Cannot serialize a free-standing namespace node", "SENR0001");
        }
        try {
            super.namespace(namespaceBindings, properties);
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void startContent() throws XPathException {
        try {
            super.startContent();
            this.inStartTag = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    private void maybeStartContent() throws XPathException {
        if (this.inStartTag) {
            this.startContent();
        }
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        try {
            this.maybeStartContent();
            super.characters(chars, locationId, properties);
            this.previousAtomic = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        try {
            this.maybeStartContent();
            super.processingInstruction(target, data, locationId, properties);
            this.previousAtomic = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        try {
            this.maybeStartContent();
            super.comment(chars, locationId, properties);
            this.previousAtomic = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void endElement() throws XPathException {
        try {
            this.maybeStartContent();
            --this.level;
            super.endElement();
            this.previousAtomic = false;
        }
        catch (XPathException e2) {
            this.failed = true;
            throw e2;
        }
    }

    @Override
    public void close() throws XPathException {
        if (this.failed) {
            super.close();
        } else {
            this.getNextReceiver().endDocument();
            super.close();
            try {
                if (this.actionList != null) {
                    for (Action action : this.actionList) {
                        action.act();
                    }
                }
            }
            catch (SaxonApiException e2) {
                throw XPathException.makeXPathException(e2);
            }
        }
    }

    public void onClose(List<Action> actionList) {
        this.actionList = actionList;
    }

    public void onClose(Action action) {
        if (this.actionList == null) {
            this.actionList = new ArrayList<Action>();
        }
        this.actionList.add(action);
    }
}

