/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.process.normalize;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.process.normalize.DatatypeHandler;
import org.apache.jena.sparql.graph.NodeConst;
import org.apache.jena.sparql.util.DateTimeStruct;

class NormalizeValue {
    private static DatatypeHandler identity = (node, lexicalForm, datatype) -> node;
    static DatatypeHandler dtBoolean = (node, lexicalForm, datatype) -> {
        if (lexicalForm.equals("1")) {
            return NodeConst.nodeTrue;
        }
        if (lexicalForm.equals("0")) {
            return NodeConst.nodeFalse;
        }
        return node;
    };
    static DatatypeHandler dtAnyDateTime;
    static DatatypeHandler dtDateTime;
    static DatatypeHandler dtInteger;
    static DatatypeHandler dtDecimal;
    private static DecimalFormatSymbols decimalNumberSymbols;
    private static NumberFormat fmtFloatingPoint;
    static DatatypeHandler dtDouble;
    static DatatypeHandler dtFloat;
    static DatatypeHandler dtXSDString;
    static DatatypeHandler dtSimpleLiteral;
    static DatatypeHandler dtLangString;
    static DatatypeHandler dtPlainLiteral;

    NormalizeValue() {
    }

    static {
        dtDateTime = dtAnyDateTime = (node, lexicalForm, datatype) -> {
            int i;
            if (lexicalForm.indexOf(46) < 0) {
                return node;
            }
            DateTimeStruct dts = DateTimeStruct.parseDateTime(lexicalForm);
            int idx = dts.second.indexOf(46);
            for (i = dts.second.length() - 1; i > idx && dts.second.charAt(i) == '0'; --i) {
            }
            if (i == dts.second.length()) {
                return node;
            }
            dts.second = i == idx ? dts.second.substring(0, idx) : dts.second.substring(0, i + 1);
            String lex2 = dts.toString();
            return NodeFactory.createLiteral(lex2, datatype);
        };
        dtInteger = (node, lexicalForm, datatype) -> {
            char[] chars = lexicalForm.toCharArray();
            if (chars.length == 0) {
                return node;
            }
            String lex2 = lexicalForm;
            if (lex2.startsWith("+")) {
                lex2 = lex2.substring(1);
            }
            if (lex2.length() > 8) {
                lex2 = new BigInteger(lexicalForm).toString();
            } else {
                int x = Integer.parseInt(lex2);
                lex2 = Integer.toString(x);
            }
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        };
        dtDecimal = (node, lexicalForm, datatype) -> {
            BigDecimal bd = new BigDecimal(lexicalForm).stripTrailingZeros();
            String lex2 = bd.toPlainString();
            if (lex2.indexOf(46) == -1) {
                lex2 = lex2 + ".0";
            }
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        };
        decimalNumberSymbols = new DecimalFormatSymbols(Locale.ROOT);
        fmtFloatingPoint = new DecimalFormat("0.0#################E0", decimalNumberSymbols);
        dtDouble = (node, lexicalForm, datatype) -> {
            double d = Double.parseDouble(lexicalForm);
            String lex2 = fmtFloatingPoint.format(d);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        };
        dtFloat = (node, lexicalForm, datatype) -> {
            float f = Float.parseFloat(lexicalForm);
            String lex2 = fmtFloatingPoint.format(f);
            if (lex2.equals(lexicalForm)) {
                return node;
            }
            return NodeFactory.createLiteral(lex2, datatype);
        };
        dtXSDString = (node, lexicalForm, datatype) -> NodeFactory.createLiteral(lexicalForm);
        dtSimpleLiteral = (node, lexicalForm, datatype) -> NodeFactory.createLiteral(lexicalForm, datatype);
        dtLangString = identity;
        dtPlainLiteral = (node, lexicalForm, datatype) -> {
            int idx = lexicalForm.lastIndexOf(64);
            if (idx == -1) {
                return node;
            }
            String lex = lexicalForm.substring(0, idx);
            if (idx == lexicalForm.length() - 1) {
                return NodeFactory.createLiteral(lex);
            }
            String lang = lexicalForm.substring(idx + 1);
            return NodeFactory.createLiteral(lex, lang);
        };
    }
}

