/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core.mem;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.DatasetPrefixStorage;
import org.apache.jena.sparql.core.Quad;

public class DatasetPrefixStorageInMemory
implements DatasetPrefixStorage {
    private Map<String, PrefixMapping> prefixMappings = new ConcurrentHashMap<String, PrefixMapping>();

    private Map<String, PrefixMapping> prefixMappings() {
        return this.prefixMappings;
    }

    @Override
    public void close() {
        this.prefixMappings = null;
    }

    @Override
    public void sync() {
    }

    @Override
    public Set<String> graphNames() {
        return this.prefixMappings().keySet();
    }

    @Override
    public String readPrefix(String graphName, String prefix) {
        return this.getPrefixMapping(graphName).getNsPrefixURI(prefix);
    }

    @Override
    public String readByURI(String graphName, String uriStr) {
        return this.getPrefixMapping(graphName).getNsURIPrefix(uriStr);
    }

    @Override
    public Map<String, String> readPrefixMap(String graphName) {
        return this.getPrefixMapping(graphName).getNsPrefixMap();
    }

    @Override
    public void insertPrefix(String graphName, String prefix, String uri) {
        this.getPrefixMapping(graphName).setNsPrefix(prefix, uri);
    }

    @Override
    public void loadPrefixMapping(String graphName, PrefixMapping pmap) {
        this.getPrefixMapping(graphName).setNsPrefixes(pmap);
    }

    @Override
    public void removeFromPrefixMap(String graphName, String prefix) {
        this.getPrefixMapping(graphName).removeNsPrefix(prefix);
    }

    @Override
    public void removeAllFromPrefixMap(String graphName) {
        this.getPrefixMapping(graphName).clearNsPrefixMap();
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.getPrefixMapping(Quad.defaultGraphIRI.getURI());
    }

    @Override
    public PrefixMapping getPrefixMapping(String graphName) {
        return this.prefixMappings().computeIfAbsent(graphName, x -> new PrefixMappingImpl());
    }
}

