/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rule;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class LikeRule
extends AbstractRule {
    static final long serialVersionUID = -3375458885595683156L;
    private static final LoggingEventFieldResolver RESOLVER = LoggingEventFieldResolver.getInstance();
    private transient Pattern pattern;
    private transient Matcher matcher = null;
    private transient String field;

    private LikeRule(String field, Pattern pattern) {
        if (!RESOLVER.isField(field)) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + field + " is not a supported field");
        }
        this.field = field;
        this.pattern = pattern;
    }

    public static Rule getRule(Stack stack) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Invalid LIKE rule - expected two parameters but received " + stack.size());
        }
        String p2 = stack.pop().toString();
        String p1 = stack.pop().toString();
        return LikeRule.getRule(p1, p2);
    }

    public static Rule getRule(String field, String pattern) {
        try {
            return new LikeRule(field, Pattern.compile(pattern, 2));
        }
        catch (PatternSyntaxException e2) {
            throw new IllegalArgumentException("Invalid LIKE rule - " + e2.getMessage());
        }
    }

    public boolean evaluate(LoggingEvent event, Map matches2) {
        Object input = RESOLVER.getValue(this.field, event);
        if (input != null && this.pattern != null) {
            if (this.matcher == null) {
                this.matcher = this.pattern.matcher(input.toString());
            } else {
                this.matcher.reset(input.toString());
            }
            boolean result = this.matcher.matches();
            if (result && matches2 != null) {
                HashSet<Object> entries = (HashSet<Object>)matches2.get(this.field.toUpperCase());
                if (entries == null) {
                    entries = new HashSet<Object>();
                    matches2.put(this.field.toUpperCase(), entries);
                }
                entries.add(input);
            }
            return result;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.field = (String)in.readObject();
            String patternString = (String)in.readObject();
            this.pattern = Pattern.compile(patternString, 2);
        }
        catch (PatternSyntaxException e2) {
            throw new IOException("Invalid LIKE rule - " + e2.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.field);
        out.writeObject(this.pattern.pattern());
    }
}

