/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh.jsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.ssh.AbstractSshWagon;
import org.apache.maven.wagon.providers.ssh.jsch.AbstractJschWagon;
import org.apache.maven.wagon.repository.RepositoryPermissions;
import org.apache.maven.wagon.resource.Resource;

public class SftpWagon
extends AbstractJschWagon {
    private static final String SFTP_CHANNEL = "sftp";
    private static final int S_IFDIR = 16384;
    private static final long MILLIS_PER_SEC = 1000L;

    public void put(String basedir, Resource resource, File source) throws TransferFailedException {
        String resourceName = resource.getName();
        String dir = AbstractSshWagon.getResourceDirectory(resourceName);
        String filename = AbstractSshWagon.getResourceFilename(resourceName);
        ChannelSftp channel = null;
        try {
            channel = (ChannelSftp)this.session.openChannel(SFTP_CHANNEL);
            channel.connect();
            RepositoryPermissions permissions = this.getRepository().getPermissions();
            int directoryMode = this.getDirectoryMode(permissions);
            this.mkdirs(channel, basedir, directoryMode);
            channel.cd(basedir);
            this.mkdirs(channel, resourceName, directoryMode);
            this.firePutStarted(resource, source);
            channel.put(source.getAbsolutePath(), filename);
            this.postProcessListeners(resource, source, 6);
            if (permissions != null && permissions.getGroup() != null) {
                this.setGroup(channel, filename, permissions);
            }
            if (permissions != null && permissions.getFileMode() != null) {
                this.setFileMode(channel, filename, permissions);
            }
            this.firePutCompleted(resource, source);
            String[] dirs = PathUtils.dirnames(dir);
            for (int i = 0; i < dirs.length; ++i) {
                channel.cd("..");
            }
        }
        catch (SftpException e2) {
            String msg = "Error occured while deploying '" + resourceName + "' " + "to remote repository: " + this.getRepository().getUrl();
            throw new TransferFailedException(msg, e2);
        }
        catch (JSchException e3) {
            String msg = "Error occured while deploying '" + resourceName + "' " + "to remote repository: " + this.getRepository().getUrl();
            throw new TransferFailedException(msg, e3);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    private void setGroup(ChannelSftp channel, String filename, RepositoryPermissions permissions) throws SftpException {
        try {
            int group = Integer.valueOf(permissions.getGroup());
            channel.chgrp(group, filename);
        }
        catch (NumberFormatException e2) {
            this.fireTransferDebug("Not setting group: must be a numerical GID for SFTP");
        }
    }

    private void setFileMode(ChannelSftp channel, String filename, RepositoryPermissions permissions) throws SftpException {
        try {
            int mode = this.getOctalMode(permissions.getFileMode());
            channel.chmod(mode, filename);
        }
        catch (NumberFormatException e2) {
            this.fireTransferDebug("Not setting mode: must be a numerical mode for SFTP");
        }
    }

    private void mkdirs(ChannelSftp channel, String resourceName, int mode) throws TransferFailedException, SftpException {
        String[] dirs = PathUtils.dirnames(resourceName);
        for (int i = 0; i < dirs.length; ++i) {
            this.mkdir(channel, dirs[i], mode);
            channel.cd(dirs[i]);
        }
    }

    private void mkdir(ChannelSftp channel, String dir, int mode) throws TransferFailedException, SftpException {
        block5: {
            try {
                SftpATTRS attrs = channel.stat(dir);
                if ((attrs.getPermissions() & 0x4000) == 0) {
                    throw new TransferFailedException("Remote path is not a directory:" + dir);
                }
            }
            catch (SftpException e2) {
                channel.mkdir(dir);
                if (mode == -1) break block5;
                try {
                    channel.chmod(mode, dir);
                }
                catch (SftpException e1) {
                    // empty catch block
                }
            }
        }
    }

    public boolean getIfNewer(Resource resource, File destination, long timestamp) throws ResourceDoesNotExistException, TransferFailedException {
        String filename = AbstractSshWagon.getResourceFilename(resource.getName());
        String dir = AbstractSshWagon.getResourceDirectory(resource.getName());
        if (dir.length() > 0 && dir.charAt(0) == '/') {
            dir = dir.substring(1);
        }
        boolean bDownloaded = true;
        try {
            ChannelSftp channel = (ChannelSftp)this.session.openChannel(SFTP_CHANNEL);
            channel.connect();
            SftpATTRS attrs = this.changeToRepositoryDirectory(channel, dir, filename);
            if (timestamp <= 0L || (long)attrs.getMTime() * 1000L > timestamp) {
                this.fireGetStarted(resource, destination);
                channel.get(filename, destination.getAbsolutePath());
                this.postProcessListeners(resource, destination, 5);
                this.fireGetCompleted(resource, destination);
                String[] dirs = PathUtils.dirnames(dir);
                for (int i = 0; i < dirs.length; ++i) {
                    channel.cd("..");
                }
                bDownloaded = true;
            } else {
                bDownloaded = false;
            }
        }
        catch (SftpException e2) {
            this.handleGetException(resource, e2, destination);
        }
        catch (JSchException e3) {
            this.handleGetException(resource, e3, destination);
        }
        return bDownloaded;
    }

    private SftpATTRS changeToRepositoryDirectory(ChannelSftp channel, String dir, String filename) throws ResourceDoesNotExistException, SftpException {
        SftpATTRS attrs;
        try {
            channel.cd(this.repository.getBasedir());
            if (dir.length() > 0) {
                channel.cd(dir);
            }
            attrs = channel.stat(filename);
        }
        catch (SftpException e2) {
            if (e2.toString().trim().endsWith("No such file")) {
                throw new ResourceDoesNotExistException(e2.toString(), e2);
            }
            throw e2;
        }
        return attrs;
    }

    public void put(File source, String destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String basedir = this.getRepository().getBasedir();
        Resource resource = AbstractSshWagon.getResource(destination);
        this.firePutInitiated(resource, source);
        this.put(basedir, resource, source);
    }

    public void get(String resourceName, File destination) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.getIfNewer(resourceName, destination, 0L);
    }

    public boolean getIfNewer(String resourceName, File destination, long timestamp) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        this.createParentDirectories(destination);
        Resource resource = AbstractSshWagon.getResource(resourceName);
        this.fireGetInitiated(resource, destination);
        return this.getIfNewer(resource, destination, timestamp);
    }
}

