/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.response;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.response.AnalysisResponseBase;
import org.apache.solr.common.util.NamedList;

public class DocumentAnalysisResponse
extends AnalysisResponseBase
implements Iterable<Map.Entry<String, DocumentAnalysis>> {
    private final Map<String, DocumentAnalysis> documentAnalysisByKey = new HashMap<String, DocumentAnalysis>();

    @Override
    public void setResponse(NamedList<Object> response) {
        super.setResponse(response);
        NamedList analysis = (NamedList)response.get("analysis");
        for (Map.Entry document : analysis) {
            DocumentAnalysis documentAnalysis = new DocumentAnalysis(document.getKey());
            for (Map.Entry fieldEntry : (NamedList)document.getValue()) {
                FieldAnalysis fieldAnalysis = new FieldAnalysis(fieldEntry.getKey());
                NamedList field = (NamedList)fieldEntry.getValue();
                NamedList query2 = (NamedList)field.get("query");
                if (query2 != null) {
                    List<AnalysisResponseBase.AnalysisPhase> phases = this.buildPhases(query2);
                    fieldAnalysis.setQueryPhases(phases);
                }
                NamedList index = (NamedList)field.get("index");
                for (Map.Entry valueEntry : index) {
                    String fieldValue = valueEntry.getKey();
                    NamedList valueNL = (NamedList)valueEntry.getValue();
                    List<AnalysisResponseBase.AnalysisPhase> phases = this.buildPhases(valueNL);
                    fieldAnalysis.setIndexPhases(fieldValue, phases);
                }
                documentAnalysis.addFieldAnalysis(fieldAnalysis);
            }
            this.documentAnalysisByKey.put(documentAnalysis.getDocumentKey(), documentAnalysis);
        }
    }

    public int getDocumentAnalysesCount() {
        return this.documentAnalysisByKey.size();
    }

    public DocumentAnalysis getDocumentAnalysis(String documentKey) {
        return this.documentAnalysisByKey.get(documentKey);
    }

    @Override
    public Iterator<Map.Entry<String, DocumentAnalysis>> iterator() {
        return this.documentAnalysisByKey.entrySet().iterator();
    }

    public static class FieldAnalysis {
        private final String fieldName;
        private List<AnalysisResponseBase.AnalysisPhase> queryPhases;
        private Map<String, List<AnalysisResponseBase.AnalysisPhase>> indexPhasesByFieldValue = new HashMap<String, List<AnalysisResponseBase.AnalysisPhase>>();

        private FieldAnalysis(String fieldName) {
            this.fieldName = fieldName;
        }

        public void setQueryPhases(List<AnalysisResponseBase.AnalysisPhase> queryPhases) {
            this.queryPhases = queryPhases;
        }

        public void setIndexPhases(String fieldValue, List<AnalysisResponseBase.AnalysisPhase> indexPhases) {
            this.indexPhasesByFieldValue.put(fieldValue, indexPhases);
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public int getQueryPhasesCount() {
            return this.queryPhases == null ? -1 : this.queryPhases.size();
        }

        public Iterable<AnalysisResponseBase.AnalysisPhase> getQueryPhases() {
            return this.queryPhases;
        }

        public int getValueCount() {
            return this.indexPhasesByFieldValue.entrySet().size();
        }

        public int getIndexPhasesCount(String fieldValue) {
            return this.indexPhasesByFieldValue.get(fieldValue).size();
        }

        public Iterable<AnalysisResponseBase.AnalysisPhase> getIndexPhases(String fieldValue) {
            return this.indexPhasesByFieldValue.get(fieldValue);
        }

        public Iterable<Map.Entry<String, List<AnalysisResponseBase.AnalysisPhase>>> getIndexPhasesByFieldValue() {
            return this.indexPhasesByFieldValue.entrySet();
        }
    }

    public static class DocumentAnalysis
    implements Iterable<Map.Entry<String, FieldAnalysis>> {
        private final String documentKey;
        private Map<String, FieldAnalysis> fieldAnalysisByFieldName = new HashMap<String, FieldAnalysis>();

        private DocumentAnalysis(String documentKey) {
            this.documentKey = documentKey;
        }

        private void addFieldAnalysis(FieldAnalysis fieldAnalysis) {
            this.fieldAnalysisByFieldName.put(fieldAnalysis.getFieldName(), fieldAnalysis);
        }

        public String getDocumentKey() {
            return this.documentKey;
        }

        public int getFieldAnalysesCount() {
            return this.fieldAnalysisByFieldName.size();
        }

        public FieldAnalysis getFieldAnalysis(String fieldName) {
            return this.fieldAnalysisByFieldName.get(fieldName);
        }

        @Override
        public Iterator<Map.Entry<String, FieldAnalysis>> iterator() {
            return this.fieldAnalysisByFieldName.entrySet().iterator();
        }
    }
}

