/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.ECPointMap;
import org.bouncycastle.math.ec.PreCompInfo;
import org.bouncycastle.math.ec.WNafPreCompInfo;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength();
        int[] nArray = new int[n >> 1];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        int n2 = n - 1;
        int n4 = 0;
        int n5 = 0;
        for (int i = 1; i < n2; ++i) {
            if (!bigInteger3.testBit(i)) {
                ++n5;
                continue;
            }
            int n6 = bigInteger.testBit(i) ? -1 : 1;
            nArray[n4++] = n6 << 16 | n5;
            n5 = 1;
            ++i;
        }
        nArray[n4++] = 0x10000 | n5;
        if (nArray.length > n4) {
            nArray = WNafUtil.trim(nArray, n4);
        }
        return nArray;
    }

    public static int[] generateCompactWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n < 2 || n > 16) {
            throw new IllegalArgumentException("'width' must be in the range [2, 16]");
        }
        if (bigInteger.bitLength() >>> 16 != 0) {
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_INTS;
        }
        int[] nArray = new int[bigInteger.bitLength() / n + 1];
        int n2 = 1 << n;
        int n4 = n2 - 1;
        int n5 = n2 >>> 1;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        while (n7 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n7) == bl) {
                ++n7;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n7);
            int n8 = bigInteger.intValue() & n4;
            if (bl) {
                ++n8;
            }
            boolean bl2 = bl = (n8 & n5) != 0;
            if (bl) {
                n8 -= n2;
            }
            int n9 = n6 > 0 ? n7 - 1 : n7;
            nArray[n6++] = n8 << 16 | n9;
            n7 = n;
        }
        if (nArray.length > n6) {
            nArray = WNafUtil.trim(nArray, n6);
        }
        return nArray;
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger;
        BigInteger bigInteger4 = bigInteger2;
        int n2 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n4 | n5 || bigInteger3.bitLength() > n6 || bigInteger4.bitLength() > n6) {
            int n7;
            int n8 = (bigInteger3.intValue() >>> n6) + n4 & 7;
            int n9 = (bigInteger4.intValue() >>> n6) + n5 & 7;
            int n10 = n8 & 1;
            if (n10 != 0 && n8 + (n10 -= n8 & 2) == 4 && (n9 & 3) == 2) {
                n10 = -n10;
            }
            if ((n7 = n9 & 1) != 0 && n9 + (n7 -= n9 & 2) == 4 && (n8 & 3) == 2) {
                n7 = -n7;
            }
            if (n4 << 1 == 1 + n10) {
                n4 ^= 1;
            }
            if (n5 << 1 == 1 + n7) {
                n5 ^= 1;
            }
            if (++n6 == 30) {
                n6 = 0;
                bigInteger3 = bigInteger3.shiftRight(30);
                bigInteger4 = bigInteger4.shiftRight(30);
            }
            byArray[n2++] = (byte)(n10 << 4 | n7 & 0xF);
        }
        if (byArray.length > n2) {
            byArray = WNafUtil.trim(byArray, n2);
        }
        return byArray;
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        for (int i = 1; i < n; ++i) {
            if (!bigInteger3.testBit(i)) continue;
            byArray[i - 1] = (byte)(bigInteger.testBit(i) ? -1 : 1);
            ++i;
        }
        byArray[n - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int n, BigInteger bigInteger) {
        if (n == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n < 2 || n > 8) {
            throw new IllegalArgumentException("'width' must be in the range [2, 8]");
        }
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        byte[] byArray = new byte[bigInteger.bitLength() + 1];
        int n2 = 1 << n;
        int n4 = n2 - 1;
        int n5 = n2 >>> 1;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        while (n7 <= bigInteger.bitLength()) {
            if (bigInteger.testBit(n7) == bl) {
                ++n7;
                continue;
            }
            bigInteger = bigInteger.shiftRight(n7);
            int n8 = bigInteger.intValue() & n4;
            if (bl) {
                ++n8;
            }
            boolean bl2 = bl = (n8 & n5) != 0;
            if (bl) {
                n8 -= n2;
            }
            n6 += n6 > 0 ? n7 - 1 : n7;
            byArray[n6++] = (byte)n8;
            n7 = n;
        }
        if (byArray.length > n6) {
            byArray = WNafUtil.trim(byArray, n6);
        }
        return byArray;
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        return bigInteger3.bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint eCPoint) {
        return WNafUtil.getWNafPreCompInfo(eCPoint.getCurve().getPreCompInfo(eCPoint, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        if (preCompInfo != null && preCompInfo instanceof WNafPreCompInfo) {
            return (WNafPreCompInfo)preCompInfo;
        }
        return new WNafPreCompInfo();
    }

    public static int getWindowSize(int n) {
        return WNafUtil.getWindowSize(n, DEFAULT_WINDOW_SIZE_CUTOFFS);
    }

    public static int getWindowSize(int n, int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length && n >= nArray[n2]; ++n2) {
        }
        return n2 + 2;
    }

    public static ECPoint mapPointWithPrecomp(ECPoint eCPoint, int n, boolean bl, ECPointMap eCPointMap) {
        Object object;
        ECCurve eCCurve = eCPoint.getCurve();
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.precompute(eCPoint, n, bl);
        ECPoint eCPoint2 = eCPointMap.map(eCPoint);
        WNafPreCompInfo wNafPreCompInfo2 = WNafUtil.getWNafPreCompInfo(eCCurve.getPreCompInfo(eCPoint2, PRECOMP_NAME));
        ECPoint eCPoint3 = wNafPreCompInfo.getTwice();
        if (eCPoint3 != null) {
            object = eCPointMap.map(eCPoint3);
            wNafPreCompInfo2.setTwice((ECPoint)object);
        }
        object = wNafPreCompInfo.getPreComp();
        ECPoint[] eCPointArray = new ECPoint[((ECPoint[])object).length];
        for (int i = 0; i < ((ECPoint[])object).length; ++i) {
            eCPointArray[i] = eCPointMap.map(object[i]);
        }
        wNafPreCompInfo2.setPreComp(eCPointArray);
        if (bl) {
            ECPoint[] eCPointArray2 = new ECPoint[eCPointArray.length];
            for (int i = 0; i < eCPointArray2.length; ++i) {
                eCPointArray2[i] = eCPointArray[i].negate();
            }
            wNafPreCompInfo2.setPreCompNeg(eCPointArray2);
        }
        eCCurve.setPreCompInfo(eCPoint2, PRECOMP_NAME, wNafPreCompInfo2);
        return eCPoint2;
    }

    public static WNafPreCompInfo precompute(ECPoint eCPoint, int n, boolean bl) {
        ECCurve eCCurve = eCPoint.getCurve();
        WNafPreCompInfo wNafPreCompInfo = WNafUtil.getWNafPreCompInfo(eCCurve.getPreCompInfo(eCPoint, PRECOMP_NAME));
        int n2 = 0;
        int n4 = 1 << Math.max(0, n - 2);
        ECPoint[] eCPointArray = wNafPreCompInfo.getPreComp();
        if (eCPointArray == null) {
            eCPointArray = EMPTY_POINTS;
        } else {
            n2 = eCPointArray.length;
        }
        if (n2 < n4) {
            eCPointArray = WNafUtil.resizeTable(eCPointArray, n4);
            if (n4 == 1) {
                eCPointArray[0] = eCPoint.normalize();
            } else {
                int n5 = n2;
                if (n5 == 0) {
                    eCPointArray[0] = eCPoint;
                    n5 = 1;
                }
                ECFieldElement eCFieldElement = null;
                if (n4 == 2) {
                    eCPointArray[1] = eCPoint.threeTimes();
                } else {
                    ECPoint eCPoint2 = wNafPreCompInfo.getTwice();
                    ECPoint eCPoint3 = eCPointArray[n5 - 1];
                    if (eCPoint2 == null) {
                        eCPoint2 = eCPointArray[0].twice();
                        wNafPreCompInfo.setTwice(eCPoint2);
                        if (ECAlgorithms.isFpCurve(eCCurve) && eCCurve.getFieldSize() >= 64) {
                            switch (eCCurve.getCoordinateSystem()) {
                                case 2: 
                                case 3: 
                                case 4: {
                                    eCFieldElement = eCPoint2.getZCoord(0);
                                    eCPoint2 = eCCurve.createPoint(eCPoint2.getXCoord().toBigInteger(), eCPoint2.getYCoord().toBigInteger());
                                    ECFieldElement eCFieldElement2 = eCFieldElement.square();
                                    ECFieldElement eCFieldElement3 = eCFieldElement2.multiply(eCFieldElement);
                                    eCPoint3 = eCPoint3.scaleX(eCFieldElement2).scaleY(eCFieldElement3);
                                    if (n2 != 0) break;
                                    eCPointArray[0] = eCPoint3;
                                    break;
                                }
                            }
                        }
                    }
                    while (n5 < n4) {
                        eCPointArray[n5++] = eCPoint3 = eCPoint3.add(eCPoint2);
                    }
                }
                eCCurve.normalizeAll(eCPointArray, n2, n4 - n2, eCFieldElement);
            }
        }
        wNafPreCompInfo.setPreComp(eCPointArray);
        if (bl) {
            int n6;
            ECPoint[] eCPointArray2 = wNafPreCompInfo.getPreCompNeg();
            if (eCPointArray2 == null) {
                n6 = 0;
                eCPointArray2 = new ECPoint[n4];
            } else {
                n6 = eCPointArray2.length;
                if (n6 < n4) {
                    eCPointArray2 = WNafUtil.resizeTable(eCPointArray2, n4);
                }
            }
            while (n6 < n4) {
                eCPointArray2[n6] = eCPointArray[n6].negate();
                ++n6;
            }
            wNafPreCompInfo.setPreCompNeg(eCPointArray2);
        }
        eCCurve.setPreCompInfo(eCPoint, PRECOMP_NAME, wNafPreCompInfo);
        return wNafPreCompInfo;
    }

    private static byte[] trim(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
        return nArray2;
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n) {
        ECPoint[] eCPointArray2 = new ECPoint[n];
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, eCPointArray.length);
        return eCPointArray2;
    }
}

