/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.javac;

import [Ljava.lang.String;;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.javac.IsolatedClassLoader;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class JavacCompiler
extends AbstractCompiler {
    private static final String WARNING_PREFIX = "warning: ";

    public JavacCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        List messages;
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = JavacCompiler.getSourceFiles(config)) == null || sourceFiles.length == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args = JavacCompiler.buildCompilerArguments(config, sourceFiles);
        if (config.isFork()) {
            String executable = config.getExecutable();
            if (StringUtils.isEmpty(executable)) {
                try {
                    executable = JavacCompiler.getJavacExecutable();
                }
                catch (IOException e2) {
                    this.getLogger().warn("Unable to autodetect 'javac' path, using 'javac' from the environment.");
                    executable = "javac";
                }
            }
            messages = this.compileOutOfProcess(config, executable, args);
        } else {
            messages = this.compileInProcess(args);
        }
        return messages;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return JavacCompiler.buildCompilerArguments(config, JavacCompiler.getSourceFiles(config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(JavacCompiler.getPathString(classpathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(JavacCompiler.getPathString(sourceLocations));
        }
        args.addAll(Arrays.asList(sourceFiles));
        if (!JavacCompiler.isPreJava16(config)) {
            if (config.getGeneratedSourcesDirectory() != null) {
                config.getGeneratedSourcesDirectory().mkdirs();
                args.add("-s");
                args.add(config.getGeneratedSourcesDirectory().getAbsolutePath());
            }
            if (config.getProc() != null) {
                args.add("-proc:" + config.getProc());
            }
            if (config.getAnnotationProcessors() != null) {
                args.add("-processor");
                String[] procs = config.getAnnotationProcessors();
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < procs.length; ++i) {
                    if (i > 0) {
                        buffer.append(",");
                    }
                    buffer.append(procs[i]);
                }
                args.add(buffer.toString());
            }
        }
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty(config.getDebugLevel())) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (StringUtils.isEmpty(config.getTargetVersion())) {
            args.add("-target");
            args.add("1.1");
        } else {
            args.add("-target");
            args.add(config.getTargetVersion());
        }
        if (!JavacCompiler.suppressSource(config) && StringUtils.isEmpty(config.getSourceVersion())) {
            args.add("-source");
            args.add("1.3");
        } else if (!JavacCompiler.suppressSource(config)) {
            args.add("-source");
            args.add(config.getSourceVersion());
        }
        if (!JavacCompiler.suppressEncoding(config) && !StringUtils.isEmpty(config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        Iterator it = config.getCustomCompilerArguments().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty(key)) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty(value)) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    private static boolean isPreJava14(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            return false;
        }
        return v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean isPreJava16(CompilerConfiguration config) {
        String v = config.getCompilerVersion();
        if (v == null) {
            String s = config.getSourceVersion();
            if (s == null) {
                return true;
            }
            return s.startsWith("1.5") || s.startsWith("1.4") || s.startsWith("1.3") || s.startsWith("1.2") || s.startsWith("1.1") || s.startsWith("1.0");
        }
        return v.startsWith("1.5") || v.startsWith("1.4") || v.startsWith("1.3") || v.startsWith("1.2") || v.startsWith("1.1") || v.startsWith("1.0");
    }

    private static boolean suppressSource(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    private static boolean suppressEncoding(CompilerConfiguration config) {
        return JavacCompiler.isPreJava14(config);
    }

    List compileOutOfProcess(CompilerConfiguration config, String executable, String[] args) throws CompilerException {
        List messages;
        int returnCode;
        CommandLineUtils.StringStreamConsumer err;
        CommandLineUtils.StringStreamConsumer out;
        Commandline cli;
        block13: {
            cli = new Commandline();
            cli.setWorkingDirectory(config.getWorkingDirectory().getAbsolutePath());
            cli.setExecutable(executable);
            try {
                File argumentsFile = this.createFileWithArguments(args, config.getOutputLocation());
                cli.addArguments(new String[]{"@" + argumentsFile.getCanonicalPath().replace(File.separatorChar, '/')});
                if (!StringUtils.isEmpty(config.getMaxmem())) {
                    cli.addArguments(new String[]{"-J-Xmx" + config.getMaxmem()});
                }
                if (!StringUtils.isEmpty(config.getMeminitial())) {
                    cli.addArguments(new String[]{"-J-Xms" + config.getMeminitial()});
                }
            }
            catch (IOException e2) {
                throw new CompilerException("Error creating file with javac arguments", e2);
            }
            out = new CommandLineUtils.StringStreamConsumer();
            err = new CommandLineUtils.StringStreamConsumer();
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                File commandLineFile = new File(config.getOutputLocation(), "javac." + (Os.isFamily("windows") ? "bat" : "sh"));
                try {
                    FileUtils.fileWrite(commandLineFile.getAbsolutePath(), cli.toString().replaceAll("'", ""));
                    if (!Os.isFamily("windows")) {
                        Runtime.getRuntime().exec(new String[]{"chmod", "a+x", commandLineFile.getAbsolutePath()});
                    }
                }
                catch (IOException e3) {
                    if (this.getLogger() == null || !this.getLogger().isWarnEnabled()) break block13;
                    this.getLogger().warn("Unable to write '" + commandLineFile.getName() + "' debug script file", e3);
                }
            }
        }
        try {
            returnCode = CommandLineUtils.executeCommandLine(cli, out, err);
            messages = JavacCompiler.parseModernStream(new BufferedReader(new StringReader(err.getOutput())));
        }
        catch (CommandLineException e4) {
            throw new CompilerException("Error while executing the external compiler.", e4);
        }
        catch (IOException e5) {
            throw new CompilerException("Error while executing the external compiler.", e5);
        }
        if (returnCode != 0 && messages.isEmpty()) {
            if (err.getOutput().length() == 0) {
                throw new CompilerException("Unknown error trying to execute the external compiler: " + EOL + cli.toString());
            }
            messages.add(new CompilerError("Failure executing javac,  but could not parse the error:" + EOL + err.getOutput(), true));
        }
        return messages;
    }

    List compileInProcess(String[] args) throws CompilerException {
        List messages;
        Integer ok;
        Class c;
        IsolatedClassLoader cl = new IsolatedClassLoader();
        File toolsJar = new File(System.getProperty("java.home"), "../lib/tools.jar");
        if (toolsJar.exists()) {
            try {
                cl.addURL(toolsJar.toURI().toURL());
            }
            catch (MalformedURLException e2) {
                throw new CompilerException("Could not convert the file reference to tools.jar to a URL, path to tools.jar: '" + toolsJar.getAbsolutePath() + "'.");
            }
        }
        try {
            c = cl.loadClass("com.sun.tools.javac.Main");
        }
        catch (ClassNotFoundException e3) {
            String message = "Unable to locate the Javac Compiler in:" + EOL + "  " + toolsJar + EOL + "Please ensure you are using JDK 1.4 or above and" + EOL + "not a JRE (the com.sun.tools.javac.Main class is required)." + EOL + "In most cases you can change the location of your Java" + EOL + "installation by setting the JAVA_HOME environment variable.";
            return Collections.singletonList(new CompilerError(message, true));
        }
        StringWriter out = new StringWriter();
        try {
            Method compile = c.getMethod("compile", String;.class, PrintWriter.class);
            ok = (Integer)compile.invoke(null, args, new PrintWriter(out));
            messages = JavacCompiler.parseModernStream(new BufferedReader(new StringReader(out.toString())));
        }
        catch (NoSuchMethodException e4) {
            throw new CompilerException("Error while executing the compiler.", e4);
        }
        catch (IllegalAccessException e5) {
            throw new CompilerException("Error while executing the compiler.", e5);
        }
        catch (InvocationTargetException e6) {
            throw new CompilerException("Error while executing the compiler.", e6);
        }
        catch (IOException e7) {
            throw new CompilerException("Error while executing the compiler.", e7);
        }
        if (ok != 0 && messages.isEmpty()) {
            messages.add(new CompilerError("Failure executing javac, but could not parse the error:" + EOL + out.toString(), true));
        }
        return messages;
    }

    protected static List parseModernStream(BufferedReader input) throws IOException {
        ArrayList<CompilerError> errors = new ArrayList<CompilerError>();
        while (true) {
            String line;
            StringBuffer buffer = new StringBuffer();
            do {
                if ((line = input.readLine()) == null) {
                    return errors;
                }
                if (buffer.length() == 0 && line.startsWith("error: ")) {
                    errors.add(new CompilerError(line, true));
                    continue;
                }
                if (buffer.length() == 0 && line.startsWith("Note: ")) continue;
                buffer.append(line);
                buffer.append(EOL);
            } while (!line.endsWith("^"));
            errors.add(JavacCompiler.parseModernError(buffer.toString()));
        }
    }

    public static CompilerError parseModernError(String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = true;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            String previousToken = null;
            String currentToken = null;
            do {
                previousToken = currentToken;
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e2) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String file = previousToken;
            String lineIndicator = currentToken;
            int startOfFileName = previousToken.lastIndexOf("]");
            if (startOfFileName > -1) {
                file = file.substring(startOfFileName + 2);
            }
            if (file.length() == 1) {
                file = file + ":" + tokens.nextToken();
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuffer msgBuffer = new StringBuffer();
            String msg = tokens.nextToken(EOL).substring(2);
            boolean bl = isError = !msg.startsWith(WARNING_PREFIX);
            if (!isError) {
                msg = msg.substring(WARNING_PREFIX.length());
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = tokens.nextToken(EOL);
            if (tokens.hasMoreTokens()) {
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                msgBuffer.append(pointer);
                msgBuffer.append(EOL);
                context = tokens.nextToken(EOL);
                try {
                    pointer = tokens.nextToken(EOL);
                }
                catch (NoSuchElementException e3) {
                    pointer = context;
                    context = null;
                }
            }
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerError(file, isError, line, startcolumn, line, endcolumn, message);
        }
        catch (NoSuchElementException e4) {
            return new CompilerError("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e5) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
        catch (Exception e6) {
            return new CompilerError("could not parse error message: " + error, isError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        PrintWriter writer = null;
        try {
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(JavacCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily("windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName("AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName("Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty(javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }
}

