/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.configuration.processor;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.codehaus.plexus.component.repository.io.PlexusTools;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.configuration.processor.AbstractConfigurationResourceHandler;
import org.codehaus.plexus.configuration.processor.ConfigurationProcessingException;
import org.codehaus.plexus.configuration.processor.ConfigurationResourceNotFoundException;
import org.codehaus.plexus.util.IOUtil;

public class FileConfigurationResourceHandler
extends AbstractConfigurationResourceHandler {
    public String getId() {
        return "file-configuration-resource";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PlexusConfiguration[] handleRequest(Map parameters) throws ConfigurationResourceNotFoundException, ConfigurationProcessingException {
        PlexusConfiguration[] plexusConfigurationArray;
        File f = new File(this.getSource(parameters));
        if (!f.exists()) {
            throw new ConfigurationResourceNotFoundException("The specified resource " + f + " cannot be found.");
        }
        FileReader configurationReader = null;
        try {
            configurationReader = new FileReader(f);
            plexusConfigurationArray = new PlexusConfiguration[]{PlexusTools.buildConfiguration(f.getAbsolutePath(), configurationReader)};
        }
        catch (PlexusConfigurationException e2) {
            try {
                throw new ConfigurationProcessingException(e2);
                catch (FileNotFoundException e3) {
                    throw new ConfigurationProcessingException(e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(configurationReader);
                throw throwable;
            }
        }
        IOUtil.close(configurationReader);
        return plexusConfigurationArray;
    }
}

