/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.processor;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.processor.IndexTaskProcessingStrategy;
import org.dataone.cn.index.task.IndexTask;
import org.dataone.cn.index.task.IndexTaskRepository;
import org.dataone.cn.index.task.ResourceMapIndexTask;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.XmlDocumentUtility;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.resourcemap.ForesiteResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMap;
import org.dataone.cn.indexer.resourcemap.ResourceMapFactory;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.TypeFactory;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.dspace.foresite.OREParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.w3c.dom.Document;

public class IndexTaskProcessor {
    private static Logger logger = Logger.getLogger(IndexTaskProcessor.class.getName());
    private static final String FORMAT_TYPE_DATA = "DATA";
    private static final String LOAD_LOGGER_NAME = "indexProcessorLoad";
    private static final String THREADPOOL_SIZE_PROPERTY = "dataone.indexing.multiThreads.processThreadPoolSize";
    private static final int DEFAULT_THREADPOOL_SIZE = 5;
    private static final int DEFAULT_MAX_TRYCOUNT = 8;
    private static final int DEFAULT_MAXATTEMPTS = 10;
    private static int numProcessors = Settings.getConfiguration().getInt("dataone.indexing.multiThreads.processThreadPoolSize", 5);
    private static ExecutorService executor = Executors.newFixedThreadPool(numProcessors);
    private int maxAttempts = Settings.getConfiguration().getInt("dataone.indexing.multiThreads.resourceMapWait.maxAttempt", 10);
    private static final boolean CHECKING_ORE_READINESS = Settings.getConfiguration().getBoolean("dataone.indexing.multiThreads.checkOreReadiness", false);
    private static final boolean DO_PRECHECKS_IN_MAIN_THREAD = Settings.getConfiguration().getBoolean("dataone.indexing.multiThreads.taskPreCheckInMainThread", false);
    private static final boolean DELETE_OBSOLETED_AND_ARCHIVED = Settings.getConfiguration().getBoolean("dataone.indexing.multiThreads.deleteObsoletedAndArchived", true);
    private static final boolean MARKING_IN_PROCESS = Settings.getConfiguration().getBoolean("dataone.indexing.multiThreads.markingInProcess", false);
    private static final Lock LOCK = new ReentrantLock();
    private static Map<Future<Void>, IndexTask> futureMap = new HashMap<Future<Void>, IndexTask>();
    private static List<Future<Void>> futureQueue = new LinkedList<Future<Void>>();
    private static Set<IndexTask> preSubmittedTasks = new HashSet<IndexTask>();
    private static boolean inShutdownMode = false;
    private static ConcurrentHashMap<String, String> referencedIdsMap = new ConcurrentHashMap();
    private static ConcurrentSkipListSet<String> seriesIdsSet = new ConcurrentSkipListSet();
    @Autowired
    private IndexTaskRepository repo;
    @Autowired
    private IndexTaskProcessingStrategy deleteProcessor;
    @Autowired
    private IndexTaskProcessingStrategy updateProcessor;
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient;
    @Autowired
    private String solrQueryUri;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private static int maxTryCount = 8;

    public IndexTaskProcessor() {
        logger.warn("IndexTaskProcessor initialized with stated number of threads = " + numProcessors);
    }

    public void processIndexTaskQueue() {
        this.logProcessorLoad();
        List<IndexTask> queue = this.getIndexTaskQueue();
        IndexTask task = this.getNextIndexTask(queue);
        while (task != null) {
            this.processTaskOnThread(task);
            task = this.getNextIndexTask(queue);
        }
        this.processFailedIndexTaskQueue();
    }

    public void processIndexTaskQueue(List<IndexTask> queue) {
        IndexTask task = null;
        if (queue != null) {
            int size = queue.size();
            task = this.getNextIndexTask(queue);
            while (task != null) {
                this.processTaskOnThread(task);
                task = this.getNextIndexTask(queue);
            }
            logger.info("IndexTaskProcessor.processIndexTaskQueue - finish submitting the index task queue with the size " + size + " and current queue size is down to " + queue.size());
        }
    }

    public void processFailedIndexTaskQueue() {
        List<IndexTask> retryQueue = this.getIndexTaskRetryQueue();
        if (retryQueue != null) {
            IndexTask task = this.getNextIndexTask(retryQueue);
            logger.info("IndexTaskProcessor.processFailedIndexTaskQueue with size " + retryQueue.size());
            while (task != null) {
                this.processTaskOnThread(task);
                task = this.getNextIndexTask(retryQueue);
            }
        }
    }

    private void logProcessorLoad() {
        Logger loadLogger = Logger.getLogger(LOAD_LOGGER_NAME);
        try {
            Long newTasks = this.repo.countByStatus("NEW");
            Long failedTasks = this.repo.countByStatus("FAILED");
            loadLogger.info("new tasks:" + newTasks + ", tasks previously failed: " + failedTasks);
        }
        catch (Exception e2) {
            logger.error("Unable to count NEW or FAILED tasks in task index repository.", e2);
        }
    }

    private void processTaskOnThread(final IndexTask task) {
        logger.info("using multiple threads to process index and the size of the thread pool is " + numProcessors);
        Runnable newThreadTask = new Runnable(){

            @Override
            public void run() {
                IndexTaskProcessor.this.processTask(task);
            }
        };
        Future<?> future = this.getExecutorService().submit(newThreadTask);
        preSubmittedTasks.remove(task);
        futureQueue.add(future);
        futureMap.put(future, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTask(IndexTask task) {
        if (task == null) {
            logger.debug("got sent a null task...ignoring");
            return;
        }
        long start = System.currentTimeMillis();
        try {
            if (CHECKING_ORE_READINESS) {
                this.checkReadinessProcessResourceMap(task);
            }
            if (DELETE_OBSOLETED_AND_ARCHIVED && task.isDeleteTask()) {
                logger.info("+++++++++++++start to process delete index task for " + task.getPid() + " in thread " + Thread.currentThread().getId());
                this.deleteProcessor.process(task);
                logger.info("+++++++++++++end to process delete index task for " + task.getPid() + " in thread " + Thread.currentThread().getId());
            } else {
                if (!DO_PRECHECKS_IN_MAIN_THREAD && (task = this.doTaskPreChecks(task)) == null) {
                    return;
                }
                logger.info("*********************start to process update index task for " + task.getPid() + " in thread " + Thread.currentThread().getId());
                this.updateProcessor.process(task);
                logger.info("*********************end to process update index task for " + task.getPid() + " in thread " + Thread.currentThread().getId());
            }
        }
        catch (InterruptedException interruptedE) {
            logger.warn("Task Interrupted before processing started. Resetting to NEW, for pid: " + task.getPid());
            task.markNew();
            this.repo.save(task);
        }
        catch (Exception e2) {
            logger.error("Unable to process task for pid: " + task.getPid(), e2);
            this.repo.delete(task.getId());
            this.handleFailedTask(task);
            return;
        }
        finally {
            this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
        }
        this.repo.delete(task.getId());
        logger.info("Indexing complete for pid: " + task.getPid());
        if (this.perfLog.isLogEnabled()) {
            this.perfLog.log("IndexTaskProcessor.processTasks process pid " + task.getPid(), System.currentTimeMillis() - start);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkReadinessProcessResourceMap(IndexTask task) throws InterruptedException, Exception {
        Identifier sid;
        if (task == null) {
            return;
        }
        long startTiming = System.currentTimeMillis();
        if (task != null && task instanceof ResourceMapIndexTask) {
            if (logger.isDebugEnabled()) {
                logger.debug("$$$$$$$$$$$$$$$$$ the index task " + task.getPid() + " is a resource map task in the the thread " + Thread.currentThread().getId());
            }
            LOCK.lock();
            try {
                ResourceMapIndexTask resourceMapTask;
                List<String> referencedIds;
                if (this.perfLog.isLogEnabled()) {
                    this.perfLog.log("IndexTaskProcessor.checkReadiness/resMap/lock " + task.getPid(), System.currentTimeMillis() - startTiming);
                }
                if ((referencedIds = (resourceMapTask = (ResourceMapIndexTask)task).getReferencedIds()) == null) return;
                for (String id : referencedIds) {
                    int i;
                    if (SeriesIdResolver.isSeriesId(TypeFactory.buildIdentifier(id))) {
                        boolean isClear = false;
                        for (i = 0; i < this.maxAttempts; ++i) {
                            if (!seriesIdsSet.contains(id)) {
                                isClear = true;
                                seriesIdsSet.add(id);
                                break;
                            }
                            System.out.println("###################Another index task is process the object with series id " + id + " as well. So the thread to process id " + task.getPid() + " has to wait 0.5 seconds.");
                            Thread.sleep(500L);
                        }
                        if (!isClear) {
                            this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
                            String message = "We waited for another thread to finish indexing a pid with series id " + id + " for a while. Now we quit and can't index id " + task.getPid();
                            logger.error(message);
                            throw new Exception(message);
                        }
                    }
                    boolean clear = false;
                    for (i = 0; i < this.maxAttempts; ++i) {
                        if (id != null && !id.trim().equals("") && referencedIdsMap.containsKey(id)) {
                            if (resourceMapTask.getPid().equals(referencedIdsMap.get(id))) {
                                clear = true;
                                break;
                            }
                            logger.info("###################Another resource map is process the referenced id " + id + " as well. So the thread to process id " + resourceMapTask.getPid() + " has to wait 0.5 seconds.");
                            Thread.sleep(500L);
                            continue;
                        }
                        if (id == null || id.trim().equals("") || referencedIdsMap.containsKey(id)) continue;
                        referencedIdsMap.put(id, resourceMapTask.getPid());
                        clear = true;
                        break;
                    }
                    if (clear) continue;
                    this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(resourceMapTask);
                    String message = "We waited for another thread to finish indexing a resource map which has the referenced id " + id + " for a while. Now we quited and can't index id " + resourceMapTask.getPid();
                    logger.error(message);
                    throw new Exception(message);
                }
                return;
            }
            catch (Exception e2) {
                throw e2;
            }
            finally {
                LOCK.unlock();
                if (this.perfLog.isLogEnabled()) {
                    this.perfLog.log("IndexTaskProcessor.checkReadiness/resMap process pid " + task.getPid(), System.currentTimeMillis() - startTiming);
                }
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("xxxxxxxxxxxxxxxxxxxx the index task " + task.getPid() + " is NOT a resource map task in the the thread " + Thread.currentThread().getId());
        }
        Identifier pid = new Identifier();
        pid.setValue(task.getPid());
        SystemMetadata smd = HazelcastClientFactory.getSystemMetadataMap().get(pid);
        if (smd != null && (sid = smd.getSeriesId()) != null && sid.getValue() != null && !sid.getValue().trim().equals("")) {
            LOCK.lock();
            long lockStart = System.currentTimeMillis();
            try {
                if (this.perfLog.isLogEnabled()) {
                    this.perfLog.log("IndexTaskProcessor.checkReadiness/other/lock " + task.getPid(), System.currentTimeMillis() - lockStart);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("xxxxxxxxxxxxxxxxxxxx the index task " + task.getPid() + " has a sid " + sid.getValue() + " in the the thread " + Thread.currentThread().getId());
                }
                boolean clear = false;
                for (int i = 0; i < this.maxAttempts; ++i) {
                    if (seriesIdsSet.contains(sid.getValue())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("###################Another index task is process the object with series id " + sid.getValue() + " as well. So the thread to process id " + task.getPid() + " has to wait 0.5 seconds.");
                        }
                    } else {
                        clear = true;
                        seriesIdsSet.add(sid.getValue());
                        break;
                    }
                    Thread.sleep(500L);
                }
                if (!clear) {
                    this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
                    String message = "We waited for another thread to finish indexing a pid with series id " + sid.getValue() + " for a while. Now we quited and can't index id " + task.getPid();
                    logger.error(message);
                    throw new Exception(message);
                }
            }
            catch (Exception e3) {
                if (!this.perfLog.isLogEnabled()) throw e3;
                this.perfLog.log("IndexTaskProcessor.checkReadiness/other/execption process pid " + task.getPid(), System.currentTimeMillis() - startTiming);
                throw e3;
            }
            finally {
                LOCK.unlock();
            }
        }
        if (!this.perfLog.isLogEnabled()) return;
        this.perfLog.log("IndexTaskProcessor.checkReadiness/other process pid " + task.getPid(), System.currentTimeMillis() - startTiming);
    }

    private void removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(IndexTask task) {
        if (task != null && task instanceof ResourceMapIndexTask) {
            ResourceMapIndexTask resourceMapTask = (ResourceMapIndexTask)task;
            List<String> referencedIds = resourceMapTask.getReferencedIds();
            if (referencedIds != null) {
                for (String id : referencedIds) {
                    if (id == null) continue;
                    referencedIdsMap.remove(id);
                    seriesIdsSet.remove(id);
                }
            }
        } else {
            Identifier id = new Identifier();
            id.setValue(task.getPid());
            SystemMetadata smd = HazelcastClientFactory.getSystemMetadataMap().get(id);
            logger.debug("remove the series id (if it has) for +++++ " + task.getPid());
            if (smd != null && smd.getSeriesId() != null && smd.getSeriesId().getValue() != null) {
                logger.debug("remove the series id " + smd.getSeriesId().getValue() + " for +++++ " + task.getPid());
                seriesIdsSet.remove(smd.getSeriesId().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void batchCheckReadinessProcessResourceMap(List<IndexTask> tasks) throws Exception {
        LOCK.lock();
        try {
            if (tasks != null) {
                for (IndexTask task : tasks) {
                    this.checkReadinessProcessResourceMap(task);
                }
            }
        }
        finally {
            LOCK.unlock();
        }
    }

    private void batchRemoveIdsFromResourceMapReferencedSet(List<IndexTask> tasks) {
        if (tasks != null) {
            for (IndexTask task : tasks) {
                this.removeIdsFromResourceMapReferencedSetAndSeriesIdsSet(task);
            }
        }
    }

    private void handleFailedTasks(List<IndexTask> tasks) {
        for (IndexTask task : tasks) {
            task.markFailed();
            this.saveTaskWithoutDuplication(task);
        }
    }

    private void handleFailedTask(IndexTask task) {
        if (task != null) {
            task.markFailed();
            this.saveTaskWithoutDuplication(task);
        }
    }

    private IndexTask getNextIndexTask(List<IndexTask> queue) {
        IndexTask task = null;
        while (task == null && !queue.isEmpty() && !inShutdownMode) {
            task = queue.remove(0);
            if (task == null || !DO_PRECHECKS_IN_MAIN_THREAD) continue;
            task = this.doTaskPreChecks(task);
        }
        return task;
    }

    private IndexTask doTaskPreChecks(IndexTask task) {
        if (MARKING_IN_PROCESS) {
            task.markInProgress();
            task = this.saveTask(task);
        }
        preSubmittedTasks.add(task);
        if (task == null) {
            return null;
        }
        logger.info("Start of indexing pid: " + task.getPid());
        if (DELETE_OBSOLETED_AND_ARCHIVED) {
            try {
                if (task.isDeleteTask()) {
                    return task;
                }
            }
            catch (MarshallingException e2) {
                task.markFailed();
                this.saveTaskWithoutDuplication(task);
                logger.error(e2.getMessage(), e2);
                return null;
            }
        }
        if (!this.isObjectPathReady(task)) {
            if (MARKING_IN_PROCESS) {
                task.markNew();
                this.saveTaskWithoutDuplication(task);
            }
            logger.info("Task for pid: " + task.getPid() + " not processed since the object path is not ready.");
            return null;
        }
        if (CHECKING_ORE_READINESS && this.representsResourceMap(task)) {
            boolean ready = true;
            ResourceMap rm = null;
            List<String> referencedIds = null;
            try {
                rm = ResourceMapFactory.buildResourceMap(task.getObjectPath());
                referencedIds = rm.getAllDocumentIDs();
                boolean found = referencedIds.remove(task.getPid());
                while (found) {
                    found = referencedIds.remove(task.getPid());
                }
                SystemMetadata resMapSMD = HazelcastClientFactory.getSystemMetadataMap().get(TypeFactory.buildIdentifier(task.getPid()));
                if (resMapSMD.getSeriesId() != null) {
                    found = referencedIds.remove(resMapSMD.getSeriesId().getValue());
                    while (found) {
                        found = referencedIds.remove(resMapSMD.getSeriesId().getValue());
                    }
                }
                if (!this.areAllReferencedDocsIndexed(referencedIds)) {
                    logger.info("****************Not all map resource references indexed for map: " + task.getPid() + ".  Marking new and continuing...");
                    ready = false;
                }
            }
            catch (OREParserException oreException) {
                ready = false;
                Throwable cause = oreException.getCause();
                logger.error("Unable to parse ORE doc: " + task.getPid() + ".  Unrecoverable parse error: task will not be re-tried.  Cause:: " + cause.getClass().getSimpleName() + ": " + cause.getMessage());
                if (logger.isTraceEnabled()) {
                    oreException.printStackTrace();
                }
            }
            catch (Exception e3) {
                ready = false;
                logger.error("unable to load resource for pid: " + task.getPid() + " at object path: " + task.getObjectPath() + ".  Marking new and continuing...  Cause:: " + e3.getClass().getSimpleName() + ": " + e3.getMessage());
            }
            if (!ready) {
                task.markNew();
                this.saveTaskWithoutDuplication(task);
                logger.info("Task for resource map pid: " + task.getPid() + " not processed.");
                return null;
            }
            logger.info("the original index task - " + task.toString());
            ResourceMapIndexTask resourceMapIndexTask = new ResourceMapIndexTask();
            resourceMapIndexTask.copy(task);
            resourceMapIndexTask.setReferencedIds(referencedIds);
            task = resourceMapIndexTask;
            if (task instanceof ResourceMapIndexTask) {
                logger.info("the new index task is a ResourceMapIndexTask");
                logger.info("the new index task - " + task.toString());
            } else {
                logger.error("Something is wrong to change the IndexTask object to the ResourceMapIndexTask object ");
            }
        }
        return task;
    }

    private boolean areAllReferencedDocsIndexed(List<String> referencedIds) {
        if (referencedIds == null || referencedIds.size() == 0) {
            return true;
        }
        List<SolrDoc> updateDocuments = null;
        int numberOfIndexedOrRemovedReferences = 0;
        try {
            updateDocuments = this.d1IndexerSolrClient.getDocumentsByD1Identifier(this.solrQueryUri, referencedIds);
            numberOfIndexedOrRemovedReferences = 0;
            for (String id : referencedIds) {
                boolean foundId = false;
                for (SolrDoc solrDoc : updateDocuments) {
                    if (!solrDoc.getIdentifier().equals(id) && !id.equals(solrDoc.getSeriesId())) continue;
                    foundId = true;
                    ++numberOfIndexedOrRemovedReferences;
                    break;
                }
                if (foundId) continue;
                Identifier pid = new Identifier();
                pid.setValue(id);
                logger.info("Identifier " + id + " was not found in the referenced id list in the Solr search index.");
                SystemMetadata smd = HazelcastClientFactory.getSystemMetadataMap().get(TypeFactory.buildIdentifier(id));
                if (smd == null || !this.notVisibleInIndex(smd)) continue;
                ++numberOfIndexedOrRemovedReferences;
            }
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), e2);
            return false;
        }
        return referencedIds.size() == numberOfIndexedOrRemovedReferences;
    }

    private boolean notVisibleInIndex(SystemMetadata smd) {
        if (smd == null) {
            return false;
        }
        return !SolrDoc.visibleInIndex(smd);
    }

    private boolean representsResourceMap(IndexTask task) {
        return ForesiteResourceMap.representsResourceMap(task.getFormatId());
    }

    private boolean isObjectPathReady(IndexTask task) {
        if (this.isDataObject(task)) {
            return true;
        }
        if (!StringUtils.isBlank(task.getObjectPath()) && new File(task.getObjectPath()).exists()) {
            return true;
        }
        String hzObjectPath = this.retrieveHzObjectPath(task.getPid());
        if (hzObjectPath != null && new File(hzObjectPath).exists()) {
            task.setObjectPath(hzObjectPath);
            return true;
        }
        logger.info("Valid Object Path could not be found for pid: " + task.getPid() + "  Checked path strings in the task [" + task.getObjectPath() + "] and Hazelcast objectPathMap [" + hzObjectPath + "]");
        return false;
    }

    private boolean isDataObject(IndexTask task) {
        ObjectFormat format = null;
        try {
            format = ObjectFormatCache.getInstance().getFormat(TypeFactory.buildFormatIdentifier(task.getFormatId()));
        }
        catch (NotFound e2) {
            logger.warn(String.format("object format for '%s' with formatid '%s' could not be found!!", task.getPid(), task.getFormatId()));
            return false;
        }
        return FORMAT_TYPE_DATA.equals(format.getFormatType());
    }

    private String retrieveHzObjectPath(String pidString) {
        Identifier pid = TypeFactory.buildIdentifier(pidString);
        String path = HazelcastClientFactory.getObjectPathMap().get(pid);
        if (path == null) {
            HazelcastClientFactory.getObjectPathMap().evict(pid);
            if (logger.isDebugEnabled()) {
                logger.debug("did not find Object Path for pid: " + pidString + " cleaning up the map by evicting the pid.");
            }
        }
        return path;
    }

    public List<IndexTask> getIndexTaskQueue() {
        maxTryCount = Settings.getConfiguration().getInt("dataone.indexing.processing.max.tryCount", 8);
        long getIndexTasksStart = System.currentTimeMillis();
        logger.info("New index tasks with less than " + maxTryCount + " try-count (resource maps sometimes will be set the status new even though the indexing failed) in the index queue will be processed.");
        List<IndexTask> indexTasks = this.repo.findByStatusAndTryCountLessThanOrderByPriorityAscTaskModifiedDateAsc("NEW", maxTryCount);
        if (this.perfLog.isLogEnabled()) {
            this.perfLog.log("IndexTaskProcessor.getIndexTaskQueue() fetching NEW IndexTasks from repo", System.currentTimeMillis() - getIndexTasksStart);
        }
        return indexTasks;
    }

    private List<IndexTask> getIndexTaskRetryQueue() {
        logger.info("Failed index tasks with less than " + maxTryCount + " try-count in the index queue will be processed.");
        return this.repo.findByStatusAndNextExecutionLessThanAndTryCountLessThan("FAILED", System.currentTimeMillis(), maxTryCount);
    }

    private IndexTask saveTask(IndexTask task) {
        try {
            task = this.repo.save(task);
            logger.info("IndexTaskProcess.saveTask save the index task " + task.getPid());
        }
        catch (ObjectOptimisticLockingFailureException e2) {
            logger.error("Unable to update index task for pid: " + task.getPid() + ".");
            task = null;
        }
        return task;
    }

    private void saveTaskWithoutDuplication(IndexTask task) {
        if (task != null && !this.newOrFailedIndexTaskExists(task.getPid())) {
            this.saveTask(task);
        }
    }

    private boolean newOrFailedIndexTaskExists(String id) {
        logger.info("IndexTaskProcess.newOrFailedIndexTaskExists for id " + id);
        boolean exist = false;
        if (id != null) {
            List<IndexTask> itList = this.repo.findByPidAndStatus(id, "NEW");
            if (itList != null && !itList.isEmpty()) {
                logger.info("IndexTaskProcess.newOrFailedIndexTaskExists did find a new-status index task for id " + id);
                exist = true;
            }
            if (!exist && (itList = this.repo.findByPidAndStatus(id, "FAILED")) != null && !itList.isEmpty()) {
                logger.info("IndexTaskProcess.newOrFailedIndexTaskExists did find a failed-status index task for id " + id);
                exist = true;
            }
        }
        return exist;
    }

    private Document loadDocument(IndexTask task) {
        Document docObject = null;
        try {
            docObject = XmlDocumentUtility.loadDocument(task.getObjectPath());
        }
        catch (Exception e2) {
            logger.error(e2.getMessage(), e2);
        }
        if (docObject == null) {
            logger.error("Could not load OBJECT file for ID,Path=" + task.getPid() + ", " + task.getObjectPath());
        }
        return docObject;
    }

    public void setSolrQueryUri(String uri) {
        this.solrQueryUri = uri;
    }

    public ExecutorService getExecutorService() {
        return executor;
    }

    public Queue<Future<Void>> getFutureQueue() {
        return new CircularFifoQueue<Future<Void>>(futureQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdownExecutor() {
        IndexTask t2;
        inShutdownMode = true;
        logger.warn("processor [" + this + "] Shutting down the ExecutorService.  Will allow active tasks to finish; will cancel submitted tasks and return them to NEW status, wait for active tasks to finish, then return any remaining task not yet submitted to NEW status....");
        logger.warn("...1.) closing ExecutorService to new tasks...");
        this.getExecutorService().shutdown();
        logger.warn("...2.) canceling cancelable futures...");
        logger.warn(String.format("...number of futures: %d", futureQueue.size()));
        logger.warn("... number of tasks in futures map: " + futureMap.size());
        int marked = 0;
        int noTaskMapping = 0;
        LinkedList<Future> uncancelable = new LinkedList<Future>();
        if (!futureQueue.isEmpty()) {
            for (int i = futureQueue.size() - 1; i > -1; --i) {
                Future f = futureQueue.get(i);
                if (f.cancel(false)) {
                    t2 = futureMap.get(f);
                    if (t2 != null) {
                        try {
                            t2.setStatus("NEW");
                            this.repo.save(t2);
                            ++marked;
                            logger.warn("IndexTaskProcessor.shutdownExecutor - task returned to NEW status for object " + t2.getPid());
                        }
                        catch (Exception e2) {
                            logger.error("IndexTaskProcessor.shutdownExecutor - task canceled for object " + t2.getPid() + " but could not be returned to NEW status. Exception raised: " + e2.getClass().getCanonicalName() + ": " + e2.getMessage(), e2);
                        }
                        continue;
                    }
                    ++noTaskMapping;
                    continue;
                }
                uncancelable.add(f);
            }
            logger.warn(String.format("...number of (cancelable) runnables/tasks reset to new: %d", marked));
            logger.warn(String.format("...number of (cancelable) runnables not mapped to tasks: %d", noTaskMapping));
            logger.warn(String.format("...number of uncancelable runnables: %d (completed or in process)", uncancelable.size()));
        }
        try {
            logger.warn("...3.) waiting (with timeout) for active futures to finish...");
            this.getExecutorService().awaitTermination(3L, TimeUnit.MINUTES);
            logger.warn("...4.) Reviewing remaining uncancellables to check for completion, returning incomplete ones to NEW status...");
            if (!uncancelable.isEmpty()) {
                for (Future f : uncancelable) {
                    if (f.isDone()) continue;
                    t2 = futureMap.get(f);
                    if (t2 != null) {
                        if ("IN PROCESS".equals(t2.getStatus())) {
                            try {
                                t2.markNew();
                                this.repo.save(t2);
                                logger.warn("...active future for pid " + t2.getPid() + " not done.  Resetting to NEW, to allow reprocessing next time...");
                            }
                            catch (Exception e3) {
                                logger.warn("IndexTaskProcessor.shutdownExecutor - can't reset the status to new and save the index task for the object " + t2.getPid() + " since " + e3.getMessage(), e3);
                            }
                            continue;
                        }
                        logger.warn("...active future for pid " + t2.getPid() + "completed during wait period with status " + t2.getStatus());
                        continue;
                    }
                    logger.error("...CANNOT requeue task. No task mapped to this future!!");
                }
            }
        }
        catch (InterruptedException e4) {
            logger.warn("interrupt caught while waiting for executor service to finish executing uninterruptable tasks.");
        }
        finally {
            logger.warn("...5.) Calling shutdownNow on the executor service.");
            List<Runnable> stillWaiting = this.getExecutorService().shutdownNow();
            logger.warn("... .... number of runnables still waiting: " + stillWaiting.size());
            logger.warn("...6.) returning preSubmitted tasks to NEW status...");
            logger.warn("... .... number of preSubmitted tasks: " + preSubmittedTasks.size());
            for (IndexTask t2 : preSubmittedTasks) {
                try {
                    t2.markNew();
                    this.repo.save(t2);
                    logger.warn("... preSubmittedTask for pid " + t2.getPid() + "returned to NEW status.");
                }
                catch (Throwable e5) {
                    logger.error("....... Exception thrown trying to return task to NEW status for pid: " + t2.getPid(), e5);
                }
            }
            logger.warn("............7.) DONE with shutting down IndexTaskProcessor.");
        }
    }
}

