/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XmlDocumentUtility {
    private static Logger log = Logger.getLogger(XmlDocumentUtility.class);
    private static final String INPUT_ENCODING = "UTF-8";

    public static Document loadDocument(String filePath) throws ParserConfigurationException, IOException, SAXException {
        return XmlDocumentUtility.loadDocument(filePath, INPUT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document loadDocument(String filePath, String input_encoding) throws ParserConfigurationException, IOException, SAXException {
        Document doc = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            fis = new FileInputStream(filePath);
            isr = new InputStreamReader((InputStream)fis, input_encoding);
            InputSource source = new InputSource(isr);
            doc = builder.parse(source);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            log.error("Error parsing file: " + filePath);
        }
        finally {
            if (isr != null) {
                isr.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        return doc;
    }

    public static Document generateXmlDocument(InputStream smdStream) throws SAXException {
        Document doc = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            doc = builder.parse(smdStream);
        }
        catch (IOException e2) {
            log.error(e2.getMessage(), e2);
        }
        catch (ParserConfigurationException e3) {
            log.error(e3.getMessage(), e3);
        }
        return doc;
    }
}

