/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.annotation;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.xpath.XPathExpressionException;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.JSONValue;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.AbstractStubMergingSubprocessor;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.annotation.OntologyModelService;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.IDocumentSubprocessorV2;
import org.dataone.cn.indexer.parser.ISolrDataField;
import org.dataone.cn.indexer.parser.SubprocessorUtility;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;

public class AnnotatorSubprocessor
extends AbstractStubMergingSubprocessor
implements IDocumentSubprocessor,
IDocumentSubprocessorV2 {
    public static final String FIELD_ANNOTATION = "sem_annotation";
    public static final String FIELD_ANNOTATES = "sem_annotates";
    public static final String FIELD_ANNOTATED_BY = "sem_annotated_by";
    public static final String FIELD_COMMENT = "sem_comment";
    private static Logger log = Logger.getLogger(AnnotatorSubprocessor.class.getName());
    @Autowired
    private SubprocessorUtility processorUtility;
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrQueryUri = null;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<String> fieldsToMerge = new ArrayList<String>();
    private List<ISolrDataField> fieldList = new ArrayList<ISolrDataField>();

    public List<String> getMatchDocuments() {
        return this.matchDocuments;
    }

    public void setMatchDocuments(List<String> matchDocuments) {
        this.matchDocuments = matchDocuments;
    }

    public List<String> getFieldsToMerge() {
        return this.fieldsToMerge;
    }

    public void setFieldsToMerge(List<String> fieldsToMerge) {
        this.fieldsToMerge = fieldsToMerge;
    }

    public List<ISolrDataField> getFieldList() {
        return this.fieldList;
    }

    public void setFieldList(List<ISolrDataField> fieldList) {
        this.fieldList = fieldList;
    }

    @Override
    public boolean canProcess(String formatId) {
        return this.matchDocuments.contains(formatId);
    }

    @Override
    protected Map<String, SolrDoc> parseDocument(String mainIdentifier, InputStream source) throws Exception {
        HashMap<String, SolrDoc> docMap = new HashMap<String, SolrDoc>();
        long parseAnnotationStart = System.currentTimeMillis();
        SolrDoc annotations = this.parseAnnotation(source);
        this.perfLog.log("AnnotatorSubprocessor.parseDocument() parseAnnotation() ", System.currentTimeMillis() - parseAnnotationStart);
        if (annotations != null) {
            String referencedPid = annotations.getIdentifier();
            SolrDoc referencedDoc = new SolrDoc();
            referencedDoc.addField(new SolrElementField("id", referencedPid));
            docMap.put(referencedPid, referencedDoc);
            for (SolrElementField annotation : annotations.getFieldList()) {
                if (!this.fieldsToMerge.contains(annotation.getName())) {
                    log.debug("SKIPPING field (not in fieldsToMerge): " + annotation.getName());
                    continue;
                }
                referencedDoc.addField(annotation);
                log.debug("ADDING annotation to " + referencedPid + ": " + annotation.getName() + "=" + annotation.getValue());
            }
            SolrDoc annotationDoc = new SolrDoc();
            annotationDoc.addField(new SolrElementField("id", mainIdentifier));
            annotationDoc.addField(new SolrElementField(FIELD_ANNOTATES, referencedPid));
            docMap.put(mainIdentifier, annotationDoc);
        }
        return docMap;
    }

    @Override
    public Map<String, SolrDoc> processDocument(String annotationId, Map<String, SolrDoc> docs, InputStream is) throws Exception {
        long parseAnnotationStart = System.currentTimeMillis();
        SolrDoc annotations = this.parseAnnotation(is);
        this.perfLog.log("AnnotatorSubprocessor.processDocument() parseAnnotation() ", System.currentTimeMillis() - parseAnnotationStart);
        if (annotations != null) {
            SolrDoc annotationDoc;
            String referencedPid = annotations.getIdentifier();
            SolrDoc referencedDoc = docs.get(referencedPid);
            if (referencedDoc == null) {
                try {
                    referencedDoc = this.d1IndexerSolrClient.retrieveDocumentFromSolrServer(referencedPid, this.solrQueryUri);
                }
                catch (Exception e2) {
                    log.error("Unable to retrieve solr document: " + referencedPid + ".  Exception attempting to communicate with solr server.", e2);
                }
                if (referencedDoc == null) {
                    log.warn("DID NOT LOCATE REFERENCED DOC: " + referencedPid);
                    referencedDoc = new SolrDoc();
                    referencedDoc.addField(new SolrElementField("id", referencedPid));
                }
                docs.put(referencedPid, referencedDoc);
            }
            if ((annotationDoc = docs.get(annotationId)) != null) {
                annotationDoc.addField(new SolrElementField(FIELD_ANNOTATES, referencedPid));
            }
            for (SolrElementField annotation : annotations.getFieldList()) {
                if (!this.fieldsToMerge.contains(annotation.getName())) {
                    log.debug("SKIPPING field (not in fieldsToMerge): " + annotation.getName());
                    continue;
                }
                referencedDoc.addField(annotation);
                log.debug("ADDING annotation to " + referencedPid + ": " + annotation.getName() + "=" + annotation.getValue());
            }
        } else {
            log.warn("Annotations were not found when parsing: " + annotationId);
        }
        return docs;
    }

    protected SolrDoc parseAnnotation(InputStream is) {
        try {
            Object reject;
            String idValue;
            String results = null;
            try {
                results = IOUtils.toString(is, "UTF-8");
            }
            finally {
                IOUtils.closeQuietly(is);
            }
            log.debug("RESULTS: " + results);
            JSONObject annotation = (JSONObject)JSONValue.parse(results);
            SolrDoc annotations = new SolrDoc();
            String tagKey = FIELD_ANNOTATION;
            String pidValue = annotation.get("pid").toString();
            if (!annotations.hasFieldWithValue("id", pidValue)) {
                annotations.addField(new SolrElementField("id", pidValue));
            }
            if (!annotations.hasFieldWithValue(FIELD_ANNOTATED_BY, idValue = annotation.get("id").toString())) {
                annotations.addField(new SolrElementField(FIELD_ANNOTATED_BY, idValue));
            }
            if ((reject = annotation.get("reject")) != null && Boolean.parseBoolean(reject.toString())) {
                if (!annotations.hasFieldWithValue(tagKey, "")) {
                    annotations.addField(new SolrElementField(tagKey, ""));
                }
                if (!annotations.hasFieldWithValue(FIELD_COMMENT, "")) {
                    annotations.addField(new SolrElementField(FIELD_COMMENT, ""));
                }
            } else {
                String value;
                Object commentObj;
                Object obj;
                Object field = annotation.get("field");
                if (field != null) {
                    tagKey = field.toString();
                }
                if ((obj = annotation.get("tags")) instanceof JSONArray) {
                    JSONArray tags = (JSONArray)obj;
                    for (Object e2 : tags) {
                        String value2 = e2.toString();
                        if (annotations.hasFieldWithValue(tagKey, value2)) continue;
                        annotations.addField(new SolrElementField(tagKey, value2));
                    }
                } else {
                    String value3 = obj.toString();
                    if (!annotations.hasFieldWithValue(tagKey, value3)) {
                        annotations.addField(new SolrElementField(tagKey, value3));
                    }
                }
                if ((commentObj = annotation.get("text")) != null && (value = commentObj.toString()) != null && value.length() > 0 && !annotations.hasFieldWithValue(FIELD_COMMENT, value)) {
                    annotations.addField(new SolrElementField(FIELD_COMMENT, value));
                }
                for (String string : annotations.getAllFieldValues(tagKey)) {
                    try {
                        Map<String, Set<String>> expandedConcepts = OntologyModelService.getInstance().expandConcepts(string);
                        for (Map.Entry<String, Set<String>> entry : expandedConcepts.entrySet()) {
                            for (String value4 : entry.getValue()) {
                                String name = entry.getKey();
                                if (annotations.hasFieldWithValue(name, value4)) continue;
                                annotations.addField(new SolrElementField(name, value4));
                            }
                        }
                    }
                    catch (Exception e2) {
                        log.error("Problem exapnding concept: " + string, e2);
                    }
                }
            }
            return annotations;
        }
        catch (Exception e3) {
            log.error("Problem parsing annotation: " + e3.getMessage(), e3);
            return null;
        }
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return this.processorUtility.mergeWithIndexedDocument(indexDocument, this.fieldsToMerge);
    }
}

