/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.v2.formats.ObjectFormatCache;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.index.generator.IndexTaskGenerator;
import org.dataone.cn.index.util.PerformanceLogger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.parser.IDocumentSubprocessor;
import org.dataone.cn.indexer.parser.utility.SeriesIdResolver;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.TypeFactory;
import org.dataone.service.types.v2.ObjectFormat;
import org.dataone.service.types.v2.SystemMetadata;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseReprocessSubprocessor
implements IDocumentSubprocessor {
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient;
    @Autowired
    private String solrQueryUri;
    @Autowired
    private IndexTaskGenerator indexTaskGenerator;
    private PerformanceLogger perfLog = PerformanceLogger.getInstance();
    private List<String> matchDocuments = null;
    private List<String> relationFields;
    public static Log log = LogFactory.getLog(BaseReprocessSubprocessor.class);
    private static boolean bypass = false;

    @Override
    public Map<String, SolrDoc> processDocument(String identifier, Map<String, SolrDoc> docs, InputStream is) throws XPathExpressionException, IOException, EncoderException {
        if (bypass) {
            return docs;
        }
        long getSysMetaStart = System.currentTimeMillis();
        SystemMetadata sysMeta = HazelcastClientFactory.getSystemMetadataMap().get(TypeFactory.buildIdentifier(identifier));
        this.perfLog.log("BaseReprocessSubprocessor.processDocument() HazelcastClientFactory.getSystemMetadataMap().get(id) for id " + identifier, System.currentTimeMillis() - getSysMetaStart);
        if (sysMeta == null || sysMeta.getSeriesId() == null) {
            return docs;
        }
        log.debug("seriesId===" + sysMeta.getSeriesId().getValue());
        long getIdsInSeriesStart = System.currentTimeMillis();
        List<SolrDoc> previousDocs = this.d1IndexerSolrClient.getDocumentsByField(this.solrQueryUri, Collections.singletonList(sysMeta.getSeriesId().getValue()), "seriesId", true);
        this.perfLog.log("BaseReprocessSubprocessor.processDocument() d1IndexerSolrClient.getDocumentsByField(idsInSeries) for id " + identifier, System.currentTimeMillis() - getIdsInSeriesStart);
        if (previousDocs == null || previousDocs.isEmpty()) {
            return docs;
        }
        HashSet<String> pidsToReprocess = new HashSet<String>();
        for (SolrDoc indexedDoc : previousDocs) {
            log.debug("indexedDoc===" + indexedDoc);
            for (String fieldName : this.relationFields) {
                log.debug("fieldName===" + fieldName);
                List<String> relationFieldValues = indexedDoc.getAllFieldValues(fieldName);
                if (relationFieldValues == null) continue;
                for (String relationFieldValue : relationFieldValues) {
                    Identifier relatedId = TypeFactory.buildIdentifier(relationFieldValue);
                    try {
                        SystemMetadata relatedSysMeta = HazelcastClientFactory.getSystemMetadataMap().get(relatedId);
                        if (relatedSysMeta == null) {
                            Identifier pid;
                            relatedId = pid = SeriesIdResolver.getPid(relatedId);
                        }
                        if (pidsToReprocess.contains(relatedId.getValue())) continue;
                        pidsToReprocess.add(relatedId.getValue());
                        log.debug("Processing relatedPid===" + relatedId.getValue());
                        relatedSysMeta = HazelcastClientFactory.getSystemMetadataMap().get(relatedId);
                        String objectPath = HazelcastClientFactory.getObjectPathMap().get(relatedId);
                        log.debug("Processing relatedSysMeta===" + relatedSysMeta);
                        log.debug("Processing objectPath===" + objectPath);
                        this.indexTaskGenerator.processSystemMetaDataUpdate(relatedSysMeta, objectPath);
                    }
                    catch (ClientSideException | BaseException e2) {
                        log.error("Could not locate PID for given identifier: " + relatedId.getValue(), e2);
                    }
                }
            }
        }
        this.perfLog.log("BaseReprocessSubprocessor.processDocument() reprocessing all docs earlier in sid chain for id " + identifier, System.currentTimeMillis() - getIdsInSeriesStart);
        return docs;
    }

    @Override
    public boolean canProcess(String formatId) {
        if (this.matchDocuments != null) {
            return this.matchDocuments.contains(formatId);
        }
        try {
            ObjectFormat objectFormat = ObjectFormatCache.getInstance().getFormat(TypeFactory.buildFormatIdentifier(formatId));
            if (objectFormat != null) {
                return !objectFormat.getFormatType().equalsIgnoreCase("RESOURCE");
            }
            return true;
        }
        catch (BaseException e2) {
            log.warn("No format found in ObjectFormatCache for format '" + formatId + "'", e2);
            return true;
        }
    }

    @Override
    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument) throws IOException, EncoderException, XPathExpressionException {
        return indexDocument;
    }

    public List<String> getRelationFields() {
        return this.relationFields;
    }

    public void setRelationFields(List<String> relationFields) {
        this.relationFields = relationFields;
    }
}

