/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser;

import java.io.IOException;
import java.util.List;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.codec.EncoderException;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.springframework.beans.factory.annotation.Autowired;

public class SubprocessorUtility {
    private static Logger logger = Logger.getLogger(SubprocessorUtility.class.getName());
    @Autowired
    private D1IndexerSolrClient d1IndexerSolrClient = null;
    @Autowired
    private String solrQueryUri = null;
    private boolean usePartialUpdate = false;

    public SolrDoc mergeWithIndexedDocument(SolrDoc indexDocument, List<String> fieldsToMerge) throws IOException, EncoderException, XPathExpressionException {
        if (this.usePartialUpdate) {
            return this.diffWithIndexedDocument(indexDocument);
        }
        logger.debug("about to merge indexed document with new doc to insert for pid: " + indexDocument.getIdentifier());
        SolrDoc solrDocFromSolr = this.d1IndexerSolrClient.retrieveDocumentFromSolrServer(indexDocument.getIdentifier(), this.solrQueryUri);
        if (solrDocFromSolr != null) {
            logger.debug("found existing doc to merge for pid: " + indexDocument.getIdentifier());
            for (SolrElementField field : solrDocFromSolr.getFieldList()) {
                if (!fieldsToMerge.contains(field.getName()) || indexDocument.hasFieldWithValue(field.getName(), field.getValue())) continue;
                indexDocument.addField(field);
                logger.debug("merging field: " + field.getName() + " with value: " + field.getValue());
            }
        }
        return indexDocument;
    }

    public SolrDoc diffWithIndexedDocument(SolrDoc newIndexDocument) throws IOException, EncoderException, XPathExpressionException {
        logger.debug("about to diff indexed document with new doc to insert for pid: " + newIndexDocument.getIdentifier());
        logger.debug("...  new doc has " + newIndexDocument.getFieldList().size() + " fields to diff...");
        SolrDoc solrDocFromSolr = this.d1IndexerSolrClient.retrieveDocumentFromSolrServer(newIndexDocument.getIdentifier(), this.solrQueryUri);
        return this.diffWithIndexedDocument(newIndexDocument, solrDocFromSolr);
    }

    public SolrDoc diffWithIndexedDocument(SolrDoc newIndexDocument, SolrDoc oldIndexDocument) {
        if (oldIndexDocument != null) {
            logger.debug("found existing doc to diff for pid: " + newIndexDocument.getIdentifier());
            SolrDoc diffDoc = new SolrDoc();
            for (SolrElementField field : newIndexDocument.getFieldList()) {
                if (!field.getName().equals("id") && oldIndexDocument.hasFieldWithValue(field.getName(), field.getValue())) continue;
                diffDoc.addField(field);
                logger.debug("diffing field: " + field.getName() + " with value: " + field.getValue());
            }
            if (oldIndexDocument.getField("_version_") != null) {
                SolrElementField versionField = new SolrElementField();
                versionField.setName("_version_");
                versionField.setValue(oldIndexDocument.getFirstFieldValue("_version_"));
                diffDoc.addField(versionField);
            }
            logger.debug("...  diff doc has " + diffDoc.getFieldList().size() + " remaining fields");
            return diffDoc;
        }
        SolrElementField versionField = new SolrElementField();
        versionField.setName("_version_");
        versionField.setValue("-1");
        newIndexDocument.addField(versionField);
        logger.debug("....  diff doc has " + newIndexDocument.getFieldList().size() + " remaining fields");
        return newIndexDocument;
    }
}

