/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.parser.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.indexer.parser.utility.LeafElement;
import org.w3c.dom.Node;

public class FilterProcessor {
    private String name;
    private String matchElement;
    private Boolean escapeSpecialChars = false;
    private Boolean quoteMultipleWords = false;
    private String xPath;
    private XPathExpression xPathExpression = null;
    private String delimiter;
    private List<LeafElement> leafs = new ArrayList<LeafElement>();
    private String template;
    private String defaults;
    private HashMap<String, String> defaultValues = new HashMap();
    private final String DEFAULT_OPERATOR = "AND";
    private Log log = LogFactory.getLog(FilterProcessor.class);

    public String getFilterValue(Node node) throws XPathExpressionException {
        HashMap<String, ArrayList<String>> leafValues = new HashMap<String, ArrayList<String>>();
        this.log.debug("FilterProcessor.getFilterValues");
        HashSet<String> leafNames = new HashSet<String>();
        HashSet<String> allLeafNames = new HashSet<String>();
        this.log.debug("getting filter values for node: " + node.getNodeName());
        String value = null;
        String completeFilterValue = null;
        this.name = this.getName();
        Boolean excludeCondition = false;
        Boolean matchSubstring = false;
        this.template = this.getTemplate();
        this.defaults = this.getDefaults();
        if (this.defaults != null && !this.defaults.isEmpty()) {
            for (String term : this.defaults.split(",")) {
                String[] tokens = term.split(":");
                this.defaultValues.put(tokens[0], tokens[1]);
            }
        }
        String thisFilterValue = null;
        for (LeafElement leafElement : this.getLeafs()) {
            String leafName = leafElement.getName();
            this.log.trace("Processing leafname: " + leafName);
            allLeafNames.add(leafName);
            value = leafElement.getLeafValue(node);
            String delimeter = leafElement.getDelimiter();
            if (value == null || value.isEmpty()) {
                if (!this.defaultValues.containsKey(leafName)) continue;
                leafValues = this.addLeafValue(leafValues, leafName, this.defaultValues.get(leafName), delimeter);
                leafNames.add(leafName);
                continue;
            }
            leafNames.add(leafName);
            if (leafName.compareToIgnoreCase("exclude") == 0) {
                if (Boolean.parseBoolean(value)) {
                    excludeCondition = true;
                }
            } else if (leafName.compareToIgnoreCase("matchSubstring") == 0 && Boolean.parseBoolean(value)) {
                matchSubstring = true;
            }
            leafValues = this.addLeafValue(leafValues, leafName, value, delimeter);
        }
        String selectedTemplate = this.selectTemplate(leafNames, allLeafNames);
        for (String key : leafValues.keySet()) {
            this.log.trace("leafValues name: " + key);
        }
        int nFields = 0;
        int nValues = 0;
        ArrayList currentValues = (ArrayList)leafValues.get("field");
        nFields = currentValues.size();
        if (leafValues.containsKey("value")) {
            currentValues = (ArrayList)leafValues.get("value");
            nValues = currentValues.size();
        } else {
            nValues = 1;
        }
        this.log.trace("nFields: " + nFields);
        this.log.trace("nValues: " + nValues);
        for (int iField = 0; iField < nFields; ++iField) {
            this.log.trace("iField: " + iField);
            for (int iValue = 0; iValue < nValues; ++iValue) {
                this.log.trace("iValue: " + iValue);
                thisFilterValue = selectedTemplate;
                for (String lname : leafNames) {
                    value = lname.compareToIgnoreCase("field") == 0 ? this.getLeafValue(leafValues, lname, iField) : (lname.compareToIgnoreCase("value") == 0 ? this.getLeafValue(leafValues, lname, iValue) : this.getLeafValue(leafValues, lname, 0));
                    if (matchSubstring.booleanValue() && lname.compareToIgnoreCase("value") == 0) {
                        value = "*" + value + "*";
                    }
                    if (lname.compareToIgnoreCase("value") == 0) {
                        if (this.escapeSpecialChars.booleanValue()) {
                            value = this.escapeSpecialChars(value);
                        }
                        if (this.quoteMultipleWords.booleanValue()) {
                            value = this.checkQuoting(value);
                        }
                    }
                    thisFilterValue = this.applyTemplate(lname, value, thisFilterValue);
                }
                this.log.debug("thisFilterValue: " + thisFilterValue);
                if (excludeCondition.booleanValue()) {
                    thisFilterValue = "-" + thisFilterValue;
                }
                if (iValue == 0 && iField == 0) {
                    completeFilterValue = thisFilterValue;
                    continue;
                }
                String operator = null;
                operator = leafValues.containsKey("operator") ? this.getLeafValue(leafValues, "operator", 0) : "AND";
                completeFilterValue = completeFilterValue + " " + operator + " " + thisFilterValue;
            }
        }
        if (nFields > 1 || nValues > 1) {
            completeFilterValue = "(" + completeFilterValue + ")";
        }
        completeFilterValue = completeFilterValue.trim();
        this.log.debug("    * * * * Final filter value: " + completeFilterValue);
        return completeFilterValue;
    }

    private String selectTemplate(Set<String> leafNames, Set<String> allLeafNames) {
        String selectedTemplate = null;
        String[] templateValues = this.template.split(",");
        if (templateValues.length == 1) {
            return this.template;
        }
        Pattern p = Pattern.compile("[a-zA-Z]+");
        Matcher m1 = null;
        Boolean matchAll = false;
        for (String tval : templateValues) {
            m1 = p.matcher(tval);
            while (m1.find()) {
                Boolean foundMatch = false;
                matchAll = false;
                String thisToken = m1.group();
                if (!allLeafNames.contains(thisToken)) continue;
                for (String lname : leafNames) {
                    if (thisToken.compareToIgnoreCase(lname) != 0) continue;
                    foundMatch = true;
                }
                if (!foundMatch.booleanValue()) break;
                matchAll = true;
            }
            if (!matchAll.booleanValue()) continue;
            selectedTemplate = tval;
            this.log.debug("Selecting template: " + tval);
            break;
        }
        if (!matchAll.booleanValue()) {
            selectedTemplate = templateValues[0];
            this.log.debug("Can't find template match, using template: " + selectedTemplate);
        }
        return selectedTemplate;
    }

    private String applyTemplate(String name, String value, String filterValue) {
        if (value == null || value.isEmpty()) {
            return filterValue;
        }
        filterValue = this.applyItem(name, value, filterValue);
        return filterValue;
    }

    private String applyItem(String name, String value, String filterValue) {
        filterValue = filterValue.replace(name, value);
        return filterValue;
    }

    private HashMap<String, ArrayList<String>> addLeafValue(HashMap<String, ArrayList<String>> leafValues, String leafName, String leafValue, String delimeter) {
        ArrayList<Object> currentValues = new ArrayList<String>();
        Boolean replace = false;
        if (leafValues.containsKey(leafName)) {
            replace = true;
            currentValues = leafValues.get(leafName);
        }
        if (delimeter != null && !delimeter.isEmpty()) {
            String[] thisLeafValues;
            for (String val : thisLeafValues = leafValue.split(delimeter)) {
                this.log.debug("Adding leaf name, value: " + leafName + ", " + val);
                currentValues.add(val);
            }
        } else {
            currentValues.add(leafValue);
            this.log.debug("Adding leaf name,value: " + leafName + ", " + leafValue);
        }
        if (replace.booleanValue()) {
            leafValues.remove(leafName);
            leafValues.put(leafName, currentValues);
        } else {
            leafValues.put(leafName, currentValues);
        }
        return leafValues;
    }

    private String getLeafValue(HashMap<String, ArrayList<String>> leafValues, String leafName, int index) {
        ArrayList<String> currentValues = leafValues.get(leafName);
        this.log.debug("Getting leaf name, value: " + leafName + ", " + currentValues.get(index));
        return currentValues.get(index);
    }

    private String escapeSpecialChars(String value) {
        value = value.replace("%7B", "\\%7B");
        value = value.replace("%7D", "\\%7D");
        value = value.replace("%3A", "\\%3A");
        value = value.replace(":", "\\:");
        value = value.replace("(", "\\(");
        value = value.replace(")", "\\)");
        value = value.replace("?", "\\?");
        value = value.replace("%3F", "\\%3F");
        value = value.replace("\"", "\\\"");
        value = value.replace("'", "\\'");
        return value;
    }

    private String checkQuoting(String value) {
        Pattern p = Pattern.compile("\\s+?");
        Matcher m1 = null;
        m1 = p.matcher(value);
        if (m1.find()) {
            value = "\"" + value + "\"";
        }
        return value;
    }

    public void initXPathExpressions() {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        for (LeafElement leafElement : this.getLeafs()) {
            try {
                XPathExpression expr = xpath.compile(leafElement.getxPath());
                leafElement.setxPathExpression(expr);
            }
            catch (XPathExpressionException e2) {
                e2.printStackTrace();
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getxPath() {
        return this.xPath;
    }

    public void setxPath(String xPath) {
        this.xPath = xPath;
    }

    public String getDefaults() {
        return this.defaults;
    }

    public void setDefaults(String defaults) {
        this.defaults = defaults;
    }

    public Boolean getEscapeSpecialChars() {
        return this.escapeSpecialChars;
    }

    public void setEscapeSpecialChars(Boolean escapeSpecialChars) {
        this.escapeSpecialChars = escapeSpecialChars;
    }

    public Boolean getQuoteMultipleWords() {
        return this.quoteMultipleWords;
    }

    public void setQuoteMultipleWords(Boolean quoteMultipleWords) {
        this.quoteMultipleWords = quoteMultipleWords;
    }

    public XPathExpression getxPathExpression() {
        return this.xPathExpression;
    }

    public void setxPathExpression(XPathExpression xPathExpression) {
        this.xPathExpression = xPathExpression;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public String getMatchElement() {
        return this.matchElement;
    }

    public void setMatchElement(String matchElement) {
        this.matchElement = matchElement;
    }

    public List<LeafElement> getLeafs() {
        return this.leafs;
    }

    public void setLeafs(List<LeafElement> leafs) {
        this.leafs = leafs;
    }
}

