/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.log4j.Logger;
import org.dataone.cn.indexer.D1IndexerSolrClient;
import org.dataone.cn.indexer.solrhttp.OutputStreamHttpEntity;
import org.dataone.cn.indexer.solrhttp.SolrDoc;
import org.dataone.cn.indexer.solrhttp.SolrElementAdd;
import org.dataone.cn.indexer.solrhttp.SolrSchema;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTTPService
implements D1IndexerSolrClient {
    private static final String CHAR_ENCODING = "UTF-8";
    private static final String XML_CONTENT_TYPE = "text/xml";
    static final String PARAM_START = "start";
    static final String PARAM_ROWS = "rows";
    static final String PARAM_INDENT = "indent";
    static final String VALUE_INDENT_ON = "on";
    static final String VALUE_INDENT_OFF = "off";
    static final String PARAM_QUERY = "q";
    static final String PARAM_RETURN = "fl";
    static final String VALUE_WILDCARD = "*";
    private static final String MAX_ROWS = "5000";
    private static Logger log = Logger.getLogger(HTTPService.class.getName());
    private HttpComponentsClientHttpRequestFactory httpRequestFactory;
    private SolrSchema schema;
    private String solrIndexUri;

    public HTTPService(HttpComponentsClientHttpRequestFactory requestFactory) {
        this.httpRequestFactory = requestFactory;
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data) throws IOException {
        this.sendUpdate(uri, data, CHAR_ENCODING);
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data, String encoding, boolean usePartialUpdate) throws IOException {
        if (usePartialUpdate) {
            throw new RuntimeException("Partial Updates not supported by HTTPService");
        }
        this.sendUpdate(uri, data, encoding, false);
    }

    @Override
    public void sendUpdate(String uri, List<SolrDoc> data, String encoding) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", XML_CONTENT_TYPE);
            post.setEntity(new OutputStreamHttpEntity(data, encoding));
            response = this.getHttpClient().execute(post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
                post.abort();
                throw new IOException("unable to update solr, non 200 response code.");
            }
            post.abort();
        }
        catch (Exception ex) {
            try {
                this.writeError(ex, data, inputStreamResponse, uri);
                throw new IOException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStreamResponse);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(inputStreamResponse);
    }

    private void sendPost(String uri, String data) throws IOException {
        this.sendPost(uri, data, CHAR_ENCODING, XML_CONTENT_TYPE);
    }

    private void sendPost(String uri, String data, String encoding, String contentType) throws IOException {
        InputStream inputStreamResponse = null;
        HttpPost post = null;
        HttpResponse response = null;
        try {
            post = new HttpPost(uri);
            post.setHeader("Content-Type", contentType);
            ByteArrayEntity entity = new ByteArrayEntity(data.getBytes());
            entity.setContentEncoding(encoding);
            post.setEntity(entity);
            response = this.getHttpClient().execute(post);
            HttpEntity responseEntity = response.getEntity();
            inputStreamResponse = responseEntity.getContent();
            if (response.getStatusLine().getStatusCode() != 200) {
                this.writeError(null, data, inputStreamResponse, uri);
            }
            post.abort();
        }
        catch (Exception ex) {
            this.writeError(ex, data, inputStreamResponse, uri);
        }
    }

    @Override
    public void sendSolrDelete(String pid) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.write("<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, CHAR_ENCODING);
            String escapedId = StringEscapeUtils.escapeXml(pid);
            IOUtils.write("<delete><id>" + escapedId + "</id></delete>", (OutputStream)outputStream, CHAR_ENCODING);
            this.sendPost(this.getSolrIndexUri(), ((Object)outputStream).toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void sendSolrDeletes(List<String> pids) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            IOUtils.write("<?xml version=\"1.1\" encoding=\"utf-8\"?>\n", (OutputStream)outputStream, CHAR_ENCODING);
            IOUtils.write("<update>", (OutputStream)outputStream, CHAR_ENCODING);
            for (String pid : pids) {
                String escapedId = StringEscapeUtils.escapeXml(pid);
                IOUtils.write("<delete><id>" + escapedId + "</id></delete>", (OutputStream)outputStream, CHAR_ENCODING);
            }
            IOUtils.write("</update>", (OutputStream)outputStream, CHAR_ENCODING);
            this.sendPost(this.getSolrIndexUri(), ((Object)outputStream).toString());
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private void writeError(Exception ex, List<SolrDoc> data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            log.error("URL: " + uri);
            log.error("Post: ");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new SolrElementAdd(data).serialize(baos, CHAR_ENCODING);
            log.error(new String(baos.toByteArray(), CHAR_ENCODING));
            log.error("\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy(inputStreamResonse, (OutputStream)baosResponse);
            log.error(new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void writeError(Exception ex, String data, InputStream inputStreamResonse, String uri) throws IOException {
        try {
            if (ex != null) {
                log.error("Unable to write to stream", ex);
            }
            log.error("URL: " + uri);
            log.error("Post: ");
            log.error(data);
            log.error("\n\n\nResponse: \n");
            ByteArrayOutputStream baosResponse = new ByteArrayOutputStream();
            IOUtils.copy(inputStreamResonse, (OutputStream)baosResponse);
            log.error(new String(baosResponse.toByteArray()));
            inputStreamResonse.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public List<SolrDoc> getDocumentsByD1Identifier(String uir, List<String> ids) throws IOException, XPathExpressionException, EncoderException {
        List<SolrDoc> docs = this.getDocumentsByField(uir, ids, "seriesId", false);
        docs.addAll(this.getDocumentsByField(uir, ids, "id", false));
        return docs;
    }

    @Override
    public List<SolrDoc> getDocumentBySolrId(String uir, String id) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(id), "id", false);
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMap(String uir, String resourceMapId) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByField(uir, Collections.singletonList(resourceMapId), "resourceMap", true);
    }

    @Override
    public List<SolrDoc> getDocumentsByField(String uir, List<String> fieldValues, String queryField, boolean maxRows) throws IOException, XPathExpressionException, EncoderException {
        if (fieldValues == null || fieldValues.size() <= 0) {
            return null;
        }
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        int rows = 0;
        String rowString = "";
        StringBuilder sb = new StringBuilder();
        for (String id : fieldValues) {
            if (sb.length() > 0) {
                sb.append(" OR ");
            }
            sb.append(queryField + ":").append(HTTPService.escapeQueryChars(id));
            ++rows;
            if (sb.length() <= 5000) continue;
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
            rows = 0;
            sb = new StringBuilder();
        }
        if (sb.length() > 0) {
            rowString = maxRows ? MAX_ROWS : Integer.toString(rows);
            docs.addAll(this.doRequest(uir, sb, rowString));
        }
        return docs;
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMapFieldAndDocumentsField(String uir, String resourceMapId, String documentsId) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "documents", documentsId);
    }

    @Override
    public List<SolrDoc> getDocumentsByResourceMapFieldAndIsDocumentedByField(String uir, String resourceMapId, String isDocumentedById) throws IOException, XPathExpressionException, EncoderException {
        return this.getDocumentsByTwoFields(uir, "resourceMap", resourceMapId, "isDocumentedBy", isDocumentedById);
    }

    private List<SolrDoc> getDocumentsByTwoFields(String uir, String field1, String field1Value, String field2, String field2Value) throws IOException, XPathExpressionException, EncoderException {
        ArrayList<SolrDoc> docs = new ArrayList<SolrDoc>();
        StringBuilder sb = new StringBuilder();
        sb.append(field1 + ":").append(HTTPService.escapeQueryChars(field1Value));
        sb.append(" AND ");
        sb.append(field2 + ":").append(HTTPService.escapeQueryChars(field2Value));
        docs.addAll(this.doRequest(uir, sb, MAX_ROWS));
        return docs;
    }

    private List<SolrDoc> doRequest(String uir, StringBuilder sb, String rows) throws IOException, ClientProtocolException, XPathExpressionException {
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair(PARAM_QUERY, sb.toString()));
        params.add(new BasicNameValuePair(PARAM_START, "0"));
        params.add(new BasicNameValuePair(PARAM_ROWS, rows));
        params.add(new BasicNameValuePair(PARAM_INDENT, VALUE_INDENT_ON));
        params.add(new BasicNameValuePair(PARAM_RETURN, VALUE_WILDCARD));
        String paramString = URLEncodedUtils.format(params, CHAR_ENCODING);
        String requestURI = uir + "?" + paramString;
        log.info("REQUEST URI= " + requestURI);
        HttpGet commandGet = new HttpGet(requestURI);
        HttpResponse response = this.getHttpClient().execute(commandGet);
        HttpEntity entity = response.getEntity();
        InputStream content = entity.getContent();
        Document document = null;
        try {
            document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(content);
        }
        catch (SAXException e2) {
            log.error(e2);
        }
        catch (ParserConfigurationException e3) {
            log.error(e3);
        }
        commandGet.abort();
        List<SolrDoc> docs = this.parseResults(document);
        return docs;
    }

    @Override
    public SolrDoc retrieveDocumentFromSolrServer(String id, String solrQueryUri) throws XPathExpressionException, IOException, EncoderException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(id);
        List<SolrDoc> indexedDocuments = this.getDocumentsByD1Identifier(solrQueryUri, ids);
        if (indexedDocuments.size() > 0) {
            return indexedDocuments.get(0);
        }
        return null;
    }

    private List<SolrDoc> parseResults(Document document) throws XPathExpressionException {
        NodeList nodeList = (NodeList)XPathFactory.newInstance().newXPath().evaluate("/response/result/doc", document, XPathConstants.NODESET);
        ArrayList<SolrDoc> docList = new ArrayList<SolrDoc>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element docElement = (Element)nodeList.item(i);
            docList.add(this.parseDoc(docElement));
        }
        return docList;
    }

    private SolrDoc parseDoc(Element docElement) {
        SolrDoc doc = new SolrDoc(docElement, this.schema.getValidFields());
        return doc;
    }

    @Override
    public void setSolrSchemaPath(String path) throws ParserConfigurationException, SAXException, IOException {
        this.schema = new SolrSchema();
        this.schema.setSolrSchemaPath(path);
    }

    @Override
    public void setSolrIndexUri(String uri) {
        this.solrIndexUri = uri;
    }

    @Override
    public String getSolrIndexUri() {
        return this.solrIndexUri;
    }

    @Override
    public HttpClient getHttpClient() {
        return this.httpRequestFactory.getHttpClient();
    }
}

