/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.mutable.MutableInt;
import org.dataone.cn.indexer.solrhttp.SolrElementField;
import org.dataone.service.types.v2.SystemMetadata;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SolrDoc {
    public static final char[] ELEMENT_DOC_OPEN = "<doc>".toCharArray();
    public static final char[] ELEMENT_DOC_CLOSE = "</doc>".toCharArray();
    private static final String DYNAMIC_FIELD_SUFFIX = "_sm";
    private List<SolrElementField> fieldList = new ArrayList<SolrElementField>();
    private FieldCounter fieldCounts = new FieldCounter();
    private String identifier;
    private String seriesId;
    private boolean merged = false;

    public SolrDoc() {
    }

    public SolrDoc(List<SolrElementField> fieldList) {
        this.fieldList = fieldList;
        this.fieldCounts = new FieldCounter();
        for (SolrElementField sef : fieldList) {
            this.fieldCounts.increment(sef.getName());
        }
    }

    public SolrDoc clone() {
        SolrDoc clone = new SolrDoc();
        for (SolrElementField sef : this.fieldList) {
            clone.addField(sef.clone());
        }
        return clone;
    }

    public SolrDoc(Element docElement, Set<String> validFields) {
        this.fieldList = new ArrayList<SolrElementField>();
        NodeList values = docElement.getChildNodes();
        for (int i = 0; i < values.getLength(); ++i) {
            Node n = values.item(i);
            if (n instanceof Text) continue;
            Element elementField = (Element)n;
            String tagName = elementField.getTagName();
            String fieldName = elementField.getAttribute("name");
            if (validFields != null && !validFields.contains(fieldName) && !fieldName.endsWith(DYNAMIC_FIELD_SUFFIX)) continue;
            if (tagName.equals("arr")) {
                NodeList arrayValues = elementField.getChildNodes();
                for (int j = 0; j < arrayValues.getLength(); ++j) {
                    Node nv = arrayValues.item(j);
                    if (nv instanceof Text) continue;
                    Node arrayValue = nv;
                    String valueString = arrayValue.getTextContent();
                    this.fieldList.add(new SolrElementField(fieldName, valueString));
                    this.fieldCounts.increment(fieldName);
                }
                continue;
            }
            if (this.hasField(fieldName)) continue;
            String valueString = elementField.getTextContent();
            this.fieldList.add(new SolrElementField(fieldName, valueString));
            this.fieldCounts.increment(fieldName);
        }
    }

    public List<SolrElementField> getFieldList() {
        return this.fieldList;
    }

    public Map<String, MutableInt> getFieldCounter() {
        return this.fieldCounts.counters;
    }

    public void serialize(OutputStream outputStream, String encoding) throws IOException {
        IOUtils.write(ELEMENT_DOC_OPEN, outputStream, encoding);
        for (SolrElementField field : this.getFieldList()) {
            field.serialize(outputStream, encoding);
        }
        IOUtils.write(ELEMENT_DOC_CLOSE, outputStream, encoding);
    }

    public boolean hasField(String fieldName) {
        return this.fieldCounts.getCount(fieldName) > 0;
    }

    public boolean hasFieldWithValue(String fieldName, String value) {
        if (this.hasField(fieldName)) {
            for (SolrElementField field : this.fieldList) {
                if (field.getName() == null || !field.getName().equals(fieldName) || !field.getValue().equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public SolrElementField getField(String fieldName) {
        SolrElementField searchField = null;
        if (this.hasField(fieldName)) {
            for (SolrElementField field : this.fieldList) {
                if (!field.getName().equals(fieldName)) continue;
                searchField = field;
                break;
            }
        }
        return searchField;
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getFirstFieldValue("id");
        }
        return this.identifier;
    }

    public String getSeriesId() {
        if (this.seriesId == null) {
            this.seriesId = this.getFirstFieldValue("seriesId");
        }
        return this.seriesId;
    }

    public boolean containsElement(SolrElementField field) {
        return this.getFieldList().contains(field);
    }

    public void addField(SolrElementField field) {
        this.getFieldList().add(field);
        this.fieldCounts.increment(field.getName());
    }

    public void removeField(String fieldToRemove) {
        if (fieldToRemove == null) {
            return;
        }
        SolrElementField temp = null;
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldToRemove)) continue;
            temp = field;
            break;
        }
        this.fieldList.remove(temp);
        this.fieldCounts.decrement(temp.getName());
    }

    public List<SolrElementField> getFields(String fieldName) {
        ArrayList<SolrElementField> fieldsToReturn = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            fieldsToReturn.add(field);
        }
        return fieldsToReturn;
    }

    public void removeAllFields(String fieldName) {
        List<SolrElementField> fieldsToRemove = this.getFields(fieldName);
        this.fieldList.removeAll(fieldsToRemove);
        this.fieldCounts.decrement(fieldName, fieldsToRemove.size());
    }

    public void removeFieldsWithValue(String name, String value) {
        ArrayList<SolrElementField> fieldsToRemove = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(name) || !field.getValue().equals(value)) continue;
            fieldsToRemove.add(field);
        }
        this.fieldList.removeAll(fieldsToRemove);
        this.fieldCounts.decrement(name, fieldsToRemove.size());
    }

    public void removeOneFieldWithValue(String name, String value) {
        ArrayList<SolrElementField> fieldsToRemove = new ArrayList<SolrElementField>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(name) || !field.getValue().equals(value)) continue;
            fieldsToRemove.add(field);
            break;
        }
        this.fieldList.removeAll(fieldsToRemove);
        this.fieldCounts.decrement(name, fieldsToRemove.size());
    }

    public String getFirstFieldValue(String fieldName) {
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            return field.getValue();
        }
        return null;
    }

    public List<String> getAllFieldValues(String fieldName) {
        ArrayList<String> allValues = new ArrayList<String>();
        for (SolrElementField field : this.fieldList) {
            if (!field.getName().equals(fieldName)) continue;
            allValues.add(field.getValue());
        }
        return allValues;
    }

    public void updateOrAddField(String fieldName, String fieldValue) {
        for (SolrElementField solrElementField : this.fieldList) {
            if (!solrElementField.getName().equals(fieldName)) continue;
            solrElementField.setValue(fieldValue);
            return;
        }
        SolrElementField field = new SolrElementField(fieldName, fieldValue);
        this.fieldList.add(field);
        this.fieldCounts.increment(fieldName);
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    public static boolean visibleInIndex(SystemMetadata smd) {
        if (smd == null) {
            return false;
        }
        if (smd.getArchived() == null) {
            return true;
        }
        return smd.getArchived() == false;
    }

    class FieldCounter {
        HashMap<String, MutableInt> counters = new HashMap();

        FieldCounter() {
        }

        public int getCount(String name) {
            if (this.counters.containsKey(name)) {
                return this.counters.get(name).intValue();
            }
            return 0;
        }

        public int increment(String name) {
            return this.increment(name, 1);
        }

        public int increment(String name, int howMany) {
            if (this.counters.containsKey(name)) {
                this.counters.get(name).add(howMany);
            } else {
                this.counters.put(name, new MutableInt(howMany));
            }
            return this.counters.get(name).intValue();
        }

        public int decrement(String name) {
            return this.decrement(name, 1);
        }

        public int decrement(String name, int howMany) {
            int count = 0;
            if (!this.counters.containsKey(name)) {
                return 0;
            }
            count = this.counters.get(name).intValue();
            if (howMany <= count) {
                this.counters.get(name).subtract(howMany);
                return howMany;
            }
            this.counters.get(name).setValue(0);
            return count;
        }
    }
}

