/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.log4j.Logger;

public class SolrElementField {
    private static Logger log = Logger.getLogger(SolrElementField.class);
    public static final String FIELD_ID = "id";
    public static final String FIELD_SERIES_ID = "seriesId";
    public static final String FIELD_OBJECTFORMAT = "formatId";
    public static final String FIELD_OBJECTFORMATTYPE = "formatType";
    public static final String FIELD_SIZE = "size";
    public static final String FIELD_CHECKSUM = "checksum";
    public static final String FIELD_CHECKSUMALGORITHM = "checksumAlgorithm";
    public static final String FIELD_SUBMITTER = "submitter";
    public static final String FIELD_RIGHTSHOLDER = "rightsHolder";
    public static final String FIELD_REP_ALLOWED = "replicationAllowed";
    public static final String FIELD_N_REPLICAS = "numberReplicas";
    public static final String FIELD_PREF_REP_MN = "preferredRelicationNM";
    public static final String FIELD_BLOCKED_REP_MN = "blockedReplicationMN";
    public static final String FIELD_OBSOLETES = "obsoletes";
    public static final String FIELD_OBSOLETED_BY = "obsoletedBy";
    public static final String FIELD_DATEUPLOADED = "dateUploaded";
    public static final String FIELD_DATEMODIFIED = "dateModified";
    public static final String FIELD_ORIGIN_MN = "datasource";
    public static final String FIELD_AUTH_MN = "authoritativeMN";
    public static final String FIELD_REPLICA_MN = "replicaMN";
    public static final String FIELD_RESOURCEMAP = "resourceMap";
    public static final String FIELD_DOCUMENTS = "documents";
    public static final String FIELD_ISDOCUMENTEDBY = "isDocumentedBy";
    public static final String FIELD_READPERMISSION = "readPermission";
    public static final String FIELD_WRITEPERMISSION = "writePermission";
    public static final String FIELD_EXECUTEPERMISSION = "executePermission";
    public static final String FIELD_CHANGEPERMISSION = "changePermission";
    public static final String FIELD_ISPUBLIC = "isPublic";
    public static final String FIELD_DECADE = "decade";
    public static final String FIELD_BEGIN_DATE = "beginDate";
    public static final String FIELD_END_DATE = "endDate";
    public static final char[] ELEMENT_FIELD_OPEN = "<field ".toCharArray();
    public static final char[] ELEMENT_FIELD_CLOSE = "</field>".toCharArray();
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_MODIFIER = "modifier";
    private String name = null;
    private String value = null;
    private Modifier modifier;
    private boolean escapeXML = true;

    public SolrElementField() {
    }

    public SolrElementField(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
    }

    public void serialize(OutputStream outputStream, String encoding) throws IOException {
        if (this.value == null || this.value.equals("")) {
            return;
        }
        IOUtils.write(ELEMENT_FIELD_OPEN, outputStream, encoding);
        CharArrayWriter cw = new CharArrayWriter();
        cw.append(ATTRIBUTE_NAME);
        cw.append("=\"");
        cw.append(this.name);
        cw.append("\" ");
        if (this.modifier != null) {
            cw.append(ATTRIBUTE_MODIFIER);
            cw.append("=\"");
            cw.append(this.modifier.toString());
            cw.append("\" ");
        }
        cw.append(">");
        IOUtils.write(cw.toCharArray(), outputStream, encoding);
        char[] toWrite = StringEscapeUtils.escapeXml11(this.value).toCharArray();
        IOUtils.write(toWrite, outputStream, encoding);
        IOUtils.write(ELEMENT_FIELD_CLOSE, outputStream, encoding);
        outputStream.flush();
        if (log.isDebugEnabled()) {
            log.debug("SolrElementField serializing field: " + this.name + " with value: " + this.value);
        }
    }

    public SolrElementField clone() {
        SolrElementField clone = new SolrElementField();
        clone.setName(this.name);
        clone.setValue(this.value);
        clone.setModifier(this.modifier);
        return clone;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        SolrElementField sef = (SolrElementField)other;
        return Objects.equals(this.name, sef.name) && Objects.equals(this.value, sef.value);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static enum Modifier {
        SET,
        ADD,
        ADD_DISTINCT,
        REMOVE,
        REMOVEREGEX,
        INC;


        public String toString() {
            if (this.equals((Object)ADD_DISTINCT)) {
                return "add-distinct";
            }
            return super.toString().toLowerCase();
        }
    }
}

