/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.indexer.solrhttp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dataone.service.util.DateTimeMarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SolrSchema {
    private String solrSchemaPath;
    private Map<String, ValueType> validSolrFieldNames = new HashMap<String, ValueType>();
    private Set<String> multiValuedSolrFieldNames = new HashSet<String>();
    private Map<String, String> fieldSegmentMap = new HashMap<String, String>();
    private Map<String, List<String>> segmentFieldsMap = new HashMap<String, List<String>>();
    private static Logger log = Logger.getLogger(SolrSchema.class.getName());

    public void setSolrSchemaPath(String path) throws ParserConfigurationException, SAXException, IOException {
        this.solrSchemaPath = path;
        this.loadSolrSchemaFields();
    }

    public void setFieldSegmentMap(Map<String, String> fieldSegmentMap) {
        this.fieldSegmentMap = fieldSegmentMap;
        log.debug("entering SolrSchema.setFieldSegmentMap( ) with parameter instance " + fieldSegmentMap);
        for (Map.Entry<String, String> n : this.fieldSegmentMap.entrySet()) {
            String field = n.getKey();
            String segment = n.getValue();
            if (!this.segmentFieldsMap.containsKey(segment)) {
                this.segmentFieldsMap.put(segment, new ArrayList());
            }
            this.segmentFieldsMap.get(segment).add(field);
        }
    }

    public Set<String> getValidFields() {
        return this.validSolrFieldNames.keySet();
    }

    public ValueType getFieldType(String name) {
        return this.validSolrFieldNames.get(name);
    }

    public boolean isFieldMultiValued(String fieldName) {
        return this.multiValuedSolrFieldNames.contains(fieldName);
    }

    public String getFieldSegment(String field) {
        return this.fieldSegmentMap.get(field);
    }

    public List<String> getAllSegmentFields(String segment) {
        log.trace("getAllSegmentFields(); map is " + this.segmentFieldsMap);
        return this.segmentFieldsMap.get(segment);
    }

    public Set<String> listSegments() {
        return this.segmentFieldsMap.keySet();
    }

    public Object convertToSolrType(String fieldName, String value) {
        ValueType type = this.validSolrFieldNames.get(fieldName);
        switch (type) {
            case LONG: {
                return Long.valueOf(value);
            }
            case INTEGER: {
                return Integer.valueOf(value);
            }
            case DATE: {
                return DateTimeMarshaller.deserializeDateToUTC(value);
            }
            case DOUBLE: {
                return Double.valueOf(value);
            }
            case FLOAT: {
                return Float.valueOf(value);
            }
            case BOOLEAN: {
                return Boolean.valueOf(value);
            }
        }
        return value;
    }

    private ValueType parseSolrValueType(String type) {
        ValueType mappedType;
        switch (type) {
            case "int": 
            case "tint": {
                mappedType = ValueType.INTEGER;
                break;
            }
            case "long": 
            case "tlong": {
                mappedType = ValueType.LONG;
                break;
            }
            case "double": 
            case "tdouble": {
                mappedType = ValueType.DOUBLE;
                break;
            }
            case "float": 
            case "tfloat": {
                mappedType = ValueType.FLOAT;
                break;
            }
            case "boolean": {
                mappedType = ValueType.BOOLEAN;
                break;
            }
            case "date": 
            case "tdate": {
                mappedType = ValueType.DATE;
                break;
            }
            case "string": 
            case "text_general": 
            case "text_en_splitting": {
                mappedType = ValueType.STRING;
                break;
            }
            default: {
                mappedType = ValueType.STRING;
            }
        }
        return mappedType;
    }

    private void loadSolrSchemaFields() throws ParserConfigurationException, SAXException, IOException {
        log.debug("entering SolrSchema.loadSolrSchemaFields()...path: " + this.solrSchemaPath);
        if (this.solrSchemaPath != null && this.validSolrFieldNames.isEmpty()) {
            Document doc = this.loadSolrSchemaDocument();
            NodeList nList = doc.getElementsByTagName("copyField");
            ArrayList<String> copyDestinationFields = new ArrayList<String>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String destinationField = node.getAttributes().getNamedItem("dest").getNodeValue();
                log.debug(" **** copy destination field: " + destinationField);
                copyDestinationFields.add(destinationField);
            }
            nList = doc.getElementsByTagName("field");
            HashMap<String, ValueType> fields = new HashMap<String, ValueType>();
            for (int i = 0; i < nList.getLength(); ++i) {
                Node node = nList.item(i);
                String fieldName = node.getAttributes().getNamedItem("name").getNodeValue();
                ValueType fieldType = this.parseSolrValueType(node.getAttributes().getNamedItem("type").getNodeValue());
                fields.put(fieldName, fieldType);
                log.debug("valid field name: " + fieldName + " type: " + (Object)((Object)fieldType));
                Node n = node.getAttributes().getNamedItem("multiValued");
                if (n == null || !"true".equals(n.getNodeValue())) continue;
                this.multiValuedSolrFieldNames.add(fieldName);
            }
            for (String cpf : copyDestinationFields) {
                fields.remove(cpf);
            }
            this.validSolrFieldNames = fields;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadSolrSchemaDocument() throws ParserConfigurationException, SAXException, IOException {
        Document document;
        log.info("loading schema document from path: " + this.solrSchemaPath);
        FileInputStream fis = null;
        try {
            Document doc;
            fis = new FileInputStream(new File(this.solrSchemaPath));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            document = doc = dBuilder.parse(fis);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fis);
            throw throwable;
        }
        IOUtils.closeQuietly(fis);
        return document;
    }

    static enum ValueType {
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        DATE,
        BOOLEAN,
        STRING;

    }
}

