/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.log;

import java.util.Date;
import org.dataone.cn.log.MetricEvent;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.util.DateTimeMarshaller;

public class MetricLogEntry {
    private Identifier pid;
    private NodeReference nodeId;
    private MetricEvent event;
    private Long timeToCompleteEventMS;
    private String threadName = Thread.currentThread().getName();
    private long threadId = Thread.currentThread().getId();
    private Date dateLogged = new Date(System.currentTimeMillis());
    private String message;

    public MetricLogEntry(MetricEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("MetricEvent may not be null");
        }
        this.event = event;
    }

    public MetricLogEntry(MetricEvent event, NodeReference nodeId) {
        this(event);
        this.nodeId = nodeId;
    }

    public MetricLogEntry(MetricEvent event, NodeReference nodeId, Identifier pid) {
        this(event, nodeId);
        this.pid = pid;
    }

    public MetricLogEntry(MetricEvent event, NodeReference nodeId, Identifier pid, String message) {
        this(event, nodeId, pid);
        this.message = message;
    }

    public MetricLogEntry(MetricEvent event, NodeReference nodeId, Identifier pid, String message, Long timeToCompleteEventMS) {
        this(event, nodeId, pid, message);
        this.timeToCompleteEventMS = timeToCompleteEventMS;
    }

    public MetricLogEntry(MetricEvent event, String message, NodeReference nodeId, Identifier pid, Long timeToCompleteEventMS, Date dateLogged) {
        this(event, nodeId, pid, message, timeToCompleteEventMS);
        if (dateLogged != null) {
            this.dateLogged = dateLogged;
        }
    }

    public Identifier getPid() {
        return this.pid;
    }

    public void setPid(Identifier pid) {
        this.pid = pid;
    }

    public NodeReference getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeReference nodeId) {
        this.nodeId = nodeId;
    }

    public MetricEvent getEvent() {
        return this.event;
    }

    public void setEvent(MetricEvent event) {
        this.event = event;
    }

    public Date getDateLogged() {
        return this.dateLogged;
    }

    public void setDateLogged(Date dateLogged) {
        this.dateLogged = dateLogged;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getTimeToCompleteEventMS() {
        return this.timeToCompleteEventMS;
    }

    public void setTimeToCompleteEventMS(Long timeToCompleteEventMS) {
        this.timeToCompleteEventMS = timeToCompleteEventMS;
    }

    public String toString() {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\"event\":\"");
        jsonBuilder.append(this.event.toString());
        jsonBuilder.append("\"");
        if (this.nodeId != null) {
            jsonBuilder.append(",\"nodeId\":\"");
            jsonBuilder.append(this.nodeId.getValue());
            jsonBuilder.append("\"");
        }
        if (this.pid != null) {
            jsonBuilder.append(",\"pid\":\"");
            jsonBuilder.append(this.pid.getValue());
            jsonBuilder.append("\"");
        }
        if (this.message != null) {
            jsonBuilder.append(",\"message\":\"");
            jsonBuilder.append(this.message);
            jsonBuilder.append("\"");
        }
        if (this.timeToCompleteEventMS != null) {
            jsonBuilder.append(",\"timeToCompleteEventMS\":");
            jsonBuilder.append(this.timeToCompleteEventMS);
        }
        jsonBuilder.append(",\"threadName\":\"");
        jsonBuilder.append(this.threadName);
        jsonBuilder.append("\"");
        jsonBuilder.append(",\"threadId\":");
        jsonBuilder.append(this.threadId);
        jsonBuilder.append(",\"dateLogged\":\"");
        jsonBuilder.append(DateTimeMarshaller.serializeDateToUTC(this.dateLogged));
        jsonBuilder.append("\"}");
        return jsonBuilder.toString();
    }
}

