/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.metamodel;

import java.io.Serializable;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.metamodel.AbstractManagedType;
import org.hibernate.ejb.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.ejb.metamodel.SingularAttributeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIdentifiableType<X>
extends AbstractManagedType<X>
implements IdentifiableType<X>,
Serializable {
    private final boolean hasIdentifierProperty;
    private final boolean isVersioned;
    private SingularAttributeImpl<X, ?> id;
    private SingularAttributeImpl<X, ?> version;
    private Set<SingularAttribute<? super X, ?>> idClassAttributes;

    public AbstractIdentifiableType(Class<X> javaType, AbstractIdentifiableType<? super X> superType, boolean hasIdentifierProperty, boolean versioned) {
        super(javaType, superType);
        this.hasIdentifierProperty = hasIdentifierProperty;
        this.isVersioned = versioned;
    }

    @Override
    public AbstractIdentifiableType<? super X> getSupertype() {
        return (AbstractIdentifiableType)super.getSupertype();
    }

    protected AbstractIdentifiableType<? super X> requireSupertype() {
        if (this.getSupertype() == null) {
            throw new IllegalStateException("No supertype found");
        }
        return this.getSupertype();
    }

    @Override
    public boolean hasSingleIdAttribute() {
        return this.hasIdentifierProperty;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getId(Class<Y> javaType) {
        SingularAttribute<X, Object> id_;
        if (this.id != null) {
            this.checkSimpleId();
            id_ = this.id;
            if (javaType != this.id.getJavaType()) {
                throw new IllegalArgumentException("Id attribute was not of specified type : " + javaType.getName());
            }
        } else {
            AbstractManagedType supertype;
            id_ = this instanceof MappedSuperclassTypeImpl ? ((supertype = this.getSupertype()) != null ? ((AbstractIdentifiableType)supertype).getId(javaType) : null) : this.requireSupertype().getId(javaType);
        }
        return id_;
    }

    protected void checkSimpleId() {
        if (!this.hasIdentifierProperty) {
            throw new IllegalStateException("This class uses an @IdClass");
        }
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredId(Class<Y> javaType) {
        this.checkDeclaredId();
        this.checkSimpleId();
        if (javaType != this.id.getJavaType()) {
            throw new IllegalArgumentException("Id attribute was not of specified type : " + javaType.getName());
        }
        return this.id;
    }

    protected void checkDeclaredId() {
        if (this.id == null) {
            throw new IllegalArgumentException("The id attribute is not declared on this type");
        }
    }

    @Override
    public Type<?> getIdType() {
        if (this.id != null) {
            this.checkSimpleId();
            return this.id.getType();
        }
        return this.requireSupertype().getIdType();
    }

    @Override
    public Set<SingularAttribute<? super X, ?>> getIdClassAttributes() {
        this.checkIdClass();
        return this.idClassAttributes;
    }

    private void checkIdClass() {
        if (this.hasIdentifierProperty) {
            throw new IllegalArgumentException("This class does not use @IdClass");
        }
    }

    @Override
    public boolean hasVersionAttribute() {
        return this.isVersioned;
    }

    public boolean hasDeclaredVersionAttribute() {
        return this.isVersioned && this.version != null;
    }

    @Override
    public <Y> SingularAttribute<? super X, Y> getVersion(Class<Y> javaType) {
        SingularAttribute<X, Object> version_;
        if (!this.hasVersionAttribute()) {
            return null;
        }
        if (this.version != null) {
            version_ = this.version;
            if (javaType != this.version.getJavaType()) {
                throw new IllegalArgumentException("Version attribute was not of specified type : " + javaType.getName());
            }
        } else {
            version_ = this.requireSupertype().getVersion(javaType);
        }
        return version_;
    }

    @Override
    public <Y> SingularAttribute<X, Y> getDeclaredVersion(Class<Y> javaType) {
        this.checkDeclaredVersion();
        if (javaType != this.version.getJavaType()) {
            throw new IllegalArgumentException("Version attribute was not of specified type : " + javaType.getName());
        }
        return this.version;
    }

    public SingularAttribute<X, ?> getDeclaredVersion() {
        this.checkDeclaredVersion();
        return this.version;
    }

    protected void checkDeclaredVersion() {
        if (this.version == null || this.getSupertype() != null && ((AbstractIdentifiableType)this.getSupertype()).hasVersionAttribute()) {
            throw new IllegalArgumentException("The version attribute is not declared on this type");
        }
    }

    @Override
    public Builder<X> getBuilder() {
        final AbstractManagedType.Builder managedBuilder = super.getBuilder();
        return new Builder<X>(){

            @Override
            public void applyIdAttribute(SingularAttributeImpl<X, ?> idAttribute) {
                AbstractIdentifiableType.this.id = idAttribute;
                managedBuilder.addAttribute(idAttribute);
            }

            @Override
            public void applyIdClassAttributes(Set<SingularAttribute<? super X, ?>> idClassAttributes) {
                AbstractIdentifiableType.this.idClassAttributes = idClassAttributes;
            }

            @Override
            public void applyVersionAttribute(SingularAttributeImpl<X, ?> versionAttribute) {
                AbstractIdentifiableType.this.version = versionAttribute;
                managedBuilder.addAttribute(versionAttribute);
            }

            @Override
            public void addAttribute(Attribute<X, ?> attribute) {
                managedBuilder.addAttribute(attribute);
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Builder<X>
    extends AbstractManagedType.Builder<X> {
        public void applyIdAttribute(SingularAttributeImpl<X, ?> var1);

        public void applyIdClassAttributes(Set<SingularAttribute<? super X, ?>> var1);

        public void applyVersionAttribute(SingularAttributeImpl<X, ?> var1);
    }
}

