/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ASTPair;
import antlr.MismatchedTokenException;
import antlr.RecognitionException;
import antlr.Token;
import antlr.TokenStream;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import org.hibernate.QueryException;
import org.hibernate.hql.antlr.HqlBaseParser;
import org.hibernate.hql.antlr.HqlTokenTypes;
import org.hibernate.hql.ast.ErrorCounter;
import org.hibernate.hql.ast.HqlASTFactory;
import org.hibernate.hql.ast.HqlLexer;
import org.hibernate.hql.ast.HqlToken;
import org.hibernate.hql.ast.ParseErrorHandler;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.hql.ast.util.ASTUtil;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HqlParser
extends HqlBaseParser {
    private static final Logger log = LoggerFactory.getLogger(HqlParser.class);
    private final boolean trace = log.isTraceEnabled();
    private ParseErrorHandler parseErrorHandler;
    private ASTPrinter printer = HqlParser.getASTPrinter();
    private int traceDepth = 0;

    private static ASTPrinter getASTPrinter() {
        return new ASTPrinter(HqlTokenTypes.class);
    }

    public static HqlParser getInstance(String hql) {
        HqlLexer lexer = new HqlLexer(new StringReader(hql));
        return new HqlParser(lexer);
    }

    private HqlParser(TokenStream lexer) {
        super(lexer);
        this.initialize();
    }

    public void traceIn(String ruleName) {
        if (this.trace) {
            if (this.inputState.guessing > 0) {
                return;
            }
            String prefix = StringHelper.repeat('-', this.traceDepth++ * 2) + "-> ";
            log.trace(prefix + ruleName);
        }
    }

    public void traceOut(String ruleName) {
        if (this.trace) {
            if (this.inputState.guessing > 0) {
                return;
            }
            String prefix = "<-" + StringHelper.repeat('-', --this.traceDepth * 2) + " ";
            log.trace(prefix + ruleName);
        }
    }

    public void reportError(RecognitionException e2) {
        this.parseErrorHandler.reportError(e2);
    }

    public void reportError(String s) {
        this.parseErrorHandler.reportError(s);
    }

    public void reportWarning(String s) {
        this.parseErrorHandler.reportWarning(s);
    }

    public ParseErrorHandler getParseErrorHandler() {
        return this.parseErrorHandler;
    }

    public AST handleIdentifierError(Token token, RecognitionException ex) throws RecognitionException, TokenStreamException {
        HqlToken hqlToken;
        if (token instanceof HqlToken && (hqlToken = (HqlToken)token).isPossibleID() && ex instanceof MismatchedTokenException) {
            MismatchedTokenException mte = (MismatchedTokenException)ex;
            if (mte.expecting == 126) {
                this.reportWarning("Keyword  '" + token.getText() + "' is being interpreted as an identifier due to: " + mte.getMessage());
                ASTPair currentAST = new ASTPair();
                token.setType(93);
                this.astFactory.addASTChild(currentAST, this.astFactory.create(token));
                this.consume();
                AST identifierAST = currentAST.root;
                return identifierAST;
            }
        }
        return super.handleIdentifierError(token, ex);
    }

    public AST negateNode(AST x) {
        switch (x.getType()) {
            case 40: {
                x.setType(6);
                x.setText("{and}");
                x.setFirstChild(this.negateNode(x.getFirstChild()));
                x.getFirstChild().setNextSibling(this.negateNode(x.getFirstChild().getNextSibling()));
                return x;
            }
            case 6: {
                x.setType(40);
                x.setText("{or}");
                x.setFirstChild(this.negateNode(x.getFirstChild()));
                x.getFirstChild().setNextSibling(this.negateNode(x.getFirstChild().getNextSibling()));
                return x;
            }
            case 102: {
                x.setType(108);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 108: {
                x.setType(102);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 111: {
                x.setType(112);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 110: {
                x.setType(113);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 113: {
                x.setType(110);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 112: {
                x.setType(111);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 34: {
                x.setType(84);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 84: {
                x.setType(34);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 26: {
                x.setType(83);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 83: {
                x.setType(26);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 80: {
                x.setType(79);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 79: {
                x.setType(80);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 10: {
                x.setType(82);
                x.setText("{not}" + x.getText());
                return x;
            }
            case 82: {
                x.setType(10);
                x.setText("{not}" + x.getText());
                return x;
            }
        }
        AST not2 = super.negateNode(x);
        if (not2 != x) {
            not2.setNextSibling(x.getNextSibling());
            x.setNextSibling(null);
        }
        return not2;
    }

    public AST processEqualityExpression(AST x) {
        if (x == null) {
            log.warn("processEqualityExpression() : No expression to process!");
            return null;
        }
        int type = x.getType();
        if (type == 102 || type == 108) {
            boolean negated;
            boolean bl = negated = type == 108;
            if (x.getNumberOfChildren() == 2) {
                AST a = x.getFirstChild();
                AST b = a.getNextSibling();
                if (a.getType() == 39 && b.getType() != 39) {
                    return this.createIsNullParent(b, negated);
                }
                if (b.getType() == 39 && a.getType() != 39) {
                    return this.createIsNullParent(a, negated);
                }
                if (b.getType() == 62) {
                    return this.processIsEmpty(a, negated);
                }
                return x;
            }
            return x;
        }
        return x;
    }

    private AST createIsNullParent(AST node, boolean negated) {
        node.setNextSibling(null);
        int type = negated ? 79 : 80;
        String text = negated ? "is not null" : "is null";
        return ASTUtil.createParent(this.astFactory, type, text, node);
    }

    private AST processIsEmpty(AST node, boolean negated) {
        node.setNextSibling(null);
        AST ast = this.createSubquery(node);
        ast = ASTUtil.createParent(this.astFactory, 19, "exists", ast);
        if (!negated) {
            ast = ASTUtil.createParent(this.astFactory, 38, "not", ast);
        }
        return ast;
    }

    private AST createSubquery(AST node) {
        AST ast = ASTUtil.createParent(this.astFactory, 87, "RANGE", node);
        ast = ASTUtil.createParent(this.astFactory, 22, "from", ast);
        ast = ASTUtil.createParent(this.astFactory, 89, "SELECT_FROM", ast);
        ast = ASTUtil.createParent(this.astFactory, 86, "QUERY", ast);
        return ast;
    }

    public void showAst(AST ast, PrintStream out) {
        this.showAst(ast, new PrintWriter(out));
    }

    private void showAst(AST ast, PrintWriter pw) {
        this.printer.showAst(ast, pw);
    }

    private void initialize() {
        this.parseErrorHandler = new ErrorCounter();
        this.setASTFactory(new HqlASTFactory());
    }

    public void weakKeywords() throws TokenStreamException {
        int t = this.LA(1);
        switch (t) {
            case 24: 
            case 41: {
                if (this.LA(2) == 105) break;
                this.LT(1).setType(126);
                if (!log.isDebugEnabled()) break;
                log.debug("weakKeywords() : new LT(1) token - " + this.LT(1));
                break;
            }
            default: {
                HqlToken hqlToken;
                if (this.LA(0) != 22 || t == 126 || this.LA(2) != 15 || !(hqlToken = (HqlToken)this.LT(1)).isPossibleID()) break;
                hqlToken.setType(126);
                if (!log.isDebugEnabled()) break;
                log.debug("weakKeywords() : new LT(1) token - " + this.LT(1));
            }
        }
    }

    public void handleDotIdent() throws TokenStreamException {
        HqlToken t;
        if (this.LA(1) == 15 && this.LA(2) != 126 && (t = (HqlToken)this.LT(2)).isPossibleID()) {
            this.LT(2).setType(126);
            if (log.isDebugEnabled()) {
                log.debug("handleDotIdent() : new LT(2) token - " + this.LT(1));
            }
        }
    }

    public void processMemberOf(Token n, AST p, ASTPair currentAST) {
        AST inAst = n == null ? this.astFactory.create(26, "in") : this.astFactory.create(83, "not in");
        this.astFactory.makeASTRoot(currentAST, inAst);
        AST ast = this.createSubquery(p);
        ast = ASTUtil.createParent(this.astFactory, 77, "inList", ast);
        inAst.addChild(ast);
    }

    public static void panic() {
        throw new QueryException("Parser: panic");
    }
}

