/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.access.EntityRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.Mapping;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.persister.collection.BasicCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.OneToManyPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

public final class PersisterFactory {
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{PersistentClass.class, EntityRegionAccessStrategy.class, SessionFactoryImplementor.class, Mapping.class};
    private static final Class[] COLLECTION_PERSISTER_CONSTRUCTOR_ARGS = new Class[]{Collection.class, CollectionRegionAccessStrategy.class, Configuration.class, SessionFactoryImplementor.class};

    private PersisterFactory() {
    }

    public static EntityPersister createClassPersister(PersistentClass model, EntityRegionAccessStrategy cacheAccessStrategy, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Class persisterClass = model.getEntityPersisterClass();
        if (persisterClass == null || persisterClass == SingleTableEntityPersister.class) {
            return new SingleTableEntityPersister(model, cacheAccessStrategy, factory, cfg);
        }
        if (persisterClass == JoinedSubclassEntityPersister.class) {
            return new JoinedSubclassEntityPersister(model, cacheAccessStrategy, factory, cfg);
        }
        if (persisterClass == UnionSubclassEntityPersister.class) {
            return new UnionSubclassEntityPersister(model, cacheAccessStrategy, factory, cfg);
        }
        return PersisterFactory.create(persisterClass, model, cacheAccessStrategy, factory, cfg);
    }

    public static CollectionPersister createCollectionPersister(Configuration cfg, Collection model, CollectionRegionAccessStrategy cacheAccessStrategy, SessionFactoryImplementor factory) throws HibernateException {
        Class persisterClass = model.getCollectionPersisterClass();
        if (persisterClass == null) {
            return model.isOneToMany() ? new OneToManyPersister(model, cacheAccessStrategy, cfg, factory) : new BasicCollectionPersister(model, cacheAccessStrategy, cfg, factory);
        }
        return PersisterFactory.create(persisterClass, cfg, model, cacheAccessStrategy, factory);
    }

    private static EntityPersister create(Class persisterClass, PersistentClass model, EntityRegionAccessStrategy cacheAccessStrategy, SessionFactoryImplementor factory, Mapping cfg) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e2) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e2);
        }
        try {
            return (EntityPersister)pc.newInstance(model, cacheAccessStrategy, factory, cfg);
        }
        catch (InvocationTargetException ite) {
            Throwable e3 = ite.getTargetException();
            if (e3 instanceof HibernateException) {
                throw (HibernateException)e3;
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e3);
        }
        catch (Exception e4) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e4);
        }
    }

    private static CollectionPersister create(Class persisterClass, Configuration cfg, Collection model, CollectionRegionAccessStrategy cacheAccessStrategy, SessionFactoryImplementor factory) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(COLLECTION_PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e2) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e2);
        }
        try {
            return (CollectionPersister)pc.newInstance(model, cacheAccessStrategy, cfg, factory);
        }
        catch (InvocationTargetException ite) {
            Throwable e3 = ite.getTargetException();
            if (e3 instanceof HibernateException) {
                throw (HibernateException)e3;
            }
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e3);
        }
        catch (Exception e4) {
            throw new MappingException("Could not instantiate collection persister " + persisterClass.getName(), e4);
        }
    }
}

