/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transform;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.property.ChainedPropertyAccessor;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.property.PropertyAccessorFactory;
import org.hibernate.property.Setter;
import org.hibernate.transform.ResultTransformer;

public class AliasToBeanResultTransformer
implements ResultTransformer,
Serializable {
    private final Class resultClass;
    private boolean isInitialized;
    private String[] aliases;
    private Setter[] setters;

    public AliasToBeanResultTransformer(Class resultClass) {
        if (resultClass == null) {
            throw new IllegalArgumentException("resultClass cannot be null");
        }
        this.isInitialized = false;
        this.resultClass = resultClass;
    }

    public Object transformTuple(Object[] tuple, String[] aliases) {
        Object result;
        try {
            if (!this.isInitialized) {
                this.initialize(aliases);
            } else {
                this.check(aliases);
            }
            result = this.resultClass.newInstance();
            for (int i = 0; i < aliases.length; ++i) {
                if (this.setters[i] == null) continue;
                this.setters[i].set(result, tuple[i], null);
            }
        }
        catch (InstantiationException e2) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        catch (IllegalAccessException e3) {
            throw new HibernateException("Could not instantiate resultclass: " + this.resultClass.getName());
        }
        return result;
    }

    private void initialize(String[] aliases) {
        ChainedPropertyAccessor propertyAccessor = new ChainedPropertyAccessor(new PropertyAccessor[]{PropertyAccessorFactory.getPropertyAccessor(this.resultClass, null), PropertyAccessorFactory.getPropertyAccessor("field")});
        this.aliases = new String[aliases.length];
        this.setters = new Setter[aliases.length];
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (alias == null) continue;
            this.aliases[i] = alias;
            this.setters[i] = propertyAccessor.getSetter(this.resultClass, alias);
        }
        this.isInitialized = true;
    }

    private void check(String[] aliases) {
        if (!Arrays.equals(aliases, this.aliases)) {
            throw new IllegalStateException("aliases are different from what is cached; aliases=" + Arrays.asList(aliases) + " cached=" + Arrays.asList(this.aliases));
        }
    }

    public List transformList(List collection) {
        return collection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasToBeanResultTransformer that = (AliasToBeanResultTransformer)o;
        if (!this.resultClass.equals(that.resultClass)) {
            return false;
        }
        return Arrays.equals(this.aliases, that.aliases);
    }

    public int hashCode() {
        int result = this.resultClass.hashCode();
        result = 31 * result + (this.aliases != null ? Arrays.hashCode(this.aliases) : 0);
        return result;
    }
}

