/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.beans.PropertyDescriptorComparator;
import org.springframework.beans.SimpleIndexedPropertyDescriptor;
import org.springframework.beans.SimpleNonIndexedPropertyDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtendedBeanInfo
implements BeanInfo {
    private final BeanInfo delegate;
    private final Set<PropertyDescriptor> propertyDescriptors = new TreeSet<PropertyDescriptor>(new PropertyDescriptorComparator());

    public ExtendedBeanInfo(BeanInfo delegate) throws IntrospectionException {
        this.delegate = delegate;
        PropertyDescriptor[] propertyDescriptorArray = delegate.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            this.propertyDescriptors.add(pd instanceof IndexedPropertyDescriptor ? new SimpleIndexedPropertyDescriptor((IndexedPropertyDescriptor)pd) : new SimpleNonIndexedPropertyDescriptor(pd));
            ++n2;
        }
        for (Method method : this.findCandidateWriteMethods(delegate.getMethodDescriptors())) {
            this.handleCandidateWriteMethod(method);
        }
    }

    private List<Method> findCandidateWriteMethods(MethodDescriptor[] methodDescriptors) {
        ArrayList<Method> matches2 = new ArrayList<Method>();
        MethodDescriptor[] methodDescriptorArray = methodDescriptors;
        int n = methodDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDescriptor methodDescriptor = methodDescriptorArray[n2];
            Method method = methodDescriptor.getMethod();
            if (ExtendedBeanInfo.isCandidateWriteMethod(method)) {
                matches2.add(method);
            }
            ++n2;
        }
        Collections.sort(matches2, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m2) {
                return m2.toString().compareTo(m1.toString());
            }
        });
        return matches2;
    }

    public static boolean isCandidateWriteMethod(Method method) {
        String methodName = method.getName();
        Class<?>[] parameterTypes = method.getParameterTypes();
        int nParams = parameterTypes.length;
        return methodName.length() > 3 && methodName.startsWith("set") && Modifier.isPublic(method.getModifiers()) && (!Void.TYPE.isAssignableFrom(method.getReturnType()) || Modifier.isStatic(method.getModifiers())) && (nParams == 1 || nParams == 2 && parameterTypes[0].equals(Integer.TYPE));
    }

    private void handleCandidateWriteMethod(Method method) throws IntrospectionException {
        int nParams = method.getParameterTypes().length;
        String propertyName = this.propertyNameFor(method);
        Class<?> propertyType = method.getParameterTypes()[nParams - 1];
        PropertyDescriptor existingPD = this.findExistingPropertyDescriptor(propertyName, propertyType);
        if (nParams == 1) {
            if (existingPD == null) {
                this.propertyDescriptors.add(new SimpleNonIndexedPropertyDescriptor(propertyName, null, method));
            } else {
                existingPD.setWriteMethod(method);
            }
        } else if (nParams == 2) {
            if (existingPD == null) {
                this.propertyDescriptors.add(new SimpleIndexedPropertyDescriptor(propertyName, null, null, null, method));
            } else if (existingPD instanceof IndexedPropertyDescriptor) {
                ((IndexedPropertyDescriptor)existingPD).setIndexedWriteMethod(method);
            } else {
                this.propertyDescriptors.remove(existingPD);
                this.propertyDescriptors.add(new SimpleIndexedPropertyDescriptor(propertyName, existingPD.getReadMethod(), existingPD.getWriteMethod(), null, method));
            }
        } else {
            throw new IllegalArgumentException("write method must have exactly 1 or 2 parameters: " + method);
        }
    }

    private PropertyDescriptor findExistingPropertyDescriptor(String propertyName, Class<?> propertyType) {
        for (PropertyDescriptor pd : this.propertyDescriptors) {
            Class<?> candidateType;
            String candidateName = pd.getName();
            if (pd instanceof IndexedPropertyDescriptor) {
                IndexedPropertyDescriptor ipd = (IndexedPropertyDescriptor)pd;
                candidateType = ipd.getIndexedPropertyType();
                if (!candidateName.equals(propertyName) || !candidateType.equals(propertyType) && !candidateType.equals(propertyType.getComponentType())) continue;
                return pd;
            }
            candidateType = pd.getPropertyType();
            if (!candidateName.equals(propertyName) || !candidateType.equals(propertyType) && !propertyType.equals(candidateType.getComponentType())) continue;
            return pd;
        }
        return null;
    }

    private String propertyNameFor(Method method) {
        return Introspector.decapitalize(method.getName().substring(3, method.getName().length()));
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptors.toArray(new PropertyDescriptor[this.propertyDescriptors.size()]);
    }

    @Override
    public BeanInfo[] getAdditionalBeanInfo() {
        return this.delegate.getAdditionalBeanInfo();
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return this.delegate.getBeanDescriptor();
    }

    @Override
    public int getDefaultEventIndex() {
        return this.delegate.getDefaultEventIndex();
    }

    @Override
    public int getDefaultPropertyIndex() {
        return this.delegate.getDefaultPropertyIndex();
    }

    @Override
    public EventSetDescriptor[] getEventSetDescriptors() {
        return this.delegate.getEventSetDescriptors();
    }

    @Override
    public Image getIcon(int iconKind) {
        return this.delegate.getIcon(iconKind);
    }

    @Override
    public MethodDescriptor[] getMethodDescriptors() {
        return this.delegate.getMethodDescriptors();
    }
}

