/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.web;

import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.SortHandlerMethodArgumentResolver;
import org.springframework.hateoas.mvc.UriComponentsContributor;
import org.springframework.util.Assert;
import org.springframework.web.util.UriComponentsBuilder;

public class HateoasSortHandlerMethodArgumentResolver
extends SortHandlerMethodArgumentResolver
implements UriComponentsContributor {
    public void enhance(UriComponentsBuilder builder, MethodParameter parameter, Object value) {
        if (!(value instanceof Sort)) {
            return;
        }
        Sort sort = (Sort)value;
        String sortParameter = this.getSortParameter(parameter);
        if (this.legacyMode) {
            List<String> expressions = this.legacyFoldExpressions(sort);
            Assert.isTrue(expressions.size() == 2, String.format("Expected 2 sort expressions (fields, direction) but got %d!", expressions.size()));
            builder.replaceQueryParam(sortParameter, expressions.get(0));
            builder.replaceQueryParam(this.getLegacyDirectionParameter(parameter), expressions.get(1));
        } else {
            builder.replaceQueryParam(sortParameter, new Object[0]);
            for (String expression : this.foldIntoExpressions(sort)) {
                builder.queryParam(sortParameter, expression);
            }
        }
    }
}

