/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.jndi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleNamingContext
implements Context {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String root;
    private final Hashtable<String, Object> boundObjects;
    private final Hashtable<String, Object> environment = new Hashtable();

    public SimpleNamingContext() {
        this("");
    }

    public SimpleNamingContext(String root2) {
        this.root = root2;
        this.boundObjects = new Hashtable();
    }

    public SimpleNamingContext(String root2, Hashtable<String, Object> boundObjects, Hashtable<String, Object> env) {
        this.root = root2;
        this.boundObjects = boundObjects;
        if (env != null) {
            this.environment.putAll(env);
        }
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String root2) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Listing name/class pairs under [" + root2 + "]");
        }
        return new NameClassPairEnumeration(this, root2);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String root2) throws NamingException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Listing bindings under [" + root2 + "]");
        }
        return new BindingEnumeration(this, root2);
    }

    @Override
    public Object lookup(String lookupName) throws NameNotFoundException {
        String name = String.valueOf(this.root) + lookupName;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Static JNDI lookup: [" + name + "]");
        }
        if ("".equals(name)) {
            return new SimpleNamingContext(this.root, this.boundObjects, this.environment);
        }
        Object found = this.boundObjects.get(name);
        if (found == null) {
            if (!name.endsWith("/")) {
                name = String.valueOf(name) + "/";
            }
            for (String boundName : this.boundObjects.keySet()) {
                if (!boundName.startsWith(name)) continue;
                return new SimpleNamingContext(name, this.boundObjects, this.environment);
            }
            throw new NameNotFoundException("Name [" + this.root + lookupName + "] not bound; " + this.boundObjects.size() + " bindings: [" + StringUtils.collectionToDelimitedString((Collection)this.boundObjects.keySet(), ",") + "]");
        }
        return found;
    }

    @Override
    public Object lookupLink(String name) throws NameNotFoundException {
        return this.lookup(name);
    }

    @Override
    public void bind(String name, Object obj) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Static JNDI binding: [" + this.root + name + "] = [" + obj + "]");
        }
        this.boundObjects.put(String.valueOf(this.root) + name, obj);
    }

    @Override
    public void unbind(String name) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Static JNDI remove: [" + this.root + name + "]");
        }
        this.boundObjects.remove(String.valueOf(this.root) + name);
    }

    @Override
    public void rebind(String name, Object obj) {
        this.bind(name, obj);
    }

    @Override
    public void rename(String oldName, String newName) throws NameNotFoundException {
        Object obj = this.lookup(oldName);
        this.unbind(oldName);
        this.bind(newName, obj);
    }

    @Override
    public Context createSubcontext(String name) {
        String subcontextName = String.valueOf(this.root) + name;
        if (!subcontextName.endsWith("/")) {
            subcontextName = String.valueOf(subcontextName) + "/";
        }
        SimpleNamingContext subcontext = new SimpleNamingContext(subcontextName, this.boundObjects, this.environment);
        this.bind(name, (Object)subcontext);
        return subcontext;
    }

    @Override
    public void destroySubcontext(String name) {
        this.unbind(name);
    }

    @Override
    public String composeName(String name, String prefix) {
        return String.valueOf(prefix) + name;
    }

    public Hashtable<String, Object> getEnvironment() {
        return this.environment;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) {
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) {
        return this.environment.remove(propName);
    }

    @Override
    public void close() {
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("SimpleNamingContext does not support [javax.naming.Name]");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class AbstractNamingEnumeration<T>
    implements NamingEnumeration<T> {
        private Iterator<T> iterator;

        private AbstractNamingEnumeration(SimpleNamingContext context, String proot) throws NamingException {
            if (!"".equals(proot) && !proot.endsWith("/")) {
                proot = String.valueOf(proot) + "/";
            }
            String root2 = String.valueOf(context.root) + proot;
            HashMap<String, T> contents = new HashMap<String, T>();
            for (String boundName : context.boundObjects.keySet()) {
                String strippedName;
                if (!boundName.startsWith(root2)) continue;
                int startIndex = root2.length();
                int endIndex = boundName.indexOf(47, startIndex);
                String string = strippedName = endIndex != -1 ? boundName.substring(startIndex, endIndex) : boundName.substring(startIndex);
                if (contents.containsKey(strippedName)) continue;
                try {
                    contents.put(strippedName, this.createObject(strippedName, context.lookup(String.valueOf(proot) + strippedName)));
                }
                catch (NameNotFoundException nameNotFoundException) {}
            }
            if (contents.size() == 0) {
                throw new NamingException("Invalid root: [" + context.root + proot + "]");
            }
            this.iterator = contents.values().iterator();
        }

        protected abstract T createObject(String var1, Object var2);

        @Override
        public boolean hasMore() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.iterator.hasNext();
        }

        @Override
        public T nextElement() {
            return this.iterator.next();
        }

        @Override
        public void close() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BindingEnumeration
    extends AbstractNamingEnumeration<Binding> {
        private BindingEnumeration(SimpleNamingContext context, String root2) throws NamingException {
            super(context, root2);
        }

        @Override
        protected Binding createObject(String strippedName, Object obj) {
            return new Binding(strippedName, obj);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NameClassPairEnumeration
    extends AbstractNamingEnumeration<NameClassPair> {
        private NameClassPairEnumeration(SimpleNamingContext context, String root2) throws NamingException {
            super(context, root2);
        }

        @Override
        protected NameClassPair createObject(String strippedName, Object obj) {
            return new NameClassPair(strippedName, obj.getClass().getName());
        }
    }
}

